/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.adbc.driver.jdbc;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.util.AutoCloseables;
import org.apache.arrow.vector.VectorLoader;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.VectorUnloader;
import org.apache.arrow.vector.ipc.ArrowReader;
import org.apache.arrow.vector.ipc.message.ArrowRecordBatch;
import org.apache.arrow.vector.types.pojo.Schema;

class RootArrowReader
extends ArrowReader {
    private final Schema schema;
    private final List<ArrowRecordBatch> batches;
    int nextIndex;

    public RootArrowReader(BufferAllocator allocator, Schema schema, List<ArrowRecordBatch> batches) {
        super(allocator);
        this.schema = schema;
        this.batches = batches;
        this.nextIndex = 0;
    }

    public static ArrowReader fromRoot(BufferAllocator allocator, VectorSchemaRoot root) {
        ArrowRecordBatch recordBatch = new VectorUnloader(root).getRecordBatch();
        return new RootArrowReader(allocator, root.getSchema(), Collections.singletonList(recordBatch));
    }

    public boolean loadNextBatch() throws IOException {
        if (this.nextIndex < this.batches.size()) {
            new VectorLoader(this.getVectorSchemaRoot()).load(this.batches.get(this.nextIndex++));
            return true;
        }
        return false;
    }

    public long bytesRead() {
        return 0L;
    }

    protected void closeReadSource() throws IOException {
        try {
            AutoCloseables.close(this.batches);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    protected Schema readSchema() {
        return this.schema;
    }
}

