/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.adbc.driver.jdbc.adapter;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.arrow.adapter.jdbc.JdbcFieldInfo;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class JdbcFieldInfoExtra {
    final JdbcFieldInfo info;
    final String typeName;
    final int numPrecRadix;
    final @Nullable String remarks;
    final @Nullable String columnDef;
    final int sqlDataType;
    final int sqlDatetimeSub;
    final int charOctetLength;
    final int ordinalPosition;

    public JdbcFieldInfoExtra(ResultSet rs) throws SQLException {
        int dataType = rs.getInt("DATA_TYPE");
        @Nullable String maybeTypeName = rs.getString("TYPE_NAME");
        if (maybeTypeName == null) {
            throw new RuntimeException("Field TYPE_NAME was null");
        }
        this.typeName = maybeTypeName;
        int columnSize = rs.getInt("COLUMN_SIZE");
        int decimalDigits = rs.getInt("DECIMAL_DIGITS");
        this.numPrecRadix = rs.getInt("NUM_PREC_RADIX");
        int nullable = rs.getInt("NULLABLE");
        this.remarks = rs.getString("REMARKS");
        this.columnDef = rs.getString("COLUMN_DEF");
        this.sqlDataType = rs.getInt("SQL_DATA_TYPE");
        this.sqlDatetimeSub = rs.getInt("SQL_DATETIME_SUB");
        this.charOctetLength = rs.getInt("CHAR_OCTET_LENGTH");
        this.ordinalPosition = rs.getInt("ORDINAL_POSITION");
        this.info = new JdbcFieldInfo(dataType, nullable, columnSize, decimalDigits);
    }

    public JdbcFieldInfo getFieldInfo() {
        return this.info;
    }

    public int getJdbcType() {
        return this.info.getJdbcType();
    }

    public String getTypeName() {
        return this.typeName;
    }

    public int getNumPrecRadix() {
        return this.numPrecRadix;
    }

    public @Nullable String getRemarks() {
        return this.remarks;
    }

    public @Nullable String getColumnDef() {
        return this.columnDef;
    }

    public int getSqlDataType() {
        return this.sqlDataType;
    }

    public int getSqlDatetimeSub() {
        return this.sqlDatetimeSub;
    }

    public int getCharOctetLength() {
        return this.charOctetLength;
    }

    public int getOrdinalPosition() {
        return this.ordinalPosition;
    }

    public int isNullable() {
        return this.info.isNullable();
    }

    public int getPrecision() {
        return this.info.getPrecision();
    }

    public int getScale() {
        return this.info.getScale();
    }

    public int getColumn() {
        return this.info.getColumn();
    }

    public String toString() {
        return "JdbcFieldInfoExtra{dataType=" + this.info.getJdbcType() + ", typeName='" + this.typeName + '\'' + ", columnSize=" + this.info.getPrecision() + ", decimalDigits=" + this.info.getScale() + ", numPrecRadix=" + this.numPrecRadix + ", nullable=" + this.info.isNullable() + ", remarks='" + this.remarks + '\'' + ", columnDef='" + this.columnDef + '\'' + ", sqlDataType=" + this.sqlDataType + ", sqlDatetimeSub=" + this.sqlDatetimeSub + ", charOctetLength=" + this.charOctetLength + ", ordinalPosition=" + this.ordinalPosition + '}';
    }
}

