/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.parser;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.function.UnaryOperator;
import org.apache.calcite.sql.SqlDialect;
import org.apache.calcite.sql.parser.SqlParserTest;
import org.apache.calcite.sql.parser.StringAndPos;
import org.apache.calcite.sql.test.SqlTestFactory;
import org.checkerframework.checker.nullness.qual.Nullable;

class SqlParserListFixture {
    final SqlTestFactory factory;
    final SqlParserTest.Tester tester;
    final @Nullable SqlDialect dialect;
    final boolean convertToLinux;
    final StringAndPos sap;

    SqlParserListFixture(SqlTestFactory factory, SqlParserTest.Tester tester, @Nullable SqlDialect dialect, boolean convertToLinux, StringAndPos sap) {
        this.factory = factory;
        this.tester = tester;
        this.dialect = dialect;
        this.convertToLinux = convertToLinux;
        this.sap = sap;
    }

    public SqlParserListFixture ok(String ... expected) {
        UnaryOperator<String> converter = SqlParserTest.linux(this.convertToLinux);
        this.tester.checkList(this.factory, this.sap, this.dialect, converter, (List<String>)ImmutableList.copyOf((Object[])expected));
        return this;
    }

    public SqlParserListFixture fails(String expectedMsgPattern) {
        this.tester.checkFails(this.factory, this.sap, true, expectedMsgPattern);
        return this;
    }
}

