/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.test.catalog;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.calcite.plan.RelOptPredicateList;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.metadata.BuiltInMetadata;
import org.apache.calcite.rel.metadata.MetadataDef;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.schema.TranslatableTable;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.util.SqlOperatorTables;
import org.apache.calcite.sql2rel.InitializerExpressionFactory;
import org.apache.calcite.test.catalog.CompoundNameColumn;
import org.apache.calcite.test.catalog.CompoundNameColumnResolver;
import org.apache.calcite.test.catalog.Fixture;
import org.apache.calcite.test.catalog.MockCatalogReader;
import org.apache.calcite.test.catalog.MockCatalogReaderSimple;
import org.apache.calcite.test.catalog.VirtualColumnsExpressionFactory;
import org.checkerframework.checker.nullness.qual.NonNull;

public class MockCatalogReaderExtended
extends MockCatalogReaderSimple {
    protected MockCatalogReaderExtended(RelDataTypeFactory typeFactory, boolean caseSensitive) {
        super(typeFactory, caseSensitive);
    }

    public static @NonNull MockCatalogReaderExtended create(RelDataTypeFactory typeFactory, boolean caseSensitive) {
        return new MockCatalogReaderExtended(typeFactory, caseSensitive).init();
    }

    @Override
    public MockCatalogReaderExtended init() {
        super.init();
        MockCatalogReader.MockSchema salesSchema = new MockCatalogReader.MockSchema("SALES");
        ImmutableList empModifiableViewNames = ImmutableList.of((Object)salesSchema.getCatalogName(), (Object)salesSchema.getName(), (Object)"EMP_MODIFIABLEVIEW");
        MockCatalogReader.MockModifiableViewRelOptTable.MockViewTableMacro empModifiableViewMacro = MockCatalogReader.MockModifiableViewRelOptTable.viewMacro(this.rootSchema, "select EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, COMM, SLACKER from EMPDEFAULTS where DEPTNO = 20", empModifiableViewNames.subList(0, 2), (List<String>)ImmutableList.of(empModifiableViewNames.get(2)), true);
        TranslatableTable empModifiableView = empModifiableViewMacro.apply((List)ImmutableList.of());
        MockCatalogReader.MockModifiableViewRelOptTable mockEmpViewTable = MockCatalogReader.MockModifiableViewRelOptTable.create((MockCatalogReader.MockModifiableViewRelOptTable.MockModifiableViewTable)empModifiableView, this, (String)empModifiableViewNames.get(0), (String)empModifiableViewNames.get(1), (String)empModifiableViewNames.get(2), false, 20.0, null);
        this.registerTable(mockEmpViewTable);
        ImmutableList empModifiableViewNames2 = ImmutableList.of((Object)salesSchema.getCatalogName(), (Object)salesSchema.getName(), (Object)"EMP_MODIFIABLEVIEW2");
        MockCatalogReader.MockModifiableViewRelOptTable.MockViewTableMacro empModifiableViewMacro2 = MockCatalogReader.MockModifiableViewRelOptTable.viewMacro(this.rootSchema, "select ENAME, EMPNO, JOB, DEPTNO, SLACKER, SAL, EXTRA, HIREDATE, MGR, COMM from EMPDEFAULTS extend (EXTRA boolean) where DEPTNO = 20", empModifiableViewNames2.subList(0, 2), (List<String>)ImmutableList.of(empModifiableViewNames.get(2)), true);
        TranslatableTable empModifiableView2 = empModifiableViewMacro2.apply((List)ImmutableList.of());
        MockCatalogReader.MockModifiableViewRelOptTable mockEmpViewTable2 = MockCatalogReader.MockModifiableViewRelOptTable.create((MockCatalogReader.MockModifiableViewRelOptTable.MockModifiableViewTable)empModifiableView2, this, (String)empModifiableViewNames2.get(0), (String)empModifiableViewNames2.get(1), (String)empModifiableViewNames2.get(2), false, 20.0, null);
        this.registerTable(mockEmpViewTable2);
        ImmutableList empModifiableViewNames3 = ImmutableList.of((Object)salesSchema.getCatalogName(), (Object)salesSchema.getName(), (Object)"EMP_MODIFIABLEVIEW3");
        MockCatalogReader.MockModifiableViewRelOptTable.MockViewTableMacro empModifiableViewMacro3 = MockCatalogReader.MockModifiableViewRelOptTable.viewMacro(this.rootSchema, "select EMPNO, ENAME, JOB, MGR, HIREDATE, SAL, SLACKER from EMPDEFAULTS where DEPTNO = 20", empModifiableViewNames3.subList(0, 2), (List<String>)ImmutableList.of(empModifiableViewNames3.get(2)), true);
        TranslatableTable empModifiableView3 = empModifiableViewMacro3.apply((List)ImmutableList.of());
        MockCatalogReader.MockModifiableViewRelOptTable mockEmpViewTable3 = MockCatalogReader.MockModifiableViewRelOptTable.create((MockCatalogReader.MockModifiableViewRelOptTable.MockModifiableViewTable)empModifiableView3, this, (String)empModifiableViewNames3.get(0), (String)empModifiableViewNames3.get(1), (String)empModifiableViewNames3.get(2), false, 20.0, null);
        this.registerTable(mockEmpViewTable3);
        MockCatalogReader.MockSchema structTypeSchema = new MockCatalogReader.MockSchema("STRUCT");
        this.registerSchema(structTypeSchema);
        Fixture f = new Fixture(this.typeFactory);
        List<CompoundNameColumn> columnsExtended = Arrays.asList(new CompoundNameColumn("", "K0", f.varchar20TypeNull), new CompoundNameColumn("", "C1", f.varchar20TypeNull), new CompoundNameColumn("F0", "C0", f.intType), new CompoundNameColumn("F1", "C1", f.intTypeNull));
        ArrayList<CompoundNameColumn> extendedColumns = new ArrayList<CompoundNameColumn>(columnsExtended);
        extendedColumns.add(new CompoundNameColumn("F2", "C2", f.varchar20Type));
        CompoundNameColumnResolver structExtendedTableResolver = new CompoundNameColumnResolver(extendedColumns, "F0");
        MockCatalogReader.MockTable structExtendedTypeTable = MockCatalogReader.MockTable.create(this, structTypeSchema, "T_EXTEND", false, 100.0, structExtendedTableResolver);
        for (CompoundNameColumn column : columnsExtended) {
            structExtendedTypeTable.addColumn(column.getName(), column.type);
        }
        this.registerTable(structExtendedTypeTable);
        MockCatalogReader.MockSchema virtualColumnsSchema = new MockCatalogReader.MockSchema("VIRTUALCOLUMNS");
        this.registerSchema(virtualColumnsSchema);
        MockCatalogReader.MockTable virtualColumnsTable1 = MockCatalogReader.MockTable.create(this, virtualColumnsSchema, "VC_T1", false, 100.0, null, (InitializerExpressionFactory)new VirtualColumnsExpressionFactory(), true);
        virtualColumnsTable1.addColumn("A", f.intTypeNull);
        virtualColumnsTable1.addColumn("B", f.bigintType);
        virtualColumnsTable1.addColumn("C", f.varchar10Type);
        virtualColumnsTable1.addColumn("D", f.intTypeNull);
        virtualColumnsTable1.addColumn("E", f.intTypeNull);
        MockCatalogReader.MockTable virtualColumnsTable2 = MockCatalogReader.MockTable.create(this, virtualColumnsSchema, "VC_T2", false, 100.0, null, (InitializerExpressionFactory)new VirtualColumnsExpressionFactory(), false);
        virtualColumnsTable2.addColumn("A", f.intTypeNull);
        virtualColumnsTable2.addColumn("B", f.bigintType);
        virtualColumnsTable2.addColumn("C", f.varchar10Type);
        virtualColumnsTable2.addColumn("D", f.intTypeNull);
        virtualColumnsTable2.addColumn("E", f.bigintType);
        this.registerTable(virtualColumnsTable1);
        this.registerTable(virtualColumnsTable2);
        MockCatalogReader.MockSchema complexTypeColumnsSchema = new MockCatalogReader.MockSchema("COMPLEXTYPES");
        this.registerSchema(complexTypeColumnsSchema);
        MockCatalogReader.MockTable complexTypeColumnsTable = MockCatalogReader.MockTable.create(this, complexTypeColumnsSchema, "CTC_T1", false, 100.0);
        complexTypeColumnsTable.addColumn("A", f.recordType1);
        complexTypeColumnsTable.addColumn("B", f.recordType2);
        complexTypeColumnsTable.addColumn("C", f.recordType3);
        complexTypeColumnsTable.addColumn("D", f.recordType4);
        complexTypeColumnsTable.addColumn("E", f.recordType5);
        complexTypeColumnsTable.addColumn("intArrayType", f.intArrayType);
        complexTypeColumnsTable.addColumn("varchar5ArrayType", f.varchar5ArrayType);
        complexTypeColumnsTable.addColumn("intArrayArrayType", f.intArrayArrayType);
        complexTypeColumnsTable.addColumn("varchar5ArrayArrayType", f.varchar5ArrayArrayType);
        complexTypeColumnsTable.addColumn("intMultisetType", f.intMultisetType);
        complexTypeColumnsTable.addColumn("varchar5MultisetType", f.varchar5MultisetType);
        complexTypeColumnsTable.addColumn("intMultisetArrayType", f.intMultisetArrayType);
        complexTypeColumnsTable.addColumn("varchar5MultisetArrayType", f.varchar5MultisetArrayType);
        complexTypeColumnsTable.addColumn("intArrayMultisetType", f.intArrayMultisetType);
        complexTypeColumnsTable.addColumn("rowArrayMultisetType", f.rowArrayMultisetType);
        this.registerTable(complexTypeColumnsTable);
        MockCatalogReader.MockSchema nullableRowsSchema = new MockCatalogReader.MockSchema("NULLABLEROWS");
        this.registerSchema(nullableRowsSchema);
        MockCatalogReader.MockTable nullableRowsTable = MockCatalogReader.MockTable.create(this, nullableRowsSchema, "NR_T1", false, 100.0);
        RelDataType bigIntNotNull = this.typeFactory.createSqlType(SqlTypeName.BIGINT);
        RelDataType nullableRecordType = this.typeFactory.builder().nullableRecord(true).add("NOT_NULL_FIELD", bigIntNotNull).add("NULLABLE_FIELD", bigIntNotNull).nullable(true).build();
        nullableRowsTable.addColumn("ROW_COLUMN", nullableRecordType, false);
        nullableRowsTable.addColumn("ROW_COLUMN_ARRAY", this.typeFactory.createArrayType(nullableRecordType, -1L), true);
        this.registerTable(nullableRowsTable);
        MockCatalogReader.MockSchema geoSchema = new MockCatalogReader.MockSchema("GEO");
        this.registerSchema(geoSchema);
        MockCatalogReader.MockTable restaurantTable = MockCatalogReader.MockTable.create(this, geoSchema, "RESTAURANTS", false, 100.0);
        restaurantTable.addColumn("NAME", f.varchar20Type, true);
        restaurantTable.addColumn("LATITUDE", f.intType);
        restaurantTable.addColumn("LONGITUDE", f.intType);
        restaurantTable.addColumn("CUISINE", f.varchar10Type);
        restaurantTable.addColumn("HILBERT", f.bigintType);
        restaurantTable.addMonotonic("HILBERT");
        restaurantTable.addWrap(new BuiltInMetadata.AllPredicates.Handler(){

            public RelOptPredicateList getAllPredicates(RelNode r, RelMetadataQuery mq) {
                RexBuilder rexBuilder = r.getCluster().getRexBuilder();
                RexInputRef refLatitude = rexBuilder.makeInputRef(r, 1);
                RexInputRef refLongitude = rexBuilder.makeInputRef(r, 2);
                RexInputRef refHilbert = rexBuilder.makeInputRef(r, 4);
                return RelOptPredicateList.of((RexBuilder)rexBuilder, (Iterable)ImmutableList.of((Object)rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{refHilbert, rexBuilder.makeCall(this.hilbertOp(), new RexNode[]{refLongitude, refLatitude})})));
            }

            SqlOperator hilbertOp() {
                for (SqlOperator op : SqlOperatorTables.spatialInstance().getOperatorList()) {
                    if (op.getKind() != SqlKind.HILBERT || !op.getOperandCountRange().isValidCount(2)) continue;
                    return op;
                }
                throw new AssertionError();
            }

            public MetadataDef<BuiltInMetadata.AllPredicates> getDef() {
                return BuiltInMetadata.AllPredicates.DEF;
            }
        });
        this.registerTable(restaurantTable);
        return this;
    }
}

