/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.model;

import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Stream;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.stream.StreamObserver;
import org.apache.dubbo.common.utils.ReflectUtils;

public class MethodDescriptor {
    private static final String GRPC_ASYNC_RETURN_CLASS = "com.google.common.util.concurrent.ListenableFuture";
    private static final String TRI_ASYNC_RETURN_CLASS = "java.util.concurrent.CompletableFuture";
    private static final String REACTOR_RETURN_CLASS = "reactor.core.publisher.Mono";
    private static final String RX_RETURN_CLASS = "io.reactivex.Single";
    private static final String GRPC_STREAM_CLASS = "io.grpc.stub.StreamObserver";
    private static final Logger logger = LoggerFactory.getLogger(MethodDescriptor.class);
    private final Method method;
    private final String paramDesc;
    private final String[] compatibleParamSignatures;
    private final Class<?>[] parameterClasses;
    private final Class<?> returnClass;
    private final Type[] returnTypes;
    private final String methodName;
    private final boolean generic;
    private final boolean wrap;
    private final RpcType rpcType;
    private final ConcurrentMap<String, Object> attributeMap = new ConcurrentHashMap<String, Object>();
    private final Class<?>[] realParameterClasses;
    private final Class<?> realReturnClass;

    public MethodDescriptor(Method method) {
        Type[] returnTypesResult;
        this.method = method;
        this.methodName = method.getName();
        Class<?>[] parameterTypes = method.getParameterTypes();
        this.realParameterClasses = parameterTypes;
        this.realReturnClass = method.getReturnType();
        if (parameterTypes.length == 1 && MethodDescriptor.isStreamType(parameterTypes[0])) {
            this.parameterClasses = new Class[]{(Class)((ParameterizedType)method.getGenericReturnType()).getActualTypeArguments()[0]};
            this.returnClass = (Class)((ParameterizedType)method.getGenericParameterTypes()[0]).getActualTypeArguments()[0];
            this.rpcType = RpcType.BIDIRECTIONAL_STREAM;
        } else if (parameterTypes.length == 2 && method.getReturnType().equals(Void.TYPE) && !MethodDescriptor.isStreamType(parameterTypes[0]) && MethodDescriptor.isStreamType(parameterTypes[1])) {
            this.parameterClasses = method.getParameterTypes();
            this.returnClass = (Class)((ParameterizedType)method.getGenericParameterTypes()[1]).getActualTypeArguments()[0];
            this.rpcType = RpcType.SERVER_STREAM;
        } else {
            this.parameterClasses = method.getParameterTypes();
            this.returnClass = method.getReturnType();
            this.rpcType = RpcType.UNARY;
        }
        this.wrap = this.needWrap();
        try {
            returnTypesResult = ReflectUtils.getReturnTypes(method);
        }
        catch (Throwable throwable) {
            logger.error("fail to get return types", throwable);
            returnTypesResult = new Type[]{this.returnClass, this.returnClass};
        }
        this.returnTypes = returnTypesResult;
        this.paramDesc = ReflectUtils.getDesc(this.parameterClasses);
        this.compatibleParamSignatures = (String[])Stream.of(this.parameterClasses).map(Class::getName).toArray(String[]::new);
        this.generic = (this.methodName.equals("$invoke") || this.methodName.equals("$invokeAsync")) && this.parameterClasses.length == 3;
    }

    private static boolean isStreamType(Class<?> clz) {
        return StreamObserver.class.isAssignableFrom(clz) || GRPC_STREAM_CLASS.equalsIgnoreCase(clz.getName());
    }

    public boolean isStream() {
        return this.rpcType.equals((Object)RpcType.SERVER_STREAM) || this.rpcType.equals((Object)RpcType.BIDIRECTIONAL_STREAM) || this.rpcType.equals((Object)RpcType.CLIENT_STREAM);
    }

    public boolean isServerStream() {
        return RpcType.SERVER_STREAM.equals((Object)this.rpcType);
    }

    public boolean isUnary() {
        return this.rpcType.equals((Object)RpcType.UNARY);
    }

    public boolean isNeedWrap() {
        return this.wrap;
    }

    public RpcType getRpcType() {
        return this.rpcType;
    }

    private boolean needWrap() {
        if ("$invoke".equals(this.methodName) || "$invokeAsync".equals(this.methodName)) {
            return true;
        }
        if ("$echo".equals(this.methodName)) {
            return true;
        }
        boolean returnClassProtobuf = this.isProtobufClass(this.returnClass);
        if (this.parameterClasses.length == 0) {
            return !returnClassProtobuf;
        }
        int protobufParameterCount = 0;
        int javaParameterCount = 0;
        int streamParameterCount = 0;
        boolean secondParameterStream = false;
        for (int i = 0; i < this.parameterClasses.length; ++i) {
            Class<?> parameterClass = this.parameterClasses[i];
            if (this.isProtobufClass(parameterClass)) {
                ++protobufParameterCount;
                continue;
            }
            if (MethodDescriptor.isStreamType(parameterClass)) {
                if (i == 1) {
                    secondParameterStream = true;
                }
                ++streamParameterCount;
                continue;
            }
            ++javaParameterCount;
        }
        if (streamParameterCount > 1) {
            throw new IllegalStateException("method params error: more than one Stream params. method=" + this.methodName);
        }
        if (protobufParameterCount >= 2) {
            throw new IllegalStateException("method params error: more than one protobuf params. method=" + this.methodName);
        }
        if (streamParameterCount == 1) {
            if (javaParameterCount + protobufParameterCount > 1) {
                throw new IllegalStateException("method params error: server stream does not support more than one normal param. method=" + this.methodName);
            }
            if (!secondParameterStream) {
                throw new IllegalStateException("method params error: server stream's second param must be StreamObserver. method=" + this.methodName);
            }
        }
        if (this.isStream()) {
            if (RpcType.SERVER_STREAM == this.rpcType && !secondParameterStream) {
                throw new IllegalStateException("method params error:server stream's second param must be StreamObserver. method=" + this.methodName);
            }
            if (returnClassProtobuf) {
                if (javaParameterCount > 0) {
                    throw new IllegalStateException("method params error: both normal and protobuf param found. method=" + this.methodName);
                }
            } else if (protobufParameterCount > 0) {
                throw new IllegalStateException("method params error method=" + this.methodName);
            }
        } else {
            boolean ignore;
            if (streamParameterCount > 0) {
                throw new IllegalStateException("method params error: unary method should not contain any StreamObserver. method=" + this.methodName);
            }
            if (protobufParameterCount > 0 && returnClassProtobuf) {
                return false;
            }
            if (this.isMono(this.returnClass) || this.isRx(this.returnClass)) {
                return false;
            }
            if (protobufParameterCount <= 0 && !returnClassProtobuf) {
                return true;
            }
            if (GRPC_ASYNC_RETURN_CLASS.equalsIgnoreCase(this.returnClass.getName()) && protobufParameterCount == 1) {
                return false;
            }
            if (TRI_ASYNC_RETURN_CLASS.equalsIgnoreCase(this.returnClass.getName())) {
                Class actualReturnClass = (Class)((ParameterizedType)this.method.getGenericReturnType()).getActualTypeArguments()[0];
                boolean actualReturnClassProtobuf = this.isProtobufClass(actualReturnClass);
                if (actualReturnClassProtobuf && protobufParameterCount == 1) {
                    return false;
                }
                if (!actualReturnClassProtobuf && protobufParameterCount == 0) {
                    return true;
                }
            }
            if (ignore = this.checkNeedIgnore()) {
                return protobufParameterCount != 1;
            }
            throw new IllegalStateException("method params error method=" + this.methodName);
        }
        return javaParameterCount > 0;
    }

    private boolean checkNeedIgnore() {
        return Iterator.class.isAssignableFrom(this.returnClass);
    }

    private boolean isMono(Class<?> clz) {
        return REACTOR_RETURN_CLASS.equalsIgnoreCase(clz.getName());
    }

    private boolean isRx(Class<?> clz) {
        return RX_RETURN_CLASS.equalsIgnoreCase(clz.getName());
    }

    public boolean isProtobufClass(Class<?> clazz) {
        while (clazz != Object.class && clazz != null) {
            Class<?>[] interfaces = clazz.getInterfaces();
            if (interfaces.length > 0) {
                for (Class<?> clazzInterface : interfaces) {
                    if (!"com.google.protobuf.Message".equalsIgnoreCase(clazzInterface.getName())) continue;
                    return true;
                }
            }
            clazz = clazz.getSuperclass();
        }
        return false;
    }

    public boolean matchParams(String params) {
        return this.paramDesc.equalsIgnoreCase(params);
    }

    public Method getMethod() {
        return this.method;
    }

    public String getParamDesc() {
        return this.paramDesc;
    }

    public String[] getCompatibleParamSignatures() {
        return this.compatibleParamSignatures;
    }

    public Class<?>[] getParameterClasses() {
        return this.parameterClasses;
    }

    public Class<?> getReturnClass() {
        return this.returnClass;
    }

    public Type[] getReturnTypes() {
        return this.returnTypes;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public boolean isGeneric() {
        return this.generic;
    }

    public void addAttribute(String key, Object value) {
        this.attributeMap.put(key, value);
    }

    public Object getAttribute(String key) {
        return this.attributeMap.get(key);
    }

    public Class<?>[] getRealParameterClasses() {
        return this.realParameterClasses;
    }

    public Class<?> getRealReturnClass() {
        return this.realReturnClass;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MethodDescriptor that = (MethodDescriptor)o;
        return this.generic == that.generic && this.wrap == that.wrap && this.rpcType == that.rpcType && Objects.equals(this.method, that.method) && Objects.equals(this.paramDesc, that.paramDesc) && Arrays.equals(this.compatibleParamSignatures, that.compatibleParamSignatures) && Arrays.equals(this.parameterClasses, that.parameterClasses) && Objects.equals(this.returnClass, that.returnClass) && Arrays.equals(this.returnTypes, that.returnTypes) && Objects.equals(this.methodName, that.methodName) && Objects.equals(this.attributeMap, that.attributeMap) && Arrays.equals(this.realParameterClasses, that.realParameterClasses) && Objects.equals(this.realReturnClass, that.realReturnClass);
    }

    public int hashCode() {
        int result = Objects.hash(new Object[]{this.method, this.paramDesc, this.returnClass, this.methodName, this.generic, this.wrap, this.rpcType, this.attributeMap, this.realReturnClass});
        result = 31 * result + Arrays.hashCode(this.compatibleParamSignatures);
        result = 31 * result + Arrays.hashCode(this.parameterClasses);
        result = 31 * result + Arrays.hashCode(this.returnTypes);
        result = 31 * result + Arrays.hashCode(this.realParameterClasses);
        return result;
    }

    public static enum RpcType {
        UNARY,
        SERVER_STREAM,
        CLIENT_STREAM,
        BIDIRECTIONAL_STREAM;

    }
}

