/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.client.cli;

import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.flink.annotation.Internal;
import org.apache.flink.client.cli.CustomCommandLine;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.DeploymentOptions;
import org.apache.flink.configuration.DeploymentOptionsInternal;
import org.apache.flink.configuration.UnmodifiableConfiguration;
import org.apache.flink.core.execution.DefaultExecutorServiceLoader;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class GenericCLI
implements CustomCommandLine {
    private static final Logger LOG = LoggerFactory.getLogger(GenericCLI.class);
    private static final String ID = "Generic CLI";
    private final Option executorOption = new Option("e", "executor", true, "DEPRECATED: Please use the -t option instead which is also available with the \"Application Mode\".\nThe name of the executor to be used for executing the given job, which is equivalent to the \"" + DeploymentOptions.TARGET.key() + "\" config option. The currently available executors are: " + GenericCLI.getExecutorFactoryNames() + ".");
    private final Option targetOption = new Option("t", "target", true, "The deployment target for the given application, which is equivalent to the \"" + DeploymentOptions.TARGET.key() + "\" config option. The currently available targets are: " + GenericCLI.getExecutorFactoryNames() + ", \"yarn-application\" and \"kubernetes-application\".");
    private final Option dynamicProperties = Option.builder((String)"D").argName("property=value").numberOfArgs(2).valueSeparator('=').desc("Generic configuration options for execution/deployment and for the configured executor. The available options can be found at https://ci.apache.org/projects/flink/flink-docs-stable/ops/config.html").build();
    private final Configuration baseConfiguration;
    private final String configurationDir;

    public GenericCLI(Configuration configuration, String configDir) {
        this.baseConfiguration = new UnmodifiableConfiguration((Configuration)Preconditions.checkNotNull((Object)configuration));
        this.configurationDir = (String)Preconditions.checkNotNull((Object)configDir);
    }

    @Override
    public boolean isActive(CommandLine commandLine) {
        return this.baseConfiguration.getOptional(DeploymentOptions.TARGET).isPresent() || commandLine.hasOption(this.executorOption.getOpt()) || commandLine.hasOption(this.targetOption.getOpt());
    }

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public void addRunOptions(Options baseOptions) {
    }

    @Override
    public void addGeneralOptions(Options baseOptions) {
        baseOptions.addOption(this.executorOption);
        baseOptions.addOption(this.targetOption);
        baseOptions.addOption(this.dynamicProperties);
    }

    @Override
    public Configuration applyCommandLineOptionsToConfiguration(CommandLine commandLine) {
        String targetName;
        Configuration effectiveConfiguration = new Configuration(this.baseConfiguration);
        String executorName = commandLine.getOptionValue(this.executorOption.getOpt());
        if (executorName != null) {
            effectiveConfiguration.setString(DeploymentOptions.TARGET, executorName);
        }
        if ((targetName = commandLine.getOptionValue(this.targetOption.getOpt())) != null) {
            effectiveConfiguration.setString(DeploymentOptions.TARGET, targetName);
        }
        this.encodeDynamicProperties(commandLine, effectiveConfiguration);
        effectiveConfiguration.set(DeploymentOptionsInternal.CONF_DIR, (Object)this.configurationDir);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Effective Configuration: {}", (Object)effectiveConfiguration);
        }
        return effectiveConfiguration;
    }

    private void encodeDynamicProperties(CommandLine commandLine, Configuration effectiveConfiguration) {
        Properties properties = commandLine.getOptionProperties(this.dynamicProperties.getOpt());
        properties.stringPropertyNames().forEach(key -> {
            String value = properties.getProperty((String)key);
            if (value != null) {
                effectiveConfiguration.setString(key, value);
            } else {
                effectiveConfiguration.setString(key, "true");
            }
        });
    }

    private static String getExecutorFactoryNames() {
        return new DefaultExecutorServiceLoader().getExecutorNames().map(name -> String.format("\"%s\"", name)).collect(Collectors.joining(", "));
    }
}

