/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.client.program;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.apache.flink.api.common.JobExecutionResult;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.JobStatus;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.RestOptions;
import org.apache.flink.configuration.TaskManagerOptions;
import org.apache.flink.core.execution.JobClient;
import org.apache.flink.runtime.concurrent.FutureUtils;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.runtime.jobgraph.OperatorID;
import org.apache.flink.runtime.jobmaster.JobResult;
import org.apache.flink.runtime.minicluster.MiniCluster;
import org.apache.flink.runtime.minicluster.MiniClusterConfiguration;
import org.apache.flink.runtime.minicluster.RpcServiceSharing;
import org.apache.flink.runtime.operators.coordination.CoordinationRequest;
import org.apache.flink.runtime.operators.coordination.CoordinationRequestGateway;
import org.apache.flink.runtime.operators.coordination.CoordinationResponse;
import org.apache.flink.util.MathUtils;
import org.apache.flink.util.SerializedValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PerJobMiniClusterFactory {
    private static final Logger LOG = LoggerFactory.getLogger(PerJobMiniClusterFactory.class);
    private final Configuration configuration;
    private final Function<? super MiniClusterConfiguration, ? extends MiniCluster> miniClusterFactory;

    public static PerJobMiniClusterFactory create() {
        return new PerJobMiniClusterFactory(new Configuration(), MiniCluster::new);
    }

    public static PerJobMiniClusterFactory createWithFactory(Configuration configuration, Function<? super MiniClusterConfiguration, ? extends MiniCluster> miniClusterFactory) {
        return new PerJobMiniClusterFactory(configuration, miniClusterFactory);
    }

    private PerJobMiniClusterFactory(Configuration configuration, Function<? super MiniClusterConfiguration, ? extends MiniCluster> miniClusterFactory) {
        this.configuration = configuration;
        this.miniClusterFactory = miniClusterFactory;
    }

    public CompletableFuture<JobClient> submitJob(JobGraph jobGraph) throws Exception {
        MiniClusterConfiguration miniClusterConfig = this.getMiniClusterConfig(jobGraph.getMaximumParallelism());
        MiniCluster miniCluster = this.miniClusterFactory.apply((MiniClusterConfiguration)miniClusterConfig);
        miniCluster.start();
        return ((CompletableFuture)((CompletableFuture)miniCluster.submitJob(jobGraph).thenApply(result -> new PerJobMiniClusterJobClient(result.getJobID(), miniCluster))).whenComplete((ignored, throwable) -> {
            if (throwable != null) {
                PerJobMiniClusterFactory.shutDownCluster(miniCluster);
            }
        })).thenApply(Function.identity());
    }

    private MiniClusterConfiguration getMiniClusterConfig(int maximumParallelism) {
        Configuration configuration = new Configuration(this.configuration);
        if (!configuration.contains(RestOptions.BIND_PORT)) {
            configuration.setString(RestOptions.BIND_PORT, "0");
        }
        int numTaskManagers = configuration.getInteger("local.number-taskmanager", 1);
        int numSlotsPerTaskManager = configuration.getOptional(TaskManagerOptions.NUM_TASK_SLOTS).orElseGet(() -> maximumParallelism > 0 ? Integer.valueOf(MathUtils.divideRoundUp((int)maximumParallelism, (int)numTaskManagers)) : (Integer)TaskManagerOptions.NUM_TASK_SLOTS.defaultValue());
        return new MiniClusterConfiguration.Builder().setConfiguration(configuration).setNumTaskManagers(numTaskManagers).setRpcServiceSharing(RpcServiceSharing.SHARED).setNumSlotsPerTaskManager(numSlotsPerTaskManager).build();
    }

    private static void shutDownCluster(MiniCluster miniCluster) {
        miniCluster.closeAsync().whenComplete((ignored, throwable) -> {
            if (throwable != null) {
                LOG.warn("Shutdown of MiniCluster failed.", throwable);
            }
        });
    }

    private static final class PerJobMiniClusterJobClient
    implements JobClient,
    CoordinationRequestGateway {
        private final JobID jobID;
        private final MiniCluster miniCluster;
        private final CompletableFuture<JobResult> jobResultFuture;

        private PerJobMiniClusterJobClient(JobID jobID, MiniCluster miniCluster) {
            this.jobID = jobID;
            this.miniCluster = miniCluster;
            this.jobResultFuture = miniCluster.requestJobResult(jobID).whenComplete((result, throwable) -> PerJobMiniClusterFactory.shutDownCluster(miniCluster));
        }

        public JobID getJobID() {
            return this.jobID;
        }

        public CompletableFuture<JobStatus> getJobStatus() {
            return this.miniCluster.getJobStatus(this.jobID);
        }

        public CompletableFuture<Void> cancel() {
            return this.miniCluster.cancelJob(this.jobID).thenAccept(result -> {});
        }

        public CompletableFuture<String> stopWithSavepoint(boolean advanceToEndOfEventTime, @Nullable String savepointDirectory) {
            return this.miniCluster.stopWithSavepoint(this.jobID, savepointDirectory, advanceToEndOfEventTime);
        }

        public CompletableFuture<String> triggerSavepoint(@Nullable String savepointDirectory) {
            return this.miniCluster.triggerSavepoint(this.jobID, savepointDirectory, false);
        }

        public CompletableFuture<Map<String, Object>> getAccumulators(ClassLoader classLoader) {
            return this.getJobExecutionResult(classLoader).thenApply(JobExecutionResult::getAllAccumulatorResults);
        }

        public CompletableFuture<JobExecutionResult> getJobExecutionResult(ClassLoader classLoader) {
            return this.jobResultFuture.thenApply(result -> {
                try {
                    return result.toJobExecutionResult(classLoader);
                }
                catch (Exception e) {
                    throw new CompletionException("Failed to convert JobResult to JobExecutionResult.", e);
                }
            });
        }

        public CompletableFuture<CoordinationResponse> sendCoordinationRequest(OperatorID operatorId, CoordinationRequest request) {
            try {
                SerializedValue serializedRequest = new SerializedValue((Object)request);
                return this.miniCluster.deliverCoordinationRequestToCoordinator(this.jobID, operatorId, serializedRequest);
            }
            catch (IOException e) {
                return FutureUtils.completedExceptionally((Throwable)e);
            }
        }
    }
}

