/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.io.jdbc.dialect;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Optional;
import java.util.stream.Collectors;

public interface JDBCDialect
extends Serializable {
    public boolean canHandle(String var1);

    default public Optional<String> defaultDriverName() {
        return Optional.empty();
    }

    default public String quoteIdentifier(String identifier) {
        return "\"" + identifier + "\"";
    }

    default public Optional<String> getUpsertStatement(String tableName, String[] fieldNames, String[] uniqueKeyFields) {
        return Optional.empty();
    }

    default public String getRowExistsStatement(String tableName, String[] conditionFields) {
        String fieldExpressions = Arrays.stream(conditionFields).map(f -> this.quoteIdentifier((String)f) + "=?").collect(Collectors.joining(" AND "));
        return "SELECT 1 FROM " + this.quoteIdentifier(tableName) + " WHERE " + fieldExpressions;
    }

    default public String getInsertIntoStatement(String tableName, String[] fieldNames) {
        String columns = Arrays.stream(fieldNames).map(this::quoteIdentifier).collect(Collectors.joining(", "));
        String placeholders = Arrays.stream(fieldNames).map(f -> "?").collect(Collectors.joining(", "));
        return "INSERT INTO " + this.quoteIdentifier(tableName) + "(" + columns + ") VALUES (" + placeholders + ")";
    }

    default public String getUpdateStatement(String tableName, String[] fieldNames, String[] conditionFields) {
        String setClause = Arrays.stream(fieldNames).map(f -> this.quoteIdentifier((String)f) + "=?").collect(Collectors.joining(", "));
        String conditionClause = Arrays.stream(conditionFields).map(f -> this.quoteIdentifier((String)f) + "=?").collect(Collectors.joining(" AND "));
        return "UPDATE " + this.quoteIdentifier(tableName) + " SET " + setClause + " WHERE " + conditionClause;
    }

    default public String getDeleteStatement(String tableName, String[] conditionFields) {
        String conditionClause = Arrays.stream(conditionFields).map(f -> this.quoteIdentifier((String)f) + "=?").collect(Collectors.joining(" AND "));
        return "DELETE FROM " + this.quoteIdentifier(tableName) + " WHERE " + conditionClause;
    }

    default public String getSelectFromStatement(String tableName, String[] selectFields, String[] conditionFields) {
        String selectExpressions = Arrays.stream(selectFields).map(this::quoteIdentifier).collect(Collectors.joining(", "));
        String fieldExpressions = Arrays.stream(conditionFields).map(f -> this.quoteIdentifier((String)f) + "=?").collect(Collectors.joining(" AND "));
        return "SELECT " + selectExpressions + " FROM " + this.quoteIdentifier(tableName) + (conditionFields.length > 0 ? " WHERE " + fieldExpressions : "");
    }
}

