/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.json.debezium;

import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.serialization.DeserializationSchema;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.formats.common.TimestampFormat;
import org.apache.flink.formats.json.JsonRowDataDeserializationSchema;
import org.apache.flink.formats.json.debezium.DebeziumJsonDecodingFormat;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.utils.DataTypeUtils;
import org.apache.flink.types.RowKind;
import org.apache.flink.util.Collector;

@Internal
public final class DebeziumJsonDeserializationSchema
implements DeserializationSchema<RowData> {
    private static final long serialVersionUID = 1L;
    private static final String OP_READ = "r";
    private static final String OP_CREATE = "c";
    private static final String OP_UPDATE = "u";
    private static final String OP_DELETE = "d";
    private static final String REPLICA_IDENTITY_EXCEPTION = "The \"before\" field of %s message is null, if you are using Debezium Postgres Connector, please check the Postgres table has been set REPLICA IDENTITY to FULL level.";
    private final JsonRowDataDeserializationSchema jsonDeserializer;
    private final boolean hasMetadata;
    private final MetadataConverter[] metadataConverters;
    private final TypeInformation<RowData> producedTypeInfo;
    private final boolean schemaInclude;
    private final boolean ignoreParseErrors;

    public DebeziumJsonDeserializationSchema(DataType physicalDataType, List<DebeziumJsonDecodingFormat.ReadableMetadata> requestedMetadata, TypeInformation<RowData> producedTypeInfo, boolean schemaInclude, boolean ignoreParseErrors, TimestampFormat timestampFormat) {
        RowType jsonRowType = DebeziumJsonDeserializationSchema.createJsonRowType(physicalDataType, requestedMetadata, schemaInclude);
        this.jsonDeserializer = new JsonRowDataDeserializationSchema(jsonRowType, producedTypeInfo, false, ignoreParseErrors, timestampFormat);
        this.hasMetadata = requestedMetadata.size() > 0;
        this.metadataConverters = DebeziumJsonDeserializationSchema.createMetadataConverters(jsonRowType, requestedMetadata, schemaInclude);
        this.producedTypeInfo = producedTypeInfo;
        this.schemaInclude = schemaInclude;
        this.ignoreParseErrors = ignoreParseErrors;
    }

    public RowData deserialize(byte[] message) {
        throw new RuntimeException("Please invoke DeserializationSchema#deserialize(byte[], Collector<RowData>) instead.");
    }

    public void deserialize(byte[] message, Collector<RowData> out) throws IOException {
        block12: {
            if (message == null || message.length == 0) {
                return;
            }
            try {
                GenericRowData row = (GenericRowData)this.jsonDeserializer.deserialize(message);
                GenericRowData payload = this.schemaInclude ? (GenericRowData)row.getField(0) : row;
                GenericRowData before = (GenericRowData)payload.getField(0);
                GenericRowData after = (GenericRowData)payload.getField(1);
                String op = payload.getField(2).toString();
                if (OP_CREATE.equals(op) || OP_READ.equals(op)) {
                    after.setRowKind(RowKind.INSERT);
                    this.emitRow(row, after, out);
                } else if (OP_UPDATE.equals(op)) {
                    if (before == null) {
                        throw new IllegalStateException(String.format(REPLICA_IDENTITY_EXCEPTION, "UPDATE"));
                    }
                    before.setRowKind(RowKind.UPDATE_BEFORE);
                    after.setRowKind(RowKind.UPDATE_AFTER);
                    this.emitRow(row, before, out);
                    this.emitRow(row, after, out);
                } else if (OP_DELETE.equals(op)) {
                    if (before == null) {
                        throw new IllegalStateException(String.format(REPLICA_IDENTITY_EXCEPTION, "DELETE"));
                    }
                    before.setRowKind(RowKind.DELETE);
                    this.emitRow(row, before, out);
                } else if (!this.ignoreParseErrors) {
                    throw new IOException(String.format("Unknown \"op\" value \"%s\". The Debezium JSON message is '%s'", op, new String(message)));
                }
            }
            catch (Throwable t) {
                if (this.ignoreParseErrors) break block12;
                throw new IOException(String.format("Corrupt Debezium JSON message '%s'.", new String(message)), t);
            }
        }
    }

    private void emitRow(GenericRowData rootRow, GenericRowData physicalRow, Collector<RowData> out) {
        if (!this.hasMetadata) {
            out.collect((Object)physicalRow);
            return;
        }
        int physicalArity = physicalRow.getArity();
        int metadataArity = this.metadataConverters.length;
        GenericRowData producedRow = new GenericRowData(physicalRow.getRowKind(), physicalArity + metadataArity);
        for (int physicalPos = 0; physicalPos < physicalArity; ++physicalPos) {
            producedRow.setField(physicalPos, physicalRow.getField(physicalPos));
        }
        for (int metadataPos = 0; metadataPos < metadataArity; ++metadataPos) {
            producedRow.setField(physicalArity + metadataPos, this.metadataConverters[metadataPos].convert(rootRow));
        }
        out.collect((Object)producedRow);
    }

    public boolean isEndOfStream(RowData nextElement) {
        return false;
    }

    public TypeInformation<RowData> getProducedType() {
        return this.producedTypeInfo;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DebeziumJsonDeserializationSchema that = (DebeziumJsonDeserializationSchema)o;
        return Objects.equals(this.jsonDeserializer, that.jsonDeserializer) && this.hasMetadata == that.hasMetadata && Objects.equals(this.producedTypeInfo, that.producedTypeInfo) && this.schemaInclude == that.schemaInclude && this.ignoreParseErrors == that.ignoreParseErrors;
    }

    public int hashCode() {
        return Objects.hash(this.jsonDeserializer, this.hasMetadata, this.producedTypeInfo, this.schemaInclude, this.ignoreParseErrors);
    }

    private static RowType createJsonRowType(DataType physicalDataType, List<DebeziumJsonDecodingFormat.ReadableMetadata> readableMetadata, boolean schemaInclude) {
        DataType payload = DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"before", (DataType)physicalDataType), DataTypes.FIELD((String)"after", (DataType)physicalDataType), DataTypes.FIELD((String)"op", (DataType)DataTypes.STRING())});
        List payloadMetadataFields = readableMetadata.stream().filter(m -> m.isJsonPayload).map(m -> m.requiredJsonField).distinct().collect(Collectors.toList());
        DataType root = payload = DataTypeUtils.appendRowFields((DataType)payload, payloadMetadataFields);
        if (schemaInclude) {
            root = DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"payload", (DataType)payload)});
        }
        List rootMetadataFields = readableMetadata.stream().filter(m -> !m.isJsonPayload).map(m -> m.requiredJsonField).distinct().collect(Collectors.toList());
        root = DataTypeUtils.appendRowFields((DataType)root, rootMetadataFields);
        return (RowType)root.getLogicalType();
    }

    private static MetadataConverter[] createMetadataConverters(RowType jsonRowType, List<DebeziumJsonDecodingFormat.ReadableMetadata> requestedMetadata, boolean schemaInclude) {
        return (MetadataConverter[])requestedMetadata.stream().map(m -> {
            if (m.isJsonPayload) {
                return DebeziumJsonDeserializationSchema.convertInPayload(jsonRowType, m, schemaInclude);
            }
            return DebeziumJsonDeserializationSchema.convertInRoot(jsonRowType, m);
        }).toArray(MetadataConverter[]::new);
    }

    private static MetadataConverter convertInRoot(RowType jsonRowType, final DebeziumJsonDecodingFormat.ReadableMetadata metadata) {
        final int pos = DebeziumJsonDeserializationSchema.findFieldPos(metadata, jsonRowType);
        return new MetadataConverter(){
            private static final long serialVersionUID = 1L;

            @Override
            public Object convert(GenericRowData root, int unused) {
                return metadata.converter.convert(root, pos);
            }
        };
    }

    private static MetadataConverter convertInPayload(RowType jsonRowType, final DebeziumJsonDecodingFormat.ReadableMetadata metadata, boolean schemaInclude) {
        if (schemaInclude) {
            final int pos = DebeziumJsonDeserializationSchema.findFieldPos(metadata, (RowType)jsonRowType.getChildren().get(0));
            return new MetadataConverter(){
                private static final long serialVersionUID = 1L;

                @Override
                public Object convert(GenericRowData root, int unused) {
                    GenericRowData payload = (GenericRowData)root.getField(0);
                    return metadata.converter.convert(payload, pos);
                }
            };
        }
        return DebeziumJsonDeserializationSchema.convertInRoot(jsonRowType, metadata);
    }

    private static int findFieldPos(DebeziumJsonDecodingFormat.ReadableMetadata metadata, RowType jsonRowType) {
        return jsonRowType.getFieldNames().indexOf(metadata.requiredJsonField.getName());
    }

    static interface MetadataConverter
    extends Serializable {
        default public Object convert(GenericRowData row) {
            return this.convert(row, -1);
        }

        public Object convert(GenericRowData var1, int var2);
    }
}

