/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model;

import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.builder.VisitableBuilder;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.APIService;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.APIServiceFluent;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.APIServiceFluentImpl;

public class APIServiceBuilder
extends APIServiceFluentImpl<APIServiceBuilder>
implements VisitableBuilder<APIService, APIServiceBuilder> {
    APIServiceFluent<?> fluent;
    Boolean validationEnabled;

    public APIServiceBuilder() {
        this(false);
    }

    public APIServiceBuilder(Boolean validationEnabled) {
        this(new APIService(), validationEnabled);
    }

    public APIServiceBuilder(APIServiceFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public APIServiceBuilder(APIServiceFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new APIService(), validationEnabled);
    }

    public APIServiceBuilder(APIServiceFluent<?> fluent, APIService instance) {
        this(fluent, instance, false);
    }

    public APIServiceBuilder(APIServiceFluent<?> fluent, APIService instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withKind(instance.getKind());
        fluent.withMetadata(instance.getMetadata());
        fluent.withSpec(instance.getSpec());
        fluent.withStatus(instance.getStatus());
        fluent.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    public APIServiceBuilder(APIService instance) {
        this(instance, (Boolean)false);
    }

    public APIServiceBuilder(APIService instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withSpec(instance.getSpec());
        this.withStatus(instance.getStatus());
        this.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public APIService build() {
        APIService buildable = new APIService(this.fluent.getApiVersion(), this.fluent.getKind(), this.fluent.getMetadata(), this.fluent.getSpec(), this.fluent.getStatus());
        buildable.setAdditionalProperties(this.fluent.getAdditionalProperties());
        return buildable;
    }
}

