/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.builder.BaseFluent;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.builder.Nested;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.LoadBalancerIngress;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.LoadBalancerIngressFluent;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.PortStatus;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.PortStatusBuilder;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.PortStatusFluentImpl;

public class LoadBalancerIngressFluentImpl<A extends LoadBalancerIngressFluent<A>>
extends BaseFluent<A>
implements LoadBalancerIngressFluent<A> {
    private String hostname;
    private String ip;
    private ArrayList<PortStatusBuilder> ports = new ArrayList();
    private Map<String, Object> additionalProperties;

    public LoadBalancerIngressFluentImpl() {
    }

    public LoadBalancerIngressFluentImpl(LoadBalancerIngress instance) {
        this.withHostname(instance.getHostname());
        this.withIp(instance.getIp());
        this.withPorts(instance.getPorts());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    public String getHostname() {
        return this.hostname;
    }

    @Override
    public A withHostname(String hostname) {
        this.hostname = hostname;
        return (A)this;
    }

    @Override
    public Boolean hasHostname() {
        return this.hostname != null;
    }

    @Override
    public String getIp() {
        return this.ip;
    }

    @Override
    public A withIp(String ip) {
        this.ip = ip;
        return (A)this;
    }

    @Override
    public Boolean hasIp() {
        return this.ip != null;
    }

    @Override
    public A addToPorts(Integer index, PortStatus item) {
        if (this.ports == null) {
            this.ports = new ArrayList();
        }
        PortStatusBuilder builder = new PortStatusBuilder(item);
        this._visitables.get("ports").add(index >= 0 ? index.intValue() : this._visitables.get("ports").size(), builder);
        this.ports.add(index >= 0 ? index.intValue() : this.ports.size(), builder);
        return (A)this;
    }

    @Override
    public A setToPorts(Integer index, PortStatus item) {
        if (this.ports == null) {
            this.ports = new ArrayList();
        }
        PortStatusBuilder builder = new PortStatusBuilder(item);
        if (index < 0 || index >= this._visitables.get("ports").size()) {
            this._visitables.get("ports").add(builder);
        } else {
            this._visitables.get("ports").set(index, builder);
        }
        if (index < 0 || index >= this.ports.size()) {
            this.ports.add(builder);
        } else {
            this.ports.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToPorts(PortStatus ... items) {
        if (this.ports == null) {
            this.ports = new ArrayList();
        }
        for (PortStatus item : items) {
            PortStatusBuilder builder = new PortStatusBuilder(item);
            this._visitables.get("ports").add(builder);
            this.ports.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToPorts(Collection<PortStatus> items) {
        if (this.ports == null) {
            this.ports = new ArrayList();
        }
        for (PortStatus item : items) {
            PortStatusBuilder builder = new PortStatusBuilder(item);
            this._visitables.get("ports").add(builder);
            this.ports.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromPorts(PortStatus ... items) {
        for (PortStatus item : items) {
            PortStatusBuilder builder = new PortStatusBuilder(item);
            this._visitables.get("ports").remove(builder);
            if (this.ports == null) continue;
            this.ports.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromPorts(Collection<PortStatus> items) {
        for (PortStatus item : items) {
            PortStatusBuilder builder = new PortStatusBuilder(item);
            this._visitables.get("ports").remove(builder);
            if (this.ports == null) continue;
            this.ports.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromPorts(Predicate<PortStatusBuilder> predicate) {
        if (this.ports == null) {
            return (A)this;
        }
        Iterator<PortStatusBuilder> each = this.ports.iterator();
        Object visitables = this._visitables.get("ports");
        while (each.hasNext()) {
            PortStatusBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<PortStatus> getPorts() {
        return this.ports != null ? LoadBalancerIngressFluentImpl.build(this.ports) : null;
    }

    @Override
    public List<PortStatus> buildPorts() {
        return this.ports != null ? LoadBalancerIngressFluentImpl.build(this.ports) : null;
    }

    @Override
    public PortStatus buildPort(Integer index) {
        return this.ports.get(index).build();
    }

    @Override
    public PortStatus buildFirstPort() {
        return this.ports.get(0).build();
    }

    @Override
    public PortStatus buildLastPort() {
        return this.ports.get(this.ports.size() - 1).build();
    }

    @Override
    public PortStatus buildMatchingPort(Predicate<PortStatusBuilder> predicate) {
        for (PortStatusBuilder item : this.ports) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingPort(Predicate<PortStatusBuilder> predicate) {
        for (PortStatusBuilder item : this.ports) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withPorts(List<PortStatus> ports) {
        if (this.ports != null) {
            this._visitables.get("ports").removeAll(this.ports);
        }
        if (ports != null) {
            this.ports = new ArrayList();
            for (PortStatus item : ports) {
                this.addToPorts(item);
            }
        } else {
            this.ports = null;
        }
        return (A)this;
    }

    @Override
    public A withPorts(PortStatus ... ports) {
        if (this.ports != null) {
            this.ports.clear();
        }
        if (ports != null) {
            for (PortStatus item : ports) {
                this.addToPorts(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasPorts() {
        return this.ports != null && !this.ports.isEmpty();
    }

    @Override
    public A addNewPort(String error, Integer port, String protocol) {
        return this.addToPorts(new PortStatus(error, port, protocol));
    }

    @Override
    public LoadBalancerIngressFluent.PortsNested<A> addNewPort() {
        return new PortsNestedImpl();
    }

    @Override
    public LoadBalancerIngressFluent.PortsNested<A> addNewPortLike(PortStatus item) {
        return new PortsNestedImpl(-1, item);
    }

    @Override
    public LoadBalancerIngressFluent.PortsNested<A> setNewPortLike(Integer index, PortStatus item) {
        return new PortsNestedImpl(index, item);
    }

    @Override
    public LoadBalancerIngressFluent.PortsNested<A> editPort(Integer index) {
        if (this.ports.size() <= index) {
            throw new RuntimeException("Can't edit ports. Index exceeds size.");
        }
        return this.setNewPortLike(index, this.buildPort(index));
    }

    @Override
    public LoadBalancerIngressFluent.PortsNested<A> editFirstPort() {
        if (this.ports.size() == 0) {
            throw new RuntimeException("Can't edit first ports. The list is empty.");
        }
        return this.setNewPortLike(0, this.buildPort(0));
    }

    @Override
    public LoadBalancerIngressFluent.PortsNested<A> editLastPort() {
        int index = this.ports.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last ports. The list is empty.");
        }
        return this.setNewPortLike(index, this.buildPort(index));
    }

    @Override
    public LoadBalancerIngressFluent.PortsNested<A> editMatchingPort(Predicate<PortStatusBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.ports.size(); ++i) {
            if (!predicate.test(this.ports.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching ports. No match found.");
        }
        return this.setNewPortLike(index, this.buildPort(index));
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LoadBalancerIngressFluentImpl that = (LoadBalancerIngressFluentImpl)o;
        if (this.hostname != null ? !this.hostname.equals(that.hostname) : that.hostname != null) {
            return false;
        }
        if (this.ip != null ? !this.ip.equals(that.ip) : that.ip != null) {
            return false;
        }
        if (this.ports != null ? !this.ports.equals(that.ports) : that.ports != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.hostname, this.ip, this.ports, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.hostname != null) {
            sb.append("hostname:");
            sb.append(this.hostname + ",");
        }
        if (this.ip != null) {
            sb.append("ip:");
            sb.append(this.ip + ",");
        }
        if (this.ports != null && !this.ports.isEmpty()) {
            sb.append("ports:");
            sb.append(this.ports + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    class PortsNestedImpl<N>
    extends PortStatusFluentImpl<LoadBalancerIngressFluent.PortsNested<N>>
    implements LoadBalancerIngressFluent.PortsNested<N>,
    Nested<N> {
        PortStatusBuilder builder;
        Integer index;

        PortsNestedImpl(Integer index, PortStatus item) {
            this.index = index;
            this.builder = new PortStatusBuilder(this, item);
        }

        PortsNestedImpl() {
            this.index = -1;
            this.builder = new PortStatusBuilder(this);
        }

        @Override
        public N and() {
            return (N)LoadBalancerIngressFluentImpl.this.setToPorts(this.index, this.builder.build());
        }

        @Override
        public N endPort() {
            return this.and();
        }
    }
}

