/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.builder.BaseFluent;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.builder.Nested;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.Affinity;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.AffinityBuilder;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.AffinityFluentImpl;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.Container;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.ContainerBuilder;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.ContainerFluentImpl;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.EphemeralContainer;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.EphemeralContainerBuilder;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.EphemeralContainerFluentImpl;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.HostAlias;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.HostAliasBuilder;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.HostAliasFluentImpl;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.LocalObjectReference;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.LocalObjectReferenceFluentImpl;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.PodDNSConfig;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.PodDNSConfigBuilder;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.PodDNSConfigFluentImpl;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.PodOS;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.PodOSBuilder;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.PodOSFluentImpl;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.PodReadinessGate;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.PodReadinessGateBuilder;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.PodReadinessGateFluentImpl;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.PodResourceClaim;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.PodResourceClaimBuilder;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.PodResourceClaimFluentImpl;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.PodSchedulingGate;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.PodSchedulingGateBuilder;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.PodSchedulingGateFluentImpl;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.PodSecurityContext;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.PodSecurityContextBuilder;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.PodSecurityContextFluentImpl;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.PodSpec;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.PodSpecFluent;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.Quantity;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.Toleration;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.TolerationBuilder;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.TolerationFluentImpl;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.TopologySpreadConstraint;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.TopologySpreadConstraintBuilder;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.TopologySpreadConstraintFluentImpl;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.Volume;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.VolumeBuilder;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.VolumeFluentImpl;

public class PodSpecFluentImpl<A extends PodSpecFluent<A>>
extends BaseFluent<A>
implements PodSpecFluent<A> {
    private Long activeDeadlineSeconds;
    private AffinityBuilder affinity;
    private Boolean automountServiceAccountToken;
    private ArrayList<ContainerBuilder> containers = new ArrayList();
    private PodDNSConfigBuilder dnsConfig;
    private String dnsPolicy;
    private Boolean enableServiceLinks;
    private ArrayList<EphemeralContainerBuilder> ephemeralContainers = new ArrayList();
    private ArrayList<HostAliasBuilder> hostAliases = new ArrayList();
    private Boolean hostIPC;
    private Boolean hostNetwork;
    private Boolean hostPID;
    private Boolean hostUsers;
    private String hostname;
    private ArrayList<LocalObjectReferenceBuilder> imagePullSecrets = new ArrayList();
    private ArrayList<ContainerBuilder> initContainers = new ArrayList();
    private String nodeName;
    private Map<String, String> nodeSelector;
    private PodOSBuilder os;
    private Map<String, Quantity> overhead;
    private String preemptionPolicy;
    private Integer priority;
    private String priorityClassName;
    private ArrayList<PodReadinessGateBuilder> readinessGates = new ArrayList();
    private ArrayList<PodResourceClaimBuilder> resourceClaims = new ArrayList();
    private String restartPolicy;
    private String runtimeClassName;
    private String schedulerName;
    private ArrayList<PodSchedulingGateBuilder> schedulingGates = new ArrayList();
    private PodSecurityContextBuilder securityContext;
    private String serviceAccount;
    private String serviceAccountName;
    private Boolean setHostnameAsFQDN;
    private Boolean shareProcessNamespace;
    private String subdomain;
    private Long terminationGracePeriodSeconds;
    private ArrayList<TolerationBuilder> tolerations = new ArrayList();
    private ArrayList<TopologySpreadConstraintBuilder> topologySpreadConstraints = new ArrayList();
    private ArrayList<VolumeBuilder> volumes = new ArrayList();
    private Map<String, Object> additionalProperties;

    public PodSpecFluentImpl() {
    }

    public PodSpecFluentImpl(PodSpec instance) {
        this.withActiveDeadlineSeconds(instance.getActiveDeadlineSeconds());
        this.withAffinity(instance.getAffinity());
        this.withAutomountServiceAccountToken(instance.getAutomountServiceAccountToken());
        this.withContainers(instance.getContainers());
        this.withDnsConfig(instance.getDnsConfig());
        this.withDnsPolicy(instance.getDnsPolicy());
        this.withEnableServiceLinks(instance.getEnableServiceLinks());
        this.withEphemeralContainers(instance.getEphemeralContainers());
        this.withHostAliases(instance.getHostAliases());
        this.withHostIPC(instance.getHostIPC());
        this.withHostNetwork(instance.getHostNetwork());
        this.withHostPID(instance.getHostPID());
        this.withHostUsers(instance.getHostUsers());
        this.withHostname(instance.getHostname());
        this.withImagePullSecrets(instance.getImagePullSecrets());
        this.withInitContainers(instance.getInitContainers());
        this.withNodeName(instance.getNodeName());
        this.withNodeSelector(instance.getNodeSelector());
        this.withOs(instance.getOs());
        this.withOverhead(instance.getOverhead());
        this.withPreemptionPolicy(instance.getPreemptionPolicy());
        this.withPriority(instance.getPriority());
        this.withPriorityClassName(instance.getPriorityClassName());
        this.withReadinessGates(instance.getReadinessGates());
        this.withResourceClaims(instance.getResourceClaims());
        this.withRestartPolicy(instance.getRestartPolicy());
        this.withRuntimeClassName(instance.getRuntimeClassName());
        this.withSchedulerName(instance.getSchedulerName());
        this.withSchedulingGates(instance.getSchedulingGates());
        this.withSecurityContext(instance.getSecurityContext());
        this.withServiceAccount(instance.getServiceAccount());
        this.withServiceAccountName(instance.getServiceAccountName());
        this.withSetHostnameAsFQDN(instance.getSetHostnameAsFQDN());
        this.withShareProcessNamespace(instance.getShareProcessNamespace());
        this.withSubdomain(instance.getSubdomain());
        this.withTerminationGracePeriodSeconds(instance.getTerminationGracePeriodSeconds());
        this.withTolerations(instance.getTolerations());
        this.withTopologySpreadConstraints(instance.getTopologySpreadConstraints());
        this.withVolumes(instance.getVolumes());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    public Long getActiveDeadlineSeconds() {
        return this.activeDeadlineSeconds;
    }

    @Override
    public A withActiveDeadlineSeconds(Long activeDeadlineSeconds) {
        this.activeDeadlineSeconds = activeDeadlineSeconds;
        return (A)this;
    }

    @Override
    public Boolean hasActiveDeadlineSeconds() {
        return this.activeDeadlineSeconds != null;
    }

    @Override
    @Deprecated
    public Affinity getAffinity() {
        return this.affinity != null ? this.affinity.build() : null;
    }

    @Override
    public Affinity buildAffinity() {
        return this.affinity != null ? this.affinity.build() : null;
    }

    @Override
    public A withAffinity(Affinity affinity) {
        this._visitables.get("affinity").remove(this.affinity);
        if (affinity != null) {
            this.affinity = new AffinityBuilder(affinity);
            this._visitables.get("affinity").add(this.affinity);
        } else {
            this.affinity = null;
            this._visitables.get("affinity").remove(this.affinity);
        }
        return (A)this;
    }

    @Override
    public Boolean hasAffinity() {
        return this.affinity != null;
    }

    @Override
    public PodSpecFluent.AffinityNested<A> withNewAffinity() {
        return new AffinityNestedImpl();
    }

    @Override
    public PodSpecFluent.AffinityNested<A> withNewAffinityLike(Affinity item) {
        return new AffinityNestedImpl(item);
    }

    @Override
    public PodSpecFluent.AffinityNested<A> editAffinity() {
        return this.withNewAffinityLike(this.getAffinity());
    }

    @Override
    public PodSpecFluent.AffinityNested<A> editOrNewAffinity() {
        return this.withNewAffinityLike(this.getAffinity() != null ? this.getAffinity() : new AffinityBuilder().build());
    }

    @Override
    public PodSpecFluent.AffinityNested<A> editOrNewAffinityLike(Affinity item) {
        return this.withNewAffinityLike(this.getAffinity() != null ? this.getAffinity() : item);
    }

    @Override
    public Boolean getAutomountServiceAccountToken() {
        return this.automountServiceAccountToken;
    }

    @Override
    public A withAutomountServiceAccountToken(Boolean automountServiceAccountToken) {
        this.automountServiceAccountToken = automountServiceAccountToken;
        return (A)this;
    }

    @Override
    public Boolean hasAutomountServiceAccountToken() {
        return this.automountServiceAccountToken != null;
    }

    @Override
    public A addToContainers(Integer index, Container item) {
        if (this.containers == null) {
            this.containers = new ArrayList();
        }
        ContainerBuilder builder = new ContainerBuilder(item);
        this._visitables.get("containers").add(index >= 0 ? index.intValue() : this._visitables.get("containers").size(), builder);
        this.containers.add(index >= 0 ? index.intValue() : this.containers.size(), builder);
        return (A)this;
    }

    @Override
    public A setToContainers(Integer index, Container item) {
        if (this.containers == null) {
            this.containers = new ArrayList();
        }
        ContainerBuilder builder = new ContainerBuilder(item);
        if (index < 0 || index >= this._visitables.get("containers").size()) {
            this._visitables.get("containers").add(builder);
        } else {
            this._visitables.get("containers").set(index, builder);
        }
        if (index < 0 || index >= this.containers.size()) {
            this.containers.add(builder);
        } else {
            this.containers.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToContainers(Container ... items) {
        if (this.containers == null) {
            this.containers = new ArrayList();
        }
        for (Container item : items) {
            ContainerBuilder builder = new ContainerBuilder(item);
            this._visitables.get("containers").add(builder);
            this.containers.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToContainers(Collection<Container> items) {
        if (this.containers == null) {
            this.containers = new ArrayList();
        }
        for (Container item : items) {
            ContainerBuilder builder = new ContainerBuilder(item);
            this._visitables.get("containers").add(builder);
            this.containers.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromContainers(Container ... items) {
        for (Container item : items) {
            ContainerBuilder builder = new ContainerBuilder(item);
            this._visitables.get("containers").remove(builder);
            if (this.containers == null) continue;
            this.containers.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromContainers(Collection<Container> items) {
        for (Container item : items) {
            ContainerBuilder builder = new ContainerBuilder(item);
            this._visitables.get("containers").remove(builder);
            if (this.containers == null) continue;
            this.containers.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromContainers(Predicate<ContainerBuilder> predicate) {
        if (this.containers == null) {
            return (A)this;
        }
        Iterator<ContainerBuilder> each = this.containers.iterator();
        Object visitables = this._visitables.get("containers");
        while (each.hasNext()) {
            ContainerBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<Container> getContainers() {
        return this.containers != null ? PodSpecFluentImpl.build(this.containers) : null;
    }

    @Override
    public List<Container> buildContainers() {
        return this.containers != null ? PodSpecFluentImpl.build(this.containers) : null;
    }

    @Override
    public Container buildContainer(Integer index) {
        return this.containers.get(index).build();
    }

    @Override
    public Container buildFirstContainer() {
        return this.containers.get(0).build();
    }

    @Override
    public Container buildLastContainer() {
        return this.containers.get(this.containers.size() - 1).build();
    }

    @Override
    public Container buildMatchingContainer(Predicate<ContainerBuilder> predicate) {
        for (ContainerBuilder item : this.containers) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingContainer(Predicate<ContainerBuilder> predicate) {
        for (ContainerBuilder item : this.containers) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withContainers(List<Container> containers) {
        if (this.containers != null) {
            this._visitables.get("containers").removeAll(this.containers);
        }
        if (containers != null) {
            this.containers = new ArrayList();
            for (Container item : containers) {
                this.addToContainers(item);
            }
        } else {
            this.containers = null;
        }
        return (A)this;
    }

    @Override
    public A withContainers(Container ... containers) {
        if (this.containers != null) {
            this.containers.clear();
        }
        if (containers != null) {
            for (Container item : containers) {
                this.addToContainers(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasContainers() {
        return this.containers != null && !this.containers.isEmpty();
    }

    @Override
    public PodSpecFluent.ContainersNested<A> addNewContainer() {
        return new ContainersNestedImpl();
    }

    @Override
    public PodSpecFluent.ContainersNested<A> addNewContainerLike(Container item) {
        return new ContainersNestedImpl(-1, item);
    }

    @Override
    public PodSpecFluent.ContainersNested<A> setNewContainerLike(Integer index, Container item) {
        return new ContainersNestedImpl(index, item);
    }

    @Override
    public PodSpecFluent.ContainersNested<A> editContainer(Integer index) {
        if (this.containers.size() <= index) {
            throw new RuntimeException("Can't edit containers. Index exceeds size.");
        }
        return this.setNewContainerLike(index, this.buildContainer(index));
    }

    @Override
    public PodSpecFluent.ContainersNested<A> editFirstContainer() {
        if (this.containers.size() == 0) {
            throw new RuntimeException("Can't edit first containers. The list is empty.");
        }
        return this.setNewContainerLike(0, this.buildContainer(0));
    }

    @Override
    public PodSpecFluent.ContainersNested<A> editLastContainer() {
        int index = this.containers.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last containers. The list is empty.");
        }
        return this.setNewContainerLike(index, this.buildContainer(index));
    }

    @Override
    public PodSpecFluent.ContainersNested<A> editMatchingContainer(Predicate<ContainerBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.containers.size(); ++i) {
            if (!predicate.test(this.containers.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching containers. No match found.");
        }
        return this.setNewContainerLike(index, this.buildContainer(index));
    }

    @Override
    @Deprecated
    public PodDNSConfig getDnsConfig() {
        return this.dnsConfig != null ? this.dnsConfig.build() : null;
    }

    @Override
    public PodDNSConfig buildDnsConfig() {
        return this.dnsConfig != null ? this.dnsConfig.build() : null;
    }

    @Override
    public A withDnsConfig(PodDNSConfig dnsConfig) {
        this._visitables.get("dnsConfig").remove(this.dnsConfig);
        if (dnsConfig != null) {
            this.dnsConfig = new PodDNSConfigBuilder(dnsConfig);
            this._visitables.get("dnsConfig").add(this.dnsConfig);
        } else {
            this.dnsConfig = null;
            this._visitables.get("dnsConfig").remove(this.dnsConfig);
        }
        return (A)this;
    }

    @Override
    public Boolean hasDnsConfig() {
        return this.dnsConfig != null;
    }

    @Override
    public PodSpecFluent.DnsConfigNested<A> withNewDnsConfig() {
        return new DnsConfigNestedImpl();
    }

    @Override
    public PodSpecFluent.DnsConfigNested<A> withNewDnsConfigLike(PodDNSConfig item) {
        return new DnsConfigNestedImpl(item);
    }

    @Override
    public PodSpecFluent.DnsConfigNested<A> editDnsConfig() {
        return this.withNewDnsConfigLike(this.getDnsConfig());
    }

    @Override
    public PodSpecFluent.DnsConfigNested<A> editOrNewDnsConfig() {
        return this.withNewDnsConfigLike(this.getDnsConfig() != null ? this.getDnsConfig() : new PodDNSConfigBuilder().build());
    }

    @Override
    public PodSpecFluent.DnsConfigNested<A> editOrNewDnsConfigLike(PodDNSConfig item) {
        return this.withNewDnsConfigLike(this.getDnsConfig() != null ? this.getDnsConfig() : item);
    }

    @Override
    public String getDnsPolicy() {
        return this.dnsPolicy;
    }

    @Override
    public A withDnsPolicy(String dnsPolicy) {
        this.dnsPolicy = dnsPolicy;
        return (A)this;
    }

    @Override
    public Boolean hasDnsPolicy() {
        return this.dnsPolicy != null;
    }

    @Override
    public Boolean getEnableServiceLinks() {
        return this.enableServiceLinks;
    }

    @Override
    public A withEnableServiceLinks(Boolean enableServiceLinks) {
        this.enableServiceLinks = enableServiceLinks;
        return (A)this;
    }

    @Override
    public Boolean hasEnableServiceLinks() {
        return this.enableServiceLinks != null;
    }

    @Override
    public A addToEphemeralContainers(Integer index, EphemeralContainer item) {
        if (this.ephemeralContainers == null) {
            this.ephemeralContainers = new ArrayList();
        }
        EphemeralContainerBuilder builder = new EphemeralContainerBuilder(item);
        this._visitables.get("ephemeralContainers").add(index >= 0 ? index.intValue() : this._visitables.get("ephemeralContainers").size(), builder);
        this.ephemeralContainers.add(index >= 0 ? index.intValue() : this.ephemeralContainers.size(), builder);
        return (A)this;
    }

    @Override
    public A setToEphemeralContainers(Integer index, EphemeralContainer item) {
        if (this.ephemeralContainers == null) {
            this.ephemeralContainers = new ArrayList();
        }
        EphemeralContainerBuilder builder = new EphemeralContainerBuilder(item);
        if (index < 0 || index >= this._visitables.get("ephemeralContainers").size()) {
            this._visitables.get("ephemeralContainers").add(builder);
        } else {
            this._visitables.get("ephemeralContainers").set(index, builder);
        }
        if (index < 0 || index >= this.ephemeralContainers.size()) {
            this.ephemeralContainers.add(builder);
        } else {
            this.ephemeralContainers.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToEphemeralContainers(EphemeralContainer ... items) {
        if (this.ephemeralContainers == null) {
            this.ephemeralContainers = new ArrayList();
        }
        for (EphemeralContainer item : items) {
            EphemeralContainerBuilder builder = new EphemeralContainerBuilder(item);
            this._visitables.get("ephemeralContainers").add(builder);
            this.ephemeralContainers.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToEphemeralContainers(Collection<EphemeralContainer> items) {
        if (this.ephemeralContainers == null) {
            this.ephemeralContainers = new ArrayList();
        }
        for (EphemeralContainer item : items) {
            EphemeralContainerBuilder builder = new EphemeralContainerBuilder(item);
            this._visitables.get("ephemeralContainers").add(builder);
            this.ephemeralContainers.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromEphemeralContainers(EphemeralContainer ... items) {
        for (EphemeralContainer item : items) {
            EphemeralContainerBuilder builder = new EphemeralContainerBuilder(item);
            this._visitables.get("ephemeralContainers").remove(builder);
            if (this.ephemeralContainers == null) continue;
            this.ephemeralContainers.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromEphemeralContainers(Collection<EphemeralContainer> items) {
        for (EphemeralContainer item : items) {
            EphemeralContainerBuilder builder = new EphemeralContainerBuilder(item);
            this._visitables.get("ephemeralContainers").remove(builder);
            if (this.ephemeralContainers == null) continue;
            this.ephemeralContainers.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromEphemeralContainers(Predicate<EphemeralContainerBuilder> predicate) {
        if (this.ephemeralContainers == null) {
            return (A)this;
        }
        Iterator<EphemeralContainerBuilder> each = this.ephemeralContainers.iterator();
        Object visitables = this._visitables.get("ephemeralContainers");
        while (each.hasNext()) {
            EphemeralContainerBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<EphemeralContainer> getEphemeralContainers() {
        return this.ephemeralContainers != null ? PodSpecFluentImpl.build(this.ephemeralContainers) : null;
    }

    @Override
    public List<EphemeralContainer> buildEphemeralContainers() {
        return this.ephemeralContainers != null ? PodSpecFluentImpl.build(this.ephemeralContainers) : null;
    }

    @Override
    public EphemeralContainer buildEphemeralContainer(Integer index) {
        return this.ephemeralContainers.get(index).build();
    }

    @Override
    public EphemeralContainer buildFirstEphemeralContainer() {
        return this.ephemeralContainers.get(0).build();
    }

    @Override
    public EphemeralContainer buildLastEphemeralContainer() {
        return this.ephemeralContainers.get(this.ephemeralContainers.size() - 1).build();
    }

    @Override
    public EphemeralContainer buildMatchingEphemeralContainer(Predicate<EphemeralContainerBuilder> predicate) {
        for (EphemeralContainerBuilder item : this.ephemeralContainers) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingEphemeralContainer(Predicate<EphemeralContainerBuilder> predicate) {
        for (EphemeralContainerBuilder item : this.ephemeralContainers) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withEphemeralContainers(List<EphemeralContainer> ephemeralContainers) {
        if (this.ephemeralContainers != null) {
            this._visitables.get("ephemeralContainers").removeAll(this.ephemeralContainers);
        }
        if (ephemeralContainers != null) {
            this.ephemeralContainers = new ArrayList();
            for (EphemeralContainer item : ephemeralContainers) {
                this.addToEphemeralContainers(item);
            }
        } else {
            this.ephemeralContainers = null;
        }
        return (A)this;
    }

    @Override
    public A withEphemeralContainers(EphemeralContainer ... ephemeralContainers) {
        if (this.ephemeralContainers != null) {
            this.ephemeralContainers.clear();
        }
        if (ephemeralContainers != null) {
            for (EphemeralContainer item : ephemeralContainers) {
                this.addToEphemeralContainers(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasEphemeralContainers() {
        return this.ephemeralContainers != null && !this.ephemeralContainers.isEmpty();
    }

    @Override
    public PodSpecFluent.EphemeralContainersNested<A> addNewEphemeralContainer() {
        return new EphemeralContainersNestedImpl();
    }

    @Override
    public PodSpecFluent.EphemeralContainersNested<A> addNewEphemeralContainerLike(EphemeralContainer item) {
        return new EphemeralContainersNestedImpl(-1, item);
    }

    @Override
    public PodSpecFluent.EphemeralContainersNested<A> setNewEphemeralContainerLike(Integer index, EphemeralContainer item) {
        return new EphemeralContainersNestedImpl(index, item);
    }

    @Override
    public PodSpecFluent.EphemeralContainersNested<A> editEphemeralContainer(Integer index) {
        if (this.ephemeralContainers.size() <= index) {
            throw new RuntimeException("Can't edit ephemeralContainers. Index exceeds size.");
        }
        return this.setNewEphemeralContainerLike(index, this.buildEphemeralContainer(index));
    }

    @Override
    public PodSpecFluent.EphemeralContainersNested<A> editFirstEphemeralContainer() {
        if (this.ephemeralContainers.size() == 0) {
            throw new RuntimeException("Can't edit first ephemeralContainers. The list is empty.");
        }
        return this.setNewEphemeralContainerLike(0, this.buildEphemeralContainer(0));
    }

    @Override
    public PodSpecFluent.EphemeralContainersNested<A> editLastEphemeralContainer() {
        int index = this.ephemeralContainers.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last ephemeralContainers. The list is empty.");
        }
        return this.setNewEphemeralContainerLike(index, this.buildEphemeralContainer(index));
    }

    @Override
    public PodSpecFluent.EphemeralContainersNested<A> editMatchingEphemeralContainer(Predicate<EphemeralContainerBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.ephemeralContainers.size(); ++i) {
            if (!predicate.test(this.ephemeralContainers.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching ephemeralContainers. No match found.");
        }
        return this.setNewEphemeralContainerLike(index, this.buildEphemeralContainer(index));
    }

    @Override
    public A addToHostAliases(Integer index, HostAlias item) {
        if (this.hostAliases == null) {
            this.hostAliases = new ArrayList();
        }
        HostAliasBuilder builder = new HostAliasBuilder(item);
        this._visitables.get("hostAliases").add(index >= 0 ? index.intValue() : this._visitables.get("hostAliases").size(), builder);
        this.hostAliases.add(index >= 0 ? index.intValue() : this.hostAliases.size(), builder);
        return (A)this;
    }

    @Override
    public A setToHostAliases(Integer index, HostAlias item) {
        if (this.hostAliases == null) {
            this.hostAliases = new ArrayList();
        }
        HostAliasBuilder builder = new HostAliasBuilder(item);
        if (index < 0 || index >= this._visitables.get("hostAliases").size()) {
            this._visitables.get("hostAliases").add(builder);
        } else {
            this._visitables.get("hostAliases").set(index, builder);
        }
        if (index < 0 || index >= this.hostAliases.size()) {
            this.hostAliases.add(builder);
        } else {
            this.hostAliases.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToHostAliases(HostAlias ... items) {
        if (this.hostAliases == null) {
            this.hostAliases = new ArrayList();
        }
        for (HostAlias item : items) {
            HostAliasBuilder builder = new HostAliasBuilder(item);
            this._visitables.get("hostAliases").add(builder);
            this.hostAliases.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToHostAliases(Collection<HostAlias> items) {
        if (this.hostAliases == null) {
            this.hostAliases = new ArrayList();
        }
        for (HostAlias item : items) {
            HostAliasBuilder builder = new HostAliasBuilder(item);
            this._visitables.get("hostAliases").add(builder);
            this.hostAliases.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromHostAliases(HostAlias ... items) {
        for (HostAlias item : items) {
            HostAliasBuilder builder = new HostAliasBuilder(item);
            this._visitables.get("hostAliases").remove(builder);
            if (this.hostAliases == null) continue;
            this.hostAliases.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromHostAliases(Collection<HostAlias> items) {
        for (HostAlias item : items) {
            HostAliasBuilder builder = new HostAliasBuilder(item);
            this._visitables.get("hostAliases").remove(builder);
            if (this.hostAliases == null) continue;
            this.hostAliases.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromHostAliases(Predicate<HostAliasBuilder> predicate) {
        if (this.hostAliases == null) {
            return (A)this;
        }
        Iterator<HostAliasBuilder> each = this.hostAliases.iterator();
        Object visitables = this._visitables.get("hostAliases");
        while (each.hasNext()) {
            HostAliasBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<HostAlias> getHostAliases() {
        return this.hostAliases != null ? PodSpecFluentImpl.build(this.hostAliases) : null;
    }

    @Override
    public List<HostAlias> buildHostAliases() {
        return this.hostAliases != null ? PodSpecFluentImpl.build(this.hostAliases) : null;
    }

    @Override
    public HostAlias buildHostAlias(Integer index) {
        return this.hostAliases.get(index).build();
    }

    @Override
    public HostAlias buildFirstHostAlias() {
        return this.hostAliases.get(0).build();
    }

    @Override
    public HostAlias buildLastHostAlias() {
        return this.hostAliases.get(this.hostAliases.size() - 1).build();
    }

    @Override
    public HostAlias buildMatchingHostAlias(Predicate<HostAliasBuilder> predicate) {
        for (HostAliasBuilder item : this.hostAliases) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingHostAlias(Predicate<HostAliasBuilder> predicate) {
        for (HostAliasBuilder item : this.hostAliases) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withHostAliases(List<HostAlias> hostAliases) {
        if (this.hostAliases != null) {
            this._visitables.get("hostAliases").removeAll(this.hostAliases);
        }
        if (hostAliases != null) {
            this.hostAliases = new ArrayList();
            for (HostAlias item : hostAliases) {
                this.addToHostAliases(item);
            }
        } else {
            this.hostAliases = null;
        }
        return (A)this;
    }

    @Override
    public A withHostAliases(HostAlias ... hostAliases) {
        if (this.hostAliases != null) {
            this.hostAliases.clear();
        }
        if (hostAliases != null) {
            for (HostAlias item : hostAliases) {
                this.addToHostAliases(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasHostAliases() {
        return this.hostAliases != null && !this.hostAliases.isEmpty();
    }

    @Override
    public PodSpecFluent.HostAliasesNested<A> addNewHostAlias() {
        return new HostAliasesNestedImpl();
    }

    @Override
    public PodSpecFluent.HostAliasesNested<A> addNewHostAliasLike(HostAlias item) {
        return new HostAliasesNestedImpl(-1, item);
    }

    @Override
    public PodSpecFluent.HostAliasesNested<A> setNewHostAliasLike(Integer index, HostAlias item) {
        return new HostAliasesNestedImpl(index, item);
    }

    @Override
    public PodSpecFluent.HostAliasesNested<A> editHostAlias(Integer index) {
        if (this.hostAliases.size() <= index) {
            throw new RuntimeException("Can't edit hostAliases. Index exceeds size.");
        }
        return this.setNewHostAliasLike(index, this.buildHostAlias(index));
    }

    @Override
    public PodSpecFluent.HostAliasesNested<A> editFirstHostAlias() {
        if (this.hostAliases.size() == 0) {
            throw new RuntimeException("Can't edit first hostAliases. The list is empty.");
        }
        return this.setNewHostAliasLike(0, this.buildHostAlias(0));
    }

    @Override
    public PodSpecFluent.HostAliasesNested<A> editLastHostAlias() {
        int index = this.hostAliases.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last hostAliases. The list is empty.");
        }
        return this.setNewHostAliasLike(index, this.buildHostAlias(index));
    }

    @Override
    public PodSpecFluent.HostAliasesNested<A> editMatchingHostAlias(Predicate<HostAliasBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.hostAliases.size(); ++i) {
            if (!predicate.test(this.hostAliases.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching hostAliases. No match found.");
        }
        return this.setNewHostAliasLike(index, this.buildHostAlias(index));
    }

    @Override
    public Boolean getHostIPC() {
        return this.hostIPC;
    }

    @Override
    public A withHostIPC(Boolean hostIPC) {
        this.hostIPC = hostIPC;
        return (A)this;
    }

    @Override
    public Boolean hasHostIPC() {
        return this.hostIPC != null;
    }

    @Override
    public Boolean getHostNetwork() {
        return this.hostNetwork;
    }

    @Override
    public A withHostNetwork(Boolean hostNetwork) {
        this.hostNetwork = hostNetwork;
        return (A)this;
    }

    @Override
    public Boolean hasHostNetwork() {
        return this.hostNetwork != null;
    }

    @Override
    public Boolean getHostPID() {
        return this.hostPID;
    }

    @Override
    public A withHostPID(Boolean hostPID) {
        this.hostPID = hostPID;
        return (A)this;
    }

    @Override
    public Boolean hasHostPID() {
        return this.hostPID != null;
    }

    @Override
    public Boolean getHostUsers() {
        return this.hostUsers;
    }

    @Override
    public A withHostUsers(Boolean hostUsers) {
        this.hostUsers = hostUsers;
        return (A)this;
    }

    @Override
    public Boolean hasHostUsers() {
        return this.hostUsers != null;
    }

    @Override
    public String getHostname() {
        return this.hostname;
    }

    @Override
    public A withHostname(String hostname) {
        this.hostname = hostname;
        return (A)this;
    }

    @Override
    public Boolean hasHostname() {
        return this.hostname != null;
    }

    @Override
    public A addToImagePullSecrets(Integer index, LocalObjectReference item) {
        if (this.imagePullSecrets == null) {
            this.imagePullSecrets = new ArrayList();
        }
        LocalObjectReferenceBuilder builder = new LocalObjectReferenceBuilder(item);
        this._visitables.get("imagePullSecrets").add(index >= 0 ? index.intValue() : this._visitables.get("imagePullSecrets").size(), builder);
        this.imagePullSecrets.add(index >= 0 ? index.intValue() : this.imagePullSecrets.size(), builder);
        return (A)this;
    }

    @Override
    public A setToImagePullSecrets(Integer index, LocalObjectReference item) {
        if (this.imagePullSecrets == null) {
            this.imagePullSecrets = new ArrayList();
        }
        LocalObjectReferenceBuilder builder = new LocalObjectReferenceBuilder(item);
        if (index < 0 || index >= this._visitables.get("imagePullSecrets").size()) {
            this._visitables.get("imagePullSecrets").add(builder);
        } else {
            this._visitables.get("imagePullSecrets").set(index, builder);
        }
        if (index < 0 || index >= this.imagePullSecrets.size()) {
            this.imagePullSecrets.add(builder);
        } else {
            this.imagePullSecrets.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToImagePullSecrets(LocalObjectReference ... items) {
        if (this.imagePullSecrets == null) {
            this.imagePullSecrets = new ArrayList();
        }
        for (LocalObjectReference item : items) {
            LocalObjectReferenceBuilder builder = new LocalObjectReferenceBuilder(item);
            this._visitables.get("imagePullSecrets").add(builder);
            this.imagePullSecrets.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToImagePullSecrets(Collection<LocalObjectReference> items) {
        if (this.imagePullSecrets == null) {
            this.imagePullSecrets = new ArrayList();
        }
        for (LocalObjectReference item : items) {
            LocalObjectReferenceBuilder builder = new LocalObjectReferenceBuilder(item);
            this._visitables.get("imagePullSecrets").add(builder);
            this.imagePullSecrets.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromImagePullSecrets(LocalObjectReference ... items) {
        for (LocalObjectReference item : items) {
            LocalObjectReferenceBuilder builder = new LocalObjectReferenceBuilder(item);
            this._visitables.get("imagePullSecrets").remove(builder);
            if (this.imagePullSecrets == null) continue;
            this.imagePullSecrets.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromImagePullSecrets(Collection<LocalObjectReference> items) {
        for (LocalObjectReference item : items) {
            LocalObjectReferenceBuilder builder = new LocalObjectReferenceBuilder(item);
            this._visitables.get("imagePullSecrets").remove(builder);
            if (this.imagePullSecrets == null) continue;
            this.imagePullSecrets.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromImagePullSecrets(Predicate<LocalObjectReferenceBuilder> predicate) {
        if (this.imagePullSecrets == null) {
            return (A)this;
        }
        Iterator<LocalObjectReferenceBuilder> each = this.imagePullSecrets.iterator();
        Object visitables = this._visitables.get("imagePullSecrets");
        while (each.hasNext()) {
            LocalObjectReferenceBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<LocalObjectReference> getImagePullSecrets() {
        return this.imagePullSecrets != null ? PodSpecFluentImpl.build(this.imagePullSecrets) : null;
    }

    @Override
    public List<LocalObjectReference> buildImagePullSecrets() {
        return this.imagePullSecrets != null ? PodSpecFluentImpl.build(this.imagePullSecrets) : null;
    }

    @Override
    public LocalObjectReference buildImagePullSecret(Integer index) {
        return this.imagePullSecrets.get(index).build();
    }

    @Override
    public LocalObjectReference buildFirstImagePullSecret() {
        return this.imagePullSecrets.get(0).build();
    }

    @Override
    public LocalObjectReference buildLastImagePullSecret() {
        return this.imagePullSecrets.get(this.imagePullSecrets.size() - 1).build();
    }

    @Override
    public LocalObjectReference buildMatchingImagePullSecret(Predicate<LocalObjectReferenceBuilder> predicate) {
        for (LocalObjectReferenceBuilder item : this.imagePullSecrets) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingImagePullSecret(Predicate<LocalObjectReferenceBuilder> predicate) {
        for (LocalObjectReferenceBuilder item : this.imagePullSecrets) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withImagePullSecrets(List<LocalObjectReference> imagePullSecrets) {
        if (this.imagePullSecrets != null) {
            this._visitables.get("imagePullSecrets").removeAll(this.imagePullSecrets);
        }
        if (imagePullSecrets != null) {
            this.imagePullSecrets = new ArrayList();
            for (LocalObjectReference item : imagePullSecrets) {
                this.addToImagePullSecrets(item);
            }
        } else {
            this.imagePullSecrets = null;
        }
        return (A)this;
    }

    @Override
    public A withImagePullSecrets(LocalObjectReference ... imagePullSecrets) {
        if (this.imagePullSecrets != null) {
            this.imagePullSecrets.clear();
        }
        if (imagePullSecrets != null) {
            for (LocalObjectReference item : imagePullSecrets) {
                this.addToImagePullSecrets(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasImagePullSecrets() {
        return this.imagePullSecrets != null && !this.imagePullSecrets.isEmpty();
    }

    @Override
    public A addNewImagePullSecret(String name) {
        return this.addToImagePullSecrets(new LocalObjectReference(name));
    }

    @Override
    public PodSpecFluent.ImagePullSecretsNested<A> addNewImagePullSecret() {
        return new ImagePullSecretsNestedImpl();
    }

    @Override
    public PodSpecFluent.ImagePullSecretsNested<A> addNewImagePullSecretLike(LocalObjectReference item) {
        return new ImagePullSecretsNestedImpl(-1, item);
    }

    @Override
    public PodSpecFluent.ImagePullSecretsNested<A> setNewImagePullSecretLike(Integer index, LocalObjectReference item) {
        return new ImagePullSecretsNestedImpl(index, item);
    }

    @Override
    public PodSpecFluent.ImagePullSecretsNested<A> editImagePullSecret(Integer index) {
        if (this.imagePullSecrets.size() <= index) {
            throw new RuntimeException("Can't edit imagePullSecrets. Index exceeds size.");
        }
        return this.setNewImagePullSecretLike(index, this.buildImagePullSecret(index));
    }

    @Override
    public PodSpecFluent.ImagePullSecretsNested<A> editFirstImagePullSecret() {
        if (this.imagePullSecrets.size() == 0) {
            throw new RuntimeException("Can't edit first imagePullSecrets. The list is empty.");
        }
        return this.setNewImagePullSecretLike(0, this.buildImagePullSecret(0));
    }

    @Override
    public PodSpecFluent.ImagePullSecretsNested<A> editLastImagePullSecret() {
        int index = this.imagePullSecrets.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last imagePullSecrets. The list is empty.");
        }
        return this.setNewImagePullSecretLike(index, this.buildImagePullSecret(index));
    }

    @Override
    public PodSpecFluent.ImagePullSecretsNested<A> editMatchingImagePullSecret(Predicate<LocalObjectReferenceBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.imagePullSecrets.size(); ++i) {
            if (!predicate.test(this.imagePullSecrets.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching imagePullSecrets. No match found.");
        }
        return this.setNewImagePullSecretLike(index, this.buildImagePullSecret(index));
    }

    @Override
    public A addToInitContainers(Integer index, Container item) {
        if (this.initContainers == null) {
            this.initContainers = new ArrayList();
        }
        ContainerBuilder builder = new ContainerBuilder(item);
        this._visitables.get("initContainers").add(index >= 0 ? index.intValue() : this._visitables.get("initContainers").size(), builder);
        this.initContainers.add(index >= 0 ? index.intValue() : this.initContainers.size(), builder);
        return (A)this;
    }

    @Override
    public A setToInitContainers(Integer index, Container item) {
        if (this.initContainers == null) {
            this.initContainers = new ArrayList();
        }
        ContainerBuilder builder = new ContainerBuilder(item);
        if (index < 0 || index >= this._visitables.get("initContainers").size()) {
            this._visitables.get("initContainers").add(builder);
        } else {
            this._visitables.get("initContainers").set(index, builder);
        }
        if (index < 0 || index >= this.initContainers.size()) {
            this.initContainers.add(builder);
        } else {
            this.initContainers.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToInitContainers(Container ... items) {
        if (this.initContainers == null) {
            this.initContainers = new ArrayList();
        }
        for (Container item : items) {
            ContainerBuilder builder = new ContainerBuilder(item);
            this._visitables.get("initContainers").add(builder);
            this.initContainers.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToInitContainers(Collection<Container> items) {
        if (this.initContainers == null) {
            this.initContainers = new ArrayList();
        }
        for (Container item : items) {
            ContainerBuilder builder = new ContainerBuilder(item);
            this._visitables.get("initContainers").add(builder);
            this.initContainers.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromInitContainers(Container ... items) {
        for (Container item : items) {
            ContainerBuilder builder = new ContainerBuilder(item);
            this._visitables.get("initContainers").remove(builder);
            if (this.initContainers == null) continue;
            this.initContainers.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromInitContainers(Collection<Container> items) {
        for (Container item : items) {
            ContainerBuilder builder = new ContainerBuilder(item);
            this._visitables.get("initContainers").remove(builder);
            if (this.initContainers == null) continue;
            this.initContainers.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromInitContainers(Predicate<ContainerBuilder> predicate) {
        if (this.initContainers == null) {
            return (A)this;
        }
        Iterator<ContainerBuilder> each = this.initContainers.iterator();
        Object visitables = this._visitables.get("initContainers");
        while (each.hasNext()) {
            ContainerBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<Container> getInitContainers() {
        return this.initContainers != null ? PodSpecFluentImpl.build(this.initContainers) : null;
    }

    @Override
    public List<Container> buildInitContainers() {
        return this.initContainers != null ? PodSpecFluentImpl.build(this.initContainers) : null;
    }

    @Override
    public Container buildInitContainer(Integer index) {
        return this.initContainers.get(index).build();
    }

    @Override
    public Container buildFirstInitContainer() {
        return this.initContainers.get(0).build();
    }

    @Override
    public Container buildLastInitContainer() {
        return this.initContainers.get(this.initContainers.size() - 1).build();
    }

    @Override
    public Container buildMatchingInitContainer(Predicate<ContainerBuilder> predicate) {
        for (ContainerBuilder item : this.initContainers) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingInitContainer(Predicate<ContainerBuilder> predicate) {
        for (ContainerBuilder item : this.initContainers) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withInitContainers(List<Container> initContainers) {
        if (this.initContainers != null) {
            this._visitables.get("initContainers").removeAll(this.initContainers);
        }
        if (initContainers != null) {
            this.initContainers = new ArrayList();
            for (Container item : initContainers) {
                this.addToInitContainers(item);
            }
        } else {
            this.initContainers = null;
        }
        return (A)this;
    }

    @Override
    public A withInitContainers(Container ... initContainers) {
        if (this.initContainers != null) {
            this.initContainers.clear();
        }
        if (initContainers != null) {
            for (Container item : initContainers) {
                this.addToInitContainers(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasInitContainers() {
        return this.initContainers != null && !this.initContainers.isEmpty();
    }

    @Override
    public PodSpecFluent.InitContainersNested<A> addNewInitContainer() {
        return new InitContainersNestedImpl();
    }

    @Override
    public PodSpecFluent.InitContainersNested<A> addNewInitContainerLike(Container item) {
        return new InitContainersNestedImpl(-1, item);
    }

    @Override
    public PodSpecFluent.InitContainersNested<A> setNewInitContainerLike(Integer index, Container item) {
        return new InitContainersNestedImpl(index, item);
    }

    @Override
    public PodSpecFluent.InitContainersNested<A> editInitContainer(Integer index) {
        if (this.initContainers.size() <= index) {
            throw new RuntimeException("Can't edit initContainers. Index exceeds size.");
        }
        return this.setNewInitContainerLike(index, this.buildInitContainer(index));
    }

    @Override
    public PodSpecFluent.InitContainersNested<A> editFirstInitContainer() {
        if (this.initContainers.size() == 0) {
            throw new RuntimeException("Can't edit first initContainers. The list is empty.");
        }
        return this.setNewInitContainerLike(0, this.buildInitContainer(0));
    }

    @Override
    public PodSpecFluent.InitContainersNested<A> editLastInitContainer() {
        int index = this.initContainers.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last initContainers. The list is empty.");
        }
        return this.setNewInitContainerLike(index, this.buildInitContainer(index));
    }

    @Override
    public PodSpecFluent.InitContainersNested<A> editMatchingInitContainer(Predicate<ContainerBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.initContainers.size(); ++i) {
            if (!predicate.test(this.initContainers.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching initContainers. No match found.");
        }
        return this.setNewInitContainerLike(index, this.buildInitContainer(index));
    }

    @Override
    public String getNodeName() {
        return this.nodeName;
    }

    @Override
    public A withNodeName(String nodeName) {
        this.nodeName = nodeName;
        return (A)this;
    }

    @Override
    public Boolean hasNodeName() {
        return this.nodeName != null;
    }

    @Override
    public A addToNodeSelector(String key, String value) {
        if (this.nodeSelector == null && key != null && value != null) {
            this.nodeSelector = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.nodeSelector.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToNodeSelector(Map<String, String> map) {
        if (this.nodeSelector == null && map != null) {
            this.nodeSelector = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.nodeSelector.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromNodeSelector(String key) {
        if (this.nodeSelector == null) {
            return (A)this;
        }
        if (key != null && this.nodeSelector != null) {
            this.nodeSelector.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromNodeSelector(Map<String, String> map) {
        if (this.nodeSelector == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.nodeSelector == null) continue;
                this.nodeSelector.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, String> getNodeSelector() {
        return this.nodeSelector;
    }

    @Override
    public <K, V> A withNodeSelector(Map<String, String> nodeSelector) {
        this.nodeSelector = nodeSelector == null ? null : new LinkedHashMap<String, String>(nodeSelector);
        return (A)this;
    }

    @Override
    public Boolean hasNodeSelector() {
        return this.nodeSelector != null;
    }

    @Override
    @Deprecated
    public PodOS getOs() {
        return this.os != null ? this.os.build() : null;
    }

    @Override
    public PodOS buildOs() {
        return this.os != null ? this.os.build() : null;
    }

    @Override
    public A withOs(PodOS os) {
        this._visitables.get("os").remove(this.os);
        if (os != null) {
            this.os = new PodOSBuilder(os);
            this._visitables.get("os").add(this.os);
        } else {
            this.os = null;
            this._visitables.get("os").remove(this.os);
        }
        return (A)this;
    }

    @Override
    public Boolean hasOs() {
        return this.os != null;
    }

    @Override
    public A withNewOs(String name) {
        return this.withOs(new PodOS(name));
    }

    @Override
    public PodSpecFluent.OsNested<A> withNewOs() {
        return new OsNestedImpl();
    }

    @Override
    public PodSpecFluent.OsNested<A> withNewOsLike(PodOS item) {
        return new OsNestedImpl(item);
    }

    @Override
    public PodSpecFluent.OsNested<A> editOs() {
        return this.withNewOsLike(this.getOs());
    }

    @Override
    public PodSpecFluent.OsNested<A> editOrNewOs() {
        return this.withNewOsLike(this.getOs() != null ? this.getOs() : new PodOSBuilder().build());
    }

    @Override
    public PodSpecFluent.OsNested<A> editOrNewOsLike(PodOS item) {
        return this.withNewOsLike(this.getOs() != null ? this.getOs() : item);
    }

    @Override
    public A addToOverhead(String key, Quantity value) {
        if (this.overhead == null && key != null && value != null) {
            this.overhead = new LinkedHashMap<String, Quantity>();
        }
        if (key != null && value != null) {
            this.overhead.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToOverhead(Map<String, Quantity> map) {
        if (this.overhead == null && map != null) {
            this.overhead = new LinkedHashMap<String, Quantity>();
        }
        if (map != null) {
            this.overhead.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromOverhead(String key) {
        if (this.overhead == null) {
            return (A)this;
        }
        if (key != null && this.overhead != null) {
            this.overhead.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromOverhead(Map<String, Quantity> map) {
        if (this.overhead == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.overhead == null) continue;
                this.overhead.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Quantity> getOverhead() {
        return this.overhead;
    }

    @Override
    public <K, V> A withOverhead(Map<String, Quantity> overhead) {
        this.overhead = overhead == null ? null : new LinkedHashMap<String, Quantity>(overhead);
        return (A)this;
    }

    @Override
    public Boolean hasOverhead() {
        return this.overhead != null;
    }

    @Override
    public String getPreemptionPolicy() {
        return this.preemptionPolicy;
    }

    @Override
    public A withPreemptionPolicy(String preemptionPolicy) {
        this.preemptionPolicy = preemptionPolicy;
        return (A)this;
    }

    @Override
    public Boolean hasPreemptionPolicy() {
        return this.preemptionPolicy != null;
    }

    @Override
    public Integer getPriority() {
        return this.priority;
    }

    @Override
    public A withPriority(Integer priority) {
        this.priority = priority;
        return (A)this;
    }

    @Override
    public Boolean hasPriority() {
        return this.priority != null;
    }

    @Override
    public String getPriorityClassName() {
        return this.priorityClassName;
    }

    @Override
    public A withPriorityClassName(String priorityClassName) {
        this.priorityClassName = priorityClassName;
        return (A)this;
    }

    @Override
    public Boolean hasPriorityClassName() {
        return this.priorityClassName != null;
    }

    @Override
    public A addToReadinessGates(Integer index, PodReadinessGate item) {
        if (this.readinessGates == null) {
            this.readinessGates = new ArrayList();
        }
        PodReadinessGateBuilder builder = new PodReadinessGateBuilder(item);
        this._visitables.get("readinessGates").add(index >= 0 ? index.intValue() : this._visitables.get("readinessGates").size(), builder);
        this.readinessGates.add(index >= 0 ? index.intValue() : this.readinessGates.size(), builder);
        return (A)this;
    }

    @Override
    public A setToReadinessGates(Integer index, PodReadinessGate item) {
        if (this.readinessGates == null) {
            this.readinessGates = new ArrayList();
        }
        PodReadinessGateBuilder builder = new PodReadinessGateBuilder(item);
        if (index < 0 || index >= this._visitables.get("readinessGates").size()) {
            this._visitables.get("readinessGates").add(builder);
        } else {
            this._visitables.get("readinessGates").set(index, builder);
        }
        if (index < 0 || index >= this.readinessGates.size()) {
            this.readinessGates.add(builder);
        } else {
            this.readinessGates.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToReadinessGates(PodReadinessGate ... items) {
        if (this.readinessGates == null) {
            this.readinessGates = new ArrayList();
        }
        for (PodReadinessGate item : items) {
            PodReadinessGateBuilder builder = new PodReadinessGateBuilder(item);
            this._visitables.get("readinessGates").add(builder);
            this.readinessGates.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToReadinessGates(Collection<PodReadinessGate> items) {
        if (this.readinessGates == null) {
            this.readinessGates = new ArrayList();
        }
        for (PodReadinessGate item : items) {
            PodReadinessGateBuilder builder = new PodReadinessGateBuilder(item);
            this._visitables.get("readinessGates").add(builder);
            this.readinessGates.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromReadinessGates(PodReadinessGate ... items) {
        for (PodReadinessGate item : items) {
            PodReadinessGateBuilder builder = new PodReadinessGateBuilder(item);
            this._visitables.get("readinessGates").remove(builder);
            if (this.readinessGates == null) continue;
            this.readinessGates.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromReadinessGates(Collection<PodReadinessGate> items) {
        for (PodReadinessGate item : items) {
            PodReadinessGateBuilder builder = new PodReadinessGateBuilder(item);
            this._visitables.get("readinessGates").remove(builder);
            if (this.readinessGates == null) continue;
            this.readinessGates.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromReadinessGates(Predicate<PodReadinessGateBuilder> predicate) {
        if (this.readinessGates == null) {
            return (A)this;
        }
        Iterator<PodReadinessGateBuilder> each = this.readinessGates.iterator();
        Object visitables = this._visitables.get("readinessGates");
        while (each.hasNext()) {
            PodReadinessGateBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<PodReadinessGate> getReadinessGates() {
        return this.readinessGates != null ? PodSpecFluentImpl.build(this.readinessGates) : null;
    }

    @Override
    public List<PodReadinessGate> buildReadinessGates() {
        return this.readinessGates != null ? PodSpecFluentImpl.build(this.readinessGates) : null;
    }

    @Override
    public PodReadinessGate buildReadinessGate(Integer index) {
        return this.readinessGates.get(index).build();
    }

    @Override
    public PodReadinessGate buildFirstReadinessGate() {
        return this.readinessGates.get(0).build();
    }

    @Override
    public PodReadinessGate buildLastReadinessGate() {
        return this.readinessGates.get(this.readinessGates.size() - 1).build();
    }

    @Override
    public PodReadinessGate buildMatchingReadinessGate(Predicate<PodReadinessGateBuilder> predicate) {
        for (PodReadinessGateBuilder item : this.readinessGates) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingReadinessGate(Predicate<PodReadinessGateBuilder> predicate) {
        for (PodReadinessGateBuilder item : this.readinessGates) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withReadinessGates(List<PodReadinessGate> readinessGates) {
        if (this.readinessGates != null) {
            this._visitables.get("readinessGates").removeAll(this.readinessGates);
        }
        if (readinessGates != null) {
            this.readinessGates = new ArrayList();
            for (PodReadinessGate item : readinessGates) {
                this.addToReadinessGates(item);
            }
        } else {
            this.readinessGates = null;
        }
        return (A)this;
    }

    @Override
    public A withReadinessGates(PodReadinessGate ... readinessGates) {
        if (this.readinessGates != null) {
            this.readinessGates.clear();
        }
        if (readinessGates != null) {
            for (PodReadinessGate item : readinessGates) {
                this.addToReadinessGates(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasReadinessGates() {
        return this.readinessGates != null && !this.readinessGates.isEmpty();
    }

    @Override
    public A addNewReadinessGate(String conditionType) {
        return this.addToReadinessGates(new PodReadinessGate(conditionType));
    }

    @Override
    public PodSpecFluent.ReadinessGatesNested<A> addNewReadinessGate() {
        return new ReadinessGatesNestedImpl();
    }

    @Override
    public PodSpecFluent.ReadinessGatesNested<A> addNewReadinessGateLike(PodReadinessGate item) {
        return new ReadinessGatesNestedImpl(-1, item);
    }

    @Override
    public PodSpecFluent.ReadinessGatesNested<A> setNewReadinessGateLike(Integer index, PodReadinessGate item) {
        return new ReadinessGatesNestedImpl(index, item);
    }

    @Override
    public PodSpecFluent.ReadinessGatesNested<A> editReadinessGate(Integer index) {
        if (this.readinessGates.size() <= index) {
            throw new RuntimeException("Can't edit readinessGates. Index exceeds size.");
        }
        return this.setNewReadinessGateLike(index, this.buildReadinessGate(index));
    }

    @Override
    public PodSpecFluent.ReadinessGatesNested<A> editFirstReadinessGate() {
        if (this.readinessGates.size() == 0) {
            throw new RuntimeException("Can't edit first readinessGates. The list is empty.");
        }
        return this.setNewReadinessGateLike(0, this.buildReadinessGate(0));
    }

    @Override
    public PodSpecFluent.ReadinessGatesNested<A> editLastReadinessGate() {
        int index = this.readinessGates.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last readinessGates. The list is empty.");
        }
        return this.setNewReadinessGateLike(index, this.buildReadinessGate(index));
    }

    @Override
    public PodSpecFluent.ReadinessGatesNested<A> editMatchingReadinessGate(Predicate<PodReadinessGateBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.readinessGates.size(); ++i) {
            if (!predicate.test(this.readinessGates.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching readinessGates. No match found.");
        }
        return this.setNewReadinessGateLike(index, this.buildReadinessGate(index));
    }

    @Override
    public A addToResourceClaims(Integer index, PodResourceClaim item) {
        if (this.resourceClaims == null) {
            this.resourceClaims = new ArrayList();
        }
        PodResourceClaimBuilder builder = new PodResourceClaimBuilder(item);
        this._visitables.get("resourceClaims").add(index >= 0 ? index.intValue() : this._visitables.get("resourceClaims").size(), builder);
        this.resourceClaims.add(index >= 0 ? index.intValue() : this.resourceClaims.size(), builder);
        return (A)this;
    }

    @Override
    public A setToResourceClaims(Integer index, PodResourceClaim item) {
        if (this.resourceClaims == null) {
            this.resourceClaims = new ArrayList();
        }
        PodResourceClaimBuilder builder = new PodResourceClaimBuilder(item);
        if (index < 0 || index >= this._visitables.get("resourceClaims").size()) {
            this._visitables.get("resourceClaims").add(builder);
        } else {
            this._visitables.get("resourceClaims").set(index, builder);
        }
        if (index < 0 || index >= this.resourceClaims.size()) {
            this.resourceClaims.add(builder);
        } else {
            this.resourceClaims.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToResourceClaims(PodResourceClaim ... items) {
        if (this.resourceClaims == null) {
            this.resourceClaims = new ArrayList();
        }
        for (PodResourceClaim item : items) {
            PodResourceClaimBuilder builder = new PodResourceClaimBuilder(item);
            this._visitables.get("resourceClaims").add(builder);
            this.resourceClaims.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToResourceClaims(Collection<PodResourceClaim> items) {
        if (this.resourceClaims == null) {
            this.resourceClaims = new ArrayList();
        }
        for (PodResourceClaim item : items) {
            PodResourceClaimBuilder builder = new PodResourceClaimBuilder(item);
            this._visitables.get("resourceClaims").add(builder);
            this.resourceClaims.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromResourceClaims(PodResourceClaim ... items) {
        for (PodResourceClaim item : items) {
            PodResourceClaimBuilder builder = new PodResourceClaimBuilder(item);
            this._visitables.get("resourceClaims").remove(builder);
            if (this.resourceClaims == null) continue;
            this.resourceClaims.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromResourceClaims(Collection<PodResourceClaim> items) {
        for (PodResourceClaim item : items) {
            PodResourceClaimBuilder builder = new PodResourceClaimBuilder(item);
            this._visitables.get("resourceClaims").remove(builder);
            if (this.resourceClaims == null) continue;
            this.resourceClaims.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromResourceClaims(Predicate<PodResourceClaimBuilder> predicate) {
        if (this.resourceClaims == null) {
            return (A)this;
        }
        Iterator<PodResourceClaimBuilder> each = this.resourceClaims.iterator();
        Object visitables = this._visitables.get("resourceClaims");
        while (each.hasNext()) {
            PodResourceClaimBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<PodResourceClaim> getResourceClaims() {
        return this.resourceClaims != null ? PodSpecFluentImpl.build(this.resourceClaims) : null;
    }

    @Override
    public List<PodResourceClaim> buildResourceClaims() {
        return this.resourceClaims != null ? PodSpecFluentImpl.build(this.resourceClaims) : null;
    }

    @Override
    public PodResourceClaim buildResourceClaim(Integer index) {
        return this.resourceClaims.get(index).build();
    }

    @Override
    public PodResourceClaim buildFirstResourceClaim() {
        return this.resourceClaims.get(0).build();
    }

    @Override
    public PodResourceClaim buildLastResourceClaim() {
        return this.resourceClaims.get(this.resourceClaims.size() - 1).build();
    }

    @Override
    public PodResourceClaim buildMatchingResourceClaim(Predicate<PodResourceClaimBuilder> predicate) {
        for (PodResourceClaimBuilder item : this.resourceClaims) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingResourceClaim(Predicate<PodResourceClaimBuilder> predicate) {
        for (PodResourceClaimBuilder item : this.resourceClaims) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withResourceClaims(List<PodResourceClaim> resourceClaims) {
        if (this.resourceClaims != null) {
            this._visitables.get("resourceClaims").removeAll(this.resourceClaims);
        }
        if (resourceClaims != null) {
            this.resourceClaims = new ArrayList();
            for (PodResourceClaim item : resourceClaims) {
                this.addToResourceClaims(item);
            }
        } else {
            this.resourceClaims = null;
        }
        return (A)this;
    }

    @Override
    public A withResourceClaims(PodResourceClaim ... resourceClaims) {
        if (this.resourceClaims != null) {
            this.resourceClaims.clear();
        }
        if (resourceClaims != null) {
            for (PodResourceClaim item : resourceClaims) {
                this.addToResourceClaims(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasResourceClaims() {
        return this.resourceClaims != null && !this.resourceClaims.isEmpty();
    }

    @Override
    public PodSpecFluent.ResourceClaimsNested<A> addNewResourceClaim() {
        return new ResourceClaimsNestedImpl();
    }

    @Override
    public PodSpecFluent.ResourceClaimsNested<A> addNewResourceClaimLike(PodResourceClaim item) {
        return new ResourceClaimsNestedImpl(-1, item);
    }

    @Override
    public PodSpecFluent.ResourceClaimsNested<A> setNewResourceClaimLike(Integer index, PodResourceClaim item) {
        return new ResourceClaimsNestedImpl(index, item);
    }

    @Override
    public PodSpecFluent.ResourceClaimsNested<A> editResourceClaim(Integer index) {
        if (this.resourceClaims.size() <= index) {
            throw new RuntimeException("Can't edit resourceClaims. Index exceeds size.");
        }
        return this.setNewResourceClaimLike(index, this.buildResourceClaim(index));
    }

    @Override
    public PodSpecFluent.ResourceClaimsNested<A> editFirstResourceClaim() {
        if (this.resourceClaims.size() == 0) {
            throw new RuntimeException("Can't edit first resourceClaims. The list is empty.");
        }
        return this.setNewResourceClaimLike(0, this.buildResourceClaim(0));
    }

    @Override
    public PodSpecFluent.ResourceClaimsNested<A> editLastResourceClaim() {
        int index = this.resourceClaims.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last resourceClaims. The list is empty.");
        }
        return this.setNewResourceClaimLike(index, this.buildResourceClaim(index));
    }

    @Override
    public PodSpecFluent.ResourceClaimsNested<A> editMatchingResourceClaim(Predicate<PodResourceClaimBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.resourceClaims.size(); ++i) {
            if (!predicate.test(this.resourceClaims.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching resourceClaims. No match found.");
        }
        return this.setNewResourceClaimLike(index, this.buildResourceClaim(index));
    }

    @Override
    public String getRestartPolicy() {
        return this.restartPolicy;
    }

    @Override
    public A withRestartPolicy(String restartPolicy) {
        this.restartPolicy = restartPolicy;
        return (A)this;
    }

    @Override
    public Boolean hasRestartPolicy() {
        return this.restartPolicy != null;
    }

    @Override
    public String getRuntimeClassName() {
        return this.runtimeClassName;
    }

    @Override
    public A withRuntimeClassName(String runtimeClassName) {
        this.runtimeClassName = runtimeClassName;
        return (A)this;
    }

    @Override
    public Boolean hasRuntimeClassName() {
        return this.runtimeClassName != null;
    }

    @Override
    public String getSchedulerName() {
        return this.schedulerName;
    }

    @Override
    public A withSchedulerName(String schedulerName) {
        this.schedulerName = schedulerName;
        return (A)this;
    }

    @Override
    public Boolean hasSchedulerName() {
        return this.schedulerName != null;
    }

    @Override
    public A addToSchedulingGates(Integer index, PodSchedulingGate item) {
        if (this.schedulingGates == null) {
            this.schedulingGates = new ArrayList();
        }
        PodSchedulingGateBuilder builder = new PodSchedulingGateBuilder(item);
        this._visitables.get("schedulingGates").add(index >= 0 ? index.intValue() : this._visitables.get("schedulingGates").size(), builder);
        this.schedulingGates.add(index >= 0 ? index.intValue() : this.schedulingGates.size(), builder);
        return (A)this;
    }

    @Override
    public A setToSchedulingGates(Integer index, PodSchedulingGate item) {
        if (this.schedulingGates == null) {
            this.schedulingGates = new ArrayList();
        }
        PodSchedulingGateBuilder builder = new PodSchedulingGateBuilder(item);
        if (index < 0 || index >= this._visitables.get("schedulingGates").size()) {
            this._visitables.get("schedulingGates").add(builder);
        } else {
            this._visitables.get("schedulingGates").set(index, builder);
        }
        if (index < 0 || index >= this.schedulingGates.size()) {
            this.schedulingGates.add(builder);
        } else {
            this.schedulingGates.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToSchedulingGates(PodSchedulingGate ... items) {
        if (this.schedulingGates == null) {
            this.schedulingGates = new ArrayList();
        }
        for (PodSchedulingGate item : items) {
            PodSchedulingGateBuilder builder = new PodSchedulingGateBuilder(item);
            this._visitables.get("schedulingGates").add(builder);
            this.schedulingGates.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToSchedulingGates(Collection<PodSchedulingGate> items) {
        if (this.schedulingGates == null) {
            this.schedulingGates = new ArrayList();
        }
        for (PodSchedulingGate item : items) {
            PodSchedulingGateBuilder builder = new PodSchedulingGateBuilder(item);
            this._visitables.get("schedulingGates").add(builder);
            this.schedulingGates.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromSchedulingGates(PodSchedulingGate ... items) {
        for (PodSchedulingGate item : items) {
            PodSchedulingGateBuilder builder = new PodSchedulingGateBuilder(item);
            this._visitables.get("schedulingGates").remove(builder);
            if (this.schedulingGates == null) continue;
            this.schedulingGates.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromSchedulingGates(Collection<PodSchedulingGate> items) {
        for (PodSchedulingGate item : items) {
            PodSchedulingGateBuilder builder = new PodSchedulingGateBuilder(item);
            this._visitables.get("schedulingGates").remove(builder);
            if (this.schedulingGates == null) continue;
            this.schedulingGates.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromSchedulingGates(Predicate<PodSchedulingGateBuilder> predicate) {
        if (this.schedulingGates == null) {
            return (A)this;
        }
        Iterator<PodSchedulingGateBuilder> each = this.schedulingGates.iterator();
        Object visitables = this._visitables.get("schedulingGates");
        while (each.hasNext()) {
            PodSchedulingGateBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<PodSchedulingGate> getSchedulingGates() {
        return this.schedulingGates != null ? PodSpecFluentImpl.build(this.schedulingGates) : null;
    }

    @Override
    public List<PodSchedulingGate> buildSchedulingGates() {
        return this.schedulingGates != null ? PodSpecFluentImpl.build(this.schedulingGates) : null;
    }

    @Override
    public PodSchedulingGate buildSchedulingGate(Integer index) {
        return this.schedulingGates.get(index).build();
    }

    @Override
    public PodSchedulingGate buildFirstSchedulingGate() {
        return this.schedulingGates.get(0).build();
    }

    @Override
    public PodSchedulingGate buildLastSchedulingGate() {
        return this.schedulingGates.get(this.schedulingGates.size() - 1).build();
    }

    @Override
    public PodSchedulingGate buildMatchingSchedulingGate(Predicate<PodSchedulingGateBuilder> predicate) {
        for (PodSchedulingGateBuilder item : this.schedulingGates) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingSchedulingGate(Predicate<PodSchedulingGateBuilder> predicate) {
        for (PodSchedulingGateBuilder item : this.schedulingGates) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withSchedulingGates(List<PodSchedulingGate> schedulingGates) {
        if (this.schedulingGates != null) {
            this._visitables.get("schedulingGates").removeAll(this.schedulingGates);
        }
        if (schedulingGates != null) {
            this.schedulingGates = new ArrayList();
            for (PodSchedulingGate item : schedulingGates) {
                this.addToSchedulingGates(item);
            }
        } else {
            this.schedulingGates = null;
        }
        return (A)this;
    }

    @Override
    public A withSchedulingGates(PodSchedulingGate ... schedulingGates) {
        if (this.schedulingGates != null) {
            this.schedulingGates.clear();
        }
        if (schedulingGates != null) {
            for (PodSchedulingGate item : schedulingGates) {
                this.addToSchedulingGates(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasSchedulingGates() {
        return this.schedulingGates != null && !this.schedulingGates.isEmpty();
    }

    @Override
    public A addNewSchedulingGate(String name) {
        return this.addToSchedulingGates(new PodSchedulingGate(name));
    }

    @Override
    public PodSpecFluent.SchedulingGatesNested<A> addNewSchedulingGate() {
        return new SchedulingGatesNestedImpl();
    }

    @Override
    public PodSpecFluent.SchedulingGatesNested<A> addNewSchedulingGateLike(PodSchedulingGate item) {
        return new SchedulingGatesNestedImpl(-1, item);
    }

    @Override
    public PodSpecFluent.SchedulingGatesNested<A> setNewSchedulingGateLike(Integer index, PodSchedulingGate item) {
        return new SchedulingGatesNestedImpl(index, item);
    }

    @Override
    public PodSpecFluent.SchedulingGatesNested<A> editSchedulingGate(Integer index) {
        if (this.schedulingGates.size() <= index) {
            throw new RuntimeException("Can't edit schedulingGates. Index exceeds size.");
        }
        return this.setNewSchedulingGateLike(index, this.buildSchedulingGate(index));
    }

    @Override
    public PodSpecFluent.SchedulingGatesNested<A> editFirstSchedulingGate() {
        if (this.schedulingGates.size() == 0) {
            throw new RuntimeException("Can't edit first schedulingGates. The list is empty.");
        }
        return this.setNewSchedulingGateLike(0, this.buildSchedulingGate(0));
    }

    @Override
    public PodSpecFluent.SchedulingGatesNested<A> editLastSchedulingGate() {
        int index = this.schedulingGates.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last schedulingGates. The list is empty.");
        }
        return this.setNewSchedulingGateLike(index, this.buildSchedulingGate(index));
    }

    @Override
    public PodSpecFluent.SchedulingGatesNested<A> editMatchingSchedulingGate(Predicate<PodSchedulingGateBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.schedulingGates.size(); ++i) {
            if (!predicate.test(this.schedulingGates.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching schedulingGates. No match found.");
        }
        return this.setNewSchedulingGateLike(index, this.buildSchedulingGate(index));
    }

    @Override
    @Deprecated
    public PodSecurityContext getSecurityContext() {
        return this.securityContext != null ? this.securityContext.build() : null;
    }

    @Override
    public PodSecurityContext buildSecurityContext() {
        return this.securityContext != null ? this.securityContext.build() : null;
    }

    @Override
    public A withSecurityContext(PodSecurityContext securityContext) {
        this._visitables.get("securityContext").remove(this.securityContext);
        if (securityContext != null) {
            this.securityContext = new PodSecurityContextBuilder(securityContext);
            this._visitables.get("securityContext").add(this.securityContext);
        } else {
            this.securityContext = null;
            this._visitables.get("securityContext").remove(this.securityContext);
        }
        return (A)this;
    }

    @Override
    public Boolean hasSecurityContext() {
        return this.securityContext != null;
    }

    @Override
    public PodSpecFluent.SecurityContextNested<A> withNewSecurityContext() {
        return new SecurityContextNestedImpl();
    }

    @Override
    public PodSpecFluent.SecurityContextNested<A> withNewSecurityContextLike(PodSecurityContext item) {
        return new SecurityContextNestedImpl(item);
    }

    @Override
    public PodSpecFluent.SecurityContextNested<A> editSecurityContext() {
        return this.withNewSecurityContextLike(this.getSecurityContext());
    }

    @Override
    public PodSpecFluent.SecurityContextNested<A> editOrNewSecurityContext() {
        return this.withNewSecurityContextLike(this.getSecurityContext() != null ? this.getSecurityContext() : new PodSecurityContextBuilder().build());
    }

    @Override
    public PodSpecFluent.SecurityContextNested<A> editOrNewSecurityContextLike(PodSecurityContext item) {
        return this.withNewSecurityContextLike(this.getSecurityContext() != null ? this.getSecurityContext() : item);
    }

    @Override
    public String getServiceAccount() {
        return this.serviceAccount;
    }

    @Override
    public A withServiceAccount(String serviceAccount) {
        this.serviceAccount = serviceAccount;
        return (A)this;
    }

    @Override
    public Boolean hasServiceAccount() {
        return this.serviceAccount != null;
    }

    @Override
    public String getServiceAccountName() {
        return this.serviceAccountName;
    }

    @Override
    public A withServiceAccountName(String serviceAccountName) {
        this.serviceAccountName = serviceAccountName;
        return (A)this;
    }

    @Override
    public Boolean hasServiceAccountName() {
        return this.serviceAccountName != null;
    }

    @Override
    public Boolean getSetHostnameAsFQDN() {
        return this.setHostnameAsFQDN;
    }

    @Override
    public A withSetHostnameAsFQDN(Boolean setHostnameAsFQDN) {
        this.setHostnameAsFQDN = setHostnameAsFQDN;
        return (A)this;
    }

    @Override
    public Boolean hasSetHostnameAsFQDN() {
        return this.setHostnameAsFQDN != null;
    }

    @Override
    public Boolean getShareProcessNamespace() {
        return this.shareProcessNamespace;
    }

    @Override
    public A withShareProcessNamespace(Boolean shareProcessNamespace) {
        this.shareProcessNamespace = shareProcessNamespace;
        return (A)this;
    }

    @Override
    public Boolean hasShareProcessNamespace() {
        return this.shareProcessNamespace != null;
    }

    @Override
    public String getSubdomain() {
        return this.subdomain;
    }

    @Override
    public A withSubdomain(String subdomain) {
        this.subdomain = subdomain;
        return (A)this;
    }

    @Override
    public Boolean hasSubdomain() {
        return this.subdomain != null;
    }

    @Override
    public Long getTerminationGracePeriodSeconds() {
        return this.terminationGracePeriodSeconds;
    }

    @Override
    public A withTerminationGracePeriodSeconds(Long terminationGracePeriodSeconds) {
        this.terminationGracePeriodSeconds = terminationGracePeriodSeconds;
        return (A)this;
    }

    @Override
    public Boolean hasTerminationGracePeriodSeconds() {
        return this.terminationGracePeriodSeconds != null;
    }

    @Override
    public A addToTolerations(Integer index, Toleration item) {
        if (this.tolerations == null) {
            this.tolerations = new ArrayList();
        }
        TolerationBuilder builder = new TolerationBuilder(item);
        this._visitables.get("tolerations").add(index >= 0 ? index.intValue() : this._visitables.get("tolerations").size(), builder);
        this.tolerations.add(index >= 0 ? index.intValue() : this.tolerations.size(), builder);
        return (A)this;
    }

    @Override
    public A setToTolerations(Integer index, Toleration item) {
        if (this.tolerations == null) {
            this.tolerations = new ArrayList();
        }
        TolerationBuilder builder = new TolerationBuilder(item);
        if (index < 0 || index >= this._visitables.get("tolerations").size()) {
            this._visitables.get("tolerations").add(builder);
        } else {
            this._visitables.get("tolerations").set(index, builder);
        }
        if (index < 0 || index >= this.tolerations.size()) {
            this.tolerations.add(builder);
        } else {
            this.tolerations.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToTolerations(Toleration ... items) {
        if (this.tolerations == null) {
            this.tolerations = new ArrayList();
        }
        for (Toleration item : items) {
            TolerationBuilder builder = new TolerationBuilder(item);
            this._visitables.get("tolerations").add(builder);
            this.tolerations.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToTolerations(Collection<Toleration> items) {
        if (this.tolerations == null) {
            this.tolerations = new ArrayList();
        }
        for (Toleration item : items) {
            TolerationBuilder builder = new TolerationBuilder(item);
            this._visitables.get("tolerations").add(builder);
            this.tolerations.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromTolerations(Toleration ... items) {
        for (Toleration item : items) {
            TolerationBuilder builder = new TolerationBuilder(item);
            this._visitables.get("tolerations").remove(builder);
            if (this.tolerations == null) continue;
            this.tolerations.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromTolerations(Collection<Toleration> items) {
        for (Toleration item : items) {
            TolerationBuilder builder = new TolerationBuilder(item);
            this._visitables.get("tolerations").remove(builder);
            if (this.tolerations == null) continue;
            this.tolerations.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromTolerations(Predicate<TolerationBuilder> predicate) {
        if (this.tolerations == null) {
            return (A)this;
        }
        Iterator<TolerationBuilder> each = this.tolerations.iterator();
        Object visitables = this._visitables.get("tolerations");
        while (each.hasNext()) {
            TolerationBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<Toleration> getTolerations() {
        return this.tolerations != null ? PodSpecFluentImpl.build(this.tolerations) : null;
    }

    @Override
    public List<Toleration> buildTolerations() {
        return this.tolerations != null ? PodSpecFluentImpl.build(this.tolerations) : null;
    }

    @Override
    public Toleration buildToleration(Integer index) {
        return this.tolerations.get(index).build();
    }

    @Override
    public Toleration buildFirstToleration() {
        return this.tolerations.get(0).build();
    }

    @Override
    public Toleration buildLastToleration() {
        return this.tolerations.get(this.tolerations.size() - 1).build();
    }

    @Override
    public Toleration buildMatchingToleration(Predicate<TolerationBuilder> predicate) {
        for (TolerationBuilder item : this.tolerations) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingToleration(Predicate<TolerationBuilder> predicate) {
        for (TolerationBuilder item : this.tolerations) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withTolerations(List<Toleration> tolerations) {
        if (this.tolerations != null) {
            this._visitables.get("tolerations").removeAll(this.tolerations);
        }
        if (tolerations != null) {
            this.tolerations = new ArrayList();
            for (Toleration item : tolerations) {
                this.addToTolerations(item);
            }
        } else {
            this.tolerations = null;
        }
        return (A)this;
    }

    @Override
    public A withTolerations(Toleration ... tolerations) {
        if (this.tolerations != null) {
            this.tolerations.clear();
        }
        if (tolerations != null) {
            for (Toleration item : tolerations) {
                this.addToTolerations(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasTolerations() {
        return this.tolerations != null && !this.tolerations.isEmpty();
    }

    @Override
    public A addNewToleration(String effect, String key, String operator, Long tolerationSeconds, String value) {
        return this.addToTolerations(new Toleration(effect, key, operator, tolerationSeconds, value));
    }

    @Override
    public PodSpecFluent.TolerationsNested<A> addNewToleration() {
        return new TolerationsNestedImpl();
    }

    @Override
    public PodSpecFluent.TolerationsNested<A> addNewTolerationLike(Toleration item) {
        return new TolerationsNestedImpl(-1, item);
    }

    @Override
    public PodSpecFluent.TolerationsNested<A> setNewTolerationLike(Integer index, Toleration item) {
        return new TolerationsNestedImpl(index, item);
    }

    @Override
    public PodSpecFluent.TolerationsNested<A> editToleration(Integer index) {
        if (this.tolerations.size() <= index) {
            throw new RuntimeException("Can't edit tolerations. Index exceeds size.");
        }
        return this.setNewTolerationLike(index, this.buildToleration(index));
    }

    @Override
    public PodSpecFluent.TolerationsNested<A> editFirstToleration() {
        if (this.tolerations.size() == 0) {
            throw new RuntimeException("Can't edit first tolerations. The list is empty.");
        }
        return this.setNewTolerationLike(0, this.buildToleration(0));
    }

    @Override
    public PodSpecFluent.TolerationsNested<A> editLastToleration() {
        int index = this.tolerations.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last tolerations. The list is empty.");
        }
        return this.setNewTolerationLike(index, this.buildToleration(index));
    }

    @Override
    public PodSpecFluent.TolerationsNested<A> editMatchingToleration(Predicate<TolerationBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.tolerations.size(); ++i) {
            if (!predicate.test(this.tolerations.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching tolerations. No match found.");
        }
        return this.setNewTolerationLike(index, this.buildToleration(index));
    }

    @Override
    public A addToTopologySpreadConstraints(Integer index, TopologySpreadConstraint item) {
        if (this.topologySpreadConstraints == null) {
            this.topologySpreadConstraints = new ArrayList();
        }
        TopologySpreadConstraintBuilder builder = new TopologySpreadConstraintBuilder(item);
        this._visitables.get("topologySpreadConstraints").add(index >= 0 ? index.intValue() : this._visitables.get("topologySpreadConstraints").size(), builder);
        this.topologySpreadConstraints.add(index >= 0 ? index.intValue() : this.topologySpreadConstraints.size(), builder);
        return (A)this;
    }

    @Override
    public A setToTopologySpreadConstraints(Integer index, TopologySpreadConstraint item) {
        if (this.topologySpreadConstraints == null) {
            this.topologySpreadConstraints = new ArrayList();
        }
        TopologySpreadConstraintBuilder builder = new TopologySpreadConstraintBuilder(item);
        if (index < 0 || index >= this._visitables.get("topologySpreadConstraints").size()) {
            this._visitables.get("topologySpreadConstraints").add(builder);
        } else {
            this._visitables.get("topologySpreadConstraints").set(index, builder);
        }
        if (index < 0 || index >= this.topologySpreadConstraints.size()) {
            this.topologySpreadConstraints.add(builder);
        } else {
            this.topologySpreadConstraints.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToTopologySpreadConstraints(TopologySpreadConstraint ... items) {
        if (this.topologySpreadConstraints == null) {
            this.topologySpreadConstraints = new ArrayList();
        }
        for (TopologySpreadConstraint item : items) {
            TopologySpreadConstraintBuilder builder = new TopologySpreadConstraintBuilder(item);
            this._visitables.get("topologySpreadConstraints").add(builder);
            this.topologySpreadConstraints.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToTopologySpreadConstraints(Collection<TopologySpreadConstraint> items) {
        if (this.topologySpreadConstraints == null) {
            this.topologySpreadConstraints = new ArrayList();
        }
        for (TopologySpreadConstraint item : items) {
            TopologySpreadConstraintBuilder builder = new TopologySpreadConstraintBuilder(item);
            this._visitables.get("topologySpreadConstraints").add(builder);
            this.topologySpreadConstraints.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromTopologySpreadConstraints(TopologySpreadConstraint ... items) {
        for (TopologySpreadConstraint item : items) {
            TopologySpreadConstraintBuilder builder = new TopologySpreadConstraintBuilder(item);
            this._visitables.get("topologySpreadConstraints").remove(builder);
            if (this.topologySpreadConstraints == null) continue;
            this.topologySpreadConstraints.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromTopologySpreadConstraints(Collection<TopologySpreadConstraint> items) {
        for (TopologySpreadConstraint item : items) {
            TopologySpreadConstraintBuilder builder = new TopologySpreadConstraintBuilder(item);
            this._visitables.get("topologySpreadConstraints").remove(builder);
            if (this.topologySpreadConstraints == null) continue;
            this.topologySpreadConstraints.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromTopologySpreadConstraints(Predicate<TopologySpreadConstraintBuilder> predicate) {
        if (this.topologySpreadConstraints == null) {
            return (A)this;
        }
        Iterator<TopologySpreadConstraintBuilder> each = this.topologySpreadConstraints.iterator();
        Object visitables = this._visitables.get("topologySpreadConstraints");
        while (each.hasNext()) {
            TopologySpreadConstraintBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<TopologySpreadConstraint> getTopologySpreadConstraints() {
        return this.topologySpreadConstraints != null ? PodSpecFluentImpl.build(this.topologySpreadConstraints) : null;
    }

    @Override
    public List<TopologySpreadConstraint> buildTopologySpreadConstraints() {
        return this.topologySpreadConstraints != null ? PodSpecFluentImpl.build(this.topologySpreadConstraints) : null;
    }

    @Override
    public TopologySpreadConstraint buildTopologySpreadConstraint(Integer index) {
        return this.topologySpreadConstraints.get(index).build();
    }

    @Override
    public TopologySpreadConstraint buildFirstTopologySpreadConstraint() {
        return this.topologySpreadConstraints.get(0).build();
    }

    @Override
    public TopologySpreadConstraint buildLastTopologySpreadConstraint() {
        return this.topologySpreadConstraints.get(this.topologySpreadConstraints.size() - 1).build();
    }

    @Override
    public TopologySpreadConstraint buildMatchingTopologySpreadConstraint(Predicate<TopologySpreadConstraintBuilder> predicate) {
        for (TopologySpreadConstraintBuilder item : this.topologySpreadConstraints) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingTopologySpreadConstraint(Predicate<TopologySpreadConstraintBuilder> predicate) {
        for (TopologySpreadConstraintBuilder item : this.topologySpreadConstraints) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withTopologySpreadConstraints(List<TopologySpreadConstraint> topologySpreadConstraints) {
        if (this.topologySpreadConstraints != null) {
            this._visitables.get("topologySpreadConstraints").removeAll(this.topologySpreadConstraints);
        }
        if (topologySpreadConstraints != null) {
            this.topologySpreadConstraints = new ArrayList();
            for (TopologySpreadConstraint item : topologySpreadConstraints) {
                this.addToTopologySpreadConstraints(item);
            }
        } else {
            this.topologySpreadConstraints = null;
        }
        return (A)this;
    }

    @Override
    public A withTopologySpreadConstraints(TopologySpreadConstraint ... topologySpreadConstraints) {
        if (this.topologySpreadConstraints != null) {
            this.topologySpreadConstraints.clear();
        }
        if (topologySpreadConstraints != null) {
            for (TopologySpreadConstraint item : topologySpreadConstraints) {
                this.addToTopologySpreadConstraints(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasTopologySpreadConstraints() {
        return this.topologySpreadConstraints != null && !this.topologySpreadConstraints.isEmpty();
    }

    @Override
    public PodSpecFluent.TopologySpreadConstraintsNested<A> addNewTopologySpreadConstraint() {
        return new TopologySpreadConstraintsNestedImpl();
    }

    @Override
    public PodSpecFluent.TopologySpreadConstraintsNested<A> addNewTopologySpreadConstraintLike(TopologySpreadConstraint item) {
        return new TopologySpreadConstraintsNestedImpl(-1, item);
    }

    @Override
    public PodSpecFluent.TopologySpreadConstraintsNested<A> setNewTopologySpreadConstraintLike(Integer index, TopologySpreadConstraint item) {
        return new TopologySpreadConstraintsNestedImpl(index, item);
    }

    @Override
    public PodSpecFluent.TopologySpreadConstraintsNested<A> editTopologySpreadConstraint(Integer index) {
        if (this.topologySpreadConstraints.size() <= index) {
            throw new RuntimeException("Can't edit topologySpreadConstraints. Index exceeds size.");
        }
        return this.setNewTopologySpreadConstraintLike(index, this.buildTopologySpreadConstraint(index));
    }

    @Override
    public PodSpecFluent.TopologySpreadConstraintsNested<A> editFirstTopologySpreadConstraint() {
        if (this.topologySpreadConstraints.size() == 0) {
            throw new RuntimeException("Can't edit first topologySpreadConstraints. The list is empty.");
        }
        return this.setNewTopologySpreadConstraintLike(0, this.buildTopologySpreadConstraint(0));
    }

    @Override
    public PodSpecFluent.TopologySpreadConstraintsNested<A> editLastTopologySpreadConstraint() {
        int index = this.topologySpreadConstraints.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last topologySpreadConstraints. The list is empty.");
        }
        return this.setNewTopologySpreadConstraintLike(index, this.buildTopologySpreadConstraint(index));
    }

    @Override
    public PodSpecFluent.TopologySpreadConstraintsNested<A> editMatchingTopologySpreadConstraint(Predicate<TopologySpreadConstraintBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.topologySpreadConstraints.size(); ++i) {
            if (!predicate.test(this.topologySpreadConstraints.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching topologySpreadConstraints. No match found.");
        }
        return this.setNewTopologySpreadConstraintLike(index, this.buildTopologySpreadConstraint(index));
    }

    @Override
    public A addToVolumes(Integer index, Volume item) {
        if (this.volumes == null) {
            this.volumes = new ArrayList();
        }
        VolumeBuilder builder = new VolumeBuilder(item);
        this._visitables.get("volumes").add(index >= 0 ? index.intValue() : this._visitables.get("volumes").size(), builder);
        this.volumes.add(index >= 0 ? index.intValue() : this.volumes.size(), builder);
        return (A)this;
    }

    @Override
    public A setToVolumes(Integer index, Volume item) {
        if (this.volumes == null) {
            this.volumes = new ArrayList();
        }
        VolumeBuilder builder = new VolumeBuilder(item);
        if (index < 0 || index >= this._visitables.get("volumes").size()) {
            this._visitables.get("volumes").add(builder);
        } else {
            this._visitables.get("volumes").set(index, builder);
        }
        if (index < 0 || index >= this.volumes.size()) {
            this.volumes.add(builder);
        } else {
            this.volumes.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToVolumes(Volume ... items) {
        if (this.volumes == null) {
            this.volumes = new ArrayList();
        }
        for (Volume item : items) {
            VolumeBuilder builder = new VolumeBuilder(item);
            this._visitables.get("volumes").add(builder);
            this.volumes.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToVolumes(Collection<Volume> items) {
        if (this.volumes == null) {
            this.volumes = new ArrayList();
        }
        for (Volume item : items) {
            VolumeBuilder builder = new VolumeBuilder(item);
            this._visitables.get("volumes").add(builder);
            this.volumes.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromVolumes(Volume ... items) {
        for (Volume item : items) {
            VolumeBuilder builder = new VolumeBuilder(item);
            this._visitables.get("volumes").remove(builder);
            if (this.volumes == null) continue;
            this.volumes.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromVolumes(Collection<Volume> items) {
        for (Volume item : items) {
            VolumeBuilder builder = new VolumeBuilder(item);
            this._visitables.get("volumes").remove(builder);
            if (this.volumes == null) continue;
            this.volumes.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromVolumes(Predicate<VolumeBuilder> predicate) {
        if (this.volumes == null) {
            return (A)this;
        }
        Iterator<VolumeBuilder> each = this.volumes.iterator();
        Object visitables = this._visitables.get("volumes");
        while (each.hasNext()) {
            VolumeBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<Volume> getVolumes() {
        return this.volumes != null ? PodSpecFluentImpl.build(this.volumes) : null;
    }

    @Override
    public List<Volume> buildVolumes() {
        return this.volumes != null ? PodSpecFluentImpl.build(this.volumes) : null;
    }

    @Override
    public Volume buildVolume(Integer index) {
        return this.volumes.get(index).build();
    }

    @Override
    public Volume buildFirstVolume() {
        return this.volumes.get(0).build();
    }

    @Override
    public Volume buildLastVolume() {
        return this.volumes.get(this.volumes.size() - 1).build();
    }

    @Override
    public Volume buildMatchingVolume(Predicate<VolumeBuilder> predicate) {
        for (VolumeBuilder item : this.volumes) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingVolume(Predicate<VolumeBuilder> predicate) {
        for (VolumeBuilder item : this.volumes) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withVolumes(List<Volume> volumes) {
        if (this.volumes != null) {
            this._visitables.get("volumes").removeAll(this.volumes);
        }
        if (volumes != null) {
            this.volumes = new ArrayList();
            for (Volume item : volumes) {
                this.addToVolumes(item);
            }
        } else {
            this.volumes = null;
        }
        return (A)this;
    }

    @Override
    public A withVolumes(Volume ... volumes) {
        if (this.volumes != null) {
            this.volumes.clear();
        }
        if (volumes != null) {
            for (Volume item : volumes) {
                this.addToVolumes(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasVolumes() {
        return this.volumes != null && !this.volumes.isEmpty();
    }

    @Override
    public PodSpecFluent.VolumesNested<A> addNewVolume() {
        return new VolumesNestedImpl();
    }

    @Override
    public PodSpecFluent.VolumesNested<A> addNewVolumeLike(Volume item) {
        return new VolumesNestedImpl(-1, item);
    }

    @Override
    public PodSpecFluent.VolumesNested<A> setNewVolumeLike(Integer index, Volume item) {
        return new VolumesNestedImpl(index, item);
    }

    @Override
    public PodSpecFluent.VolumesNested<A> editVolume(Integer index) {
        if (this.volumes.size() <= index) {
            throw new RuntimeException("Can't edit volumes. Index exceeds size.");
        }
        return this.setNewVolumeLike(index, this.buildVolume(index));
    }

    @Override
    public PodSpecFluent.VolumesNested<A> editFirstVolume() {
        if (this.volumes.size() == 0) {
            throw new RuntimeException("Can't edit first volumes. The list is empty.");
        }
        return this.setNewVolumeLike(0, this.buildVolume(0));
    }

    @Override
    public PodSpecFluent.VolumesNested<A> editLastVolume() {
        int index = this.volumes.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last volumes. The list is empty.");
        }
        return this.setNewVolumeLike(index, this.buildVolume(index));
    }

    @Override
    public PodSpecFluent.VolumesNested<A> editMatchingVolume(Predicate<VolumeBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.volumes.size(); ++i) {
            if (!predicate.test(this.volumes.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching volumes. No match found.");
        }
        return this.setNewVolumeLike(index, this.buildVolume(index));
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PodSpecFluentImpl that = (PodSpecFluentImpl)o;
        if (this.activeDeadlineSeconds != null ? !this.activeDeadlineSeconds.equals(that.activeDeadlineSeconds) : that.activeDeadlineSeconds != null) {
            return false;
        }
        if (this.affinity != null ? !this.affinity.equals(that.affinity) : that.affinity != null) {
            return false;
        }
        if (this.automountServiceAccountToken != null ? !this.automountServiceAccountToken.equals(that.automountServiceAccountToken) : that.automountServiceAccountToken != null) {
            return false;
        }
        if (this.containers != null ? !this.containers.equals(that.containers) : that.containers != null) {
            return false;
        }
        if (this.dnsConfig != null ? !this.dnsConfig.equals(that.dnsConfig) : that.dnsConfig != null) {
            return false;
        }
        if (this.dnsPolicy != null ? !this.dnsPolicy.equals(that.dnsPolicy) : that.dnsPolicy != null) {
            return false;
        }
        if (this.enableServiceLinks != null ? !this.enableServiceLinks.equals(that.enableServiceLinks) : that.enableServiceLinks != null) {
            return false;
        }
        if (this.ephemeralContainers != null ? !this.ephemeralContainers.equals(that.ephemeralContainers) : that.ephemeralContainers != null) {
            return false;
        }
        if (this.hostAliases != null ? !this.hostAliases.equals(that.hostAliases) : that.hostAliases != null) {
            return false;
        }
        if (this.hostIPC != null ? !this.hostIPC.equals(that.hostIPC) : that.hostIPC != null) {
            return false;
        }
        if (this.hostNetwork != null ? !this.hostNetwork.equals(that.hostNetwork) : that.hostNetwork != null) {
            return false;
        }
        if (this.hostPID != null ? !this.hostPID.equals(that.hostPID) : that.hostPID != null) {
            return false;
        }
        if (this.hostUsers != null ? !this.hostUsers.equals(that.hostUsers) : that.hostUsers != null) {
            return false;
        }
        if (this.hostname != null ? !this.hostname.equals(that.hostname) : that.hostname != null) {
            return false;
        }
        if (this.imagePullSecrets != null ? !this.imagePullSecrets.equals(that.imagePullSecrets) : that.imagePullSecrets != null) {
            return false;
        }
        if (this.initContainers != null ? !this.initContainers.equals(that.initContainers) : that.initContainers != null) {
            return false;
        }
        if (this.nodeName != null ? !this.nodeName.equals(that.nodeName) : that.nodeName != null) {
            return false;
        }
        if (this.nodeSelector != null ? !this.nodeSelector.equals(that.nodeSelector) : that.nodeSelector != null) {
            return false;
        }
        if (this.os != null ? !this.os.equals(that.os) : that.os != null) {
            return false;
        }
        if (this.overhead != null ? !this.overhead.equals(that.overhead) : that.overhead != null) {
            return false;
        }
        if (this.preemptionPolicy != null ? !this.preemptionPolicy.equals(that.preemptionPolicy) : that.preemptionPolicy != null) {
            return false;
        }
        if (this.priority != null ? !this.priority.equals(that.priority) : that.priority != null) {
            return false;
        }
        if (this.priorityClassName != null ? !this.priorityClassName.equals(that.priorityClassName) : that.priorityClassName != null) {
            return false;
        }
        if (this.readinessGates != null ? !this.readinessGates.equals(that.readinessGates) : that.readinessGates != null) {
            return false;
        }
        if (this.resourceClaims != null ? !this.resourceClaims.equals(that.resourceClaims) : that.resourceClaims != null) {
            return false;
        }
        if (this.restartPolicy != null ? !this.restartPolicy.equals(that.restartPolicy) : that.restartPolicy != null) {
            return false;
        }
        if (this.runtimeClassName != null ? !this.runtimeClassName.equals(that.runtimeClassName) : that.runtimeClassName != null) {
            return false;
        }
        if (this.schedulerName != null ? !this.schedulerName.equals(that.schedulerName) : that.schedulerName != null) {
            return false;
        }
        if (this.schedulingGates != null ? !this.schedulingGates.equals(that.schedulingGates) : that.schedulingGates != null) {
            return false;
        }
        if (this.securityContext != null ? !this.securityContext.equals(that.securityContext) : that.securityContext != null) {
            return false;
        }
        if (this.serviceAccount != null ? !this.serviceAccount.equals(that.serviceAccount) : that.serviceAccount != null) {
            return false;
        }
        if (this.serviceAccountName != null ? !this.serviceAccountName.equals(that.serviceAccountName) : that.serviceAccountName != null) {
            return false;
        }
        if (this.setHostnameAsFQDN != null ? !this.setHostnameAsFQDN.equals(that.setHostnameAsFQDN) : that.setHostnameAsFQDN != null) {
            return false;
        }
        if (this.shareProcessNamespace != null ? !this.shareProcessNamespace.equals(that.shareProcessNamespace) : that.shareProcessNamespace != null) {
            return false;
        }
        if (this.subdomain != null ? !this.subdomain.equals(that.subdomain) : that.subdomain != null) {
            return false;
        }
        if (this.terminationGracePeriodSeconds != null ? !this.terminationGracePeriodSeconds.equals(that.terminationGracePeriodSeconds) : that.terminationGracePeriodSeconds != null) {
            return false;
        }
        if (this.tolerations != null ? !this.tolerations.equals(that.tolerations) : that.tolerations != null) {
            return false;
        }
        if (this.topologySpreadConstraints != null ? !this.topologySpreadConstraints.equals(that.topologySpreadConstraints) : that.topologySpreadConstraints != null) {
            return false;
        }
        if (this.volumes != null ? !this.volumes.equals(that.volumes) : that.volumes != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.activeDeadlineSeconds, this.affinity, this.automountServiceAccountToken, this.containers, this.dnsConfig, this.dnsPolicy, this.enableServiceLinks, this.ephemeralContainers, this.hostAliases, this.hostIPC, this.hostNetwork, this.hostPID, this.hostUsers, this.hostname, this.imagePullSecrets, this.initContainers, this.nodeName, this.nodeSelector, this.os, this.overhead, this.preemptionPolicy, this.priority, this.priorityClassName, this.readinessGates, this.resourceClaims, this.restartPolicy, this.runtimeClassName, this.schedulerName, this.schedulingGates, this.securityContext, this.serviceAccount, this.serviceAccountName, this.setHostnameAsFQDN, this.shareProcessNamespace, this.subdomain, this.terminationGracePeriodSeconds, this.tolerations, this.topologySpreadConstraints, this.volumes, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.activeDeadlineSeconds != null) {
            sb.append("activeDeadlineSeconds:");
            sb.append(this.activeDeadlineSeconds + ",");
        }
        if (this.affinity != null) {
            sb.append("affinity:");
            sb.append(this.affinity + ",");
        }
        if (this.automountServiceAccountToken != null) {
            sb.append("automountServiceAccountToken:");
            sb.append(this.automountServiceAccountToken + ",");
        }
        if (this.containers != null && !this.containers.isEmpty()) {
            sb.append("containers:");
            sb.append(this.containers + ",");
        }
        if (this.dnsConfig != null) {
            sb.append("dnsConfig:");
            sb.append(this.dnsConfig + ",");
        }
        if (this.dnsPolicy != null) {
            sb.append("dnsPolicy:");
            sb.append(this.dnsPolicy + ",");
        }
        if (this.enableServiceLinks != null) {
            sb.append("enableServiceLinks:");
            sb.append(this.enableServiceLinks + ",");
        }
        if (this.ephemeralContainers != null && !this.ephemeralContainers.isEmpty()) {
            sb.append("ephemeralContainers:");
            sb.append(this.ephemeralContainers + ",");
        }
        if (this.hostAliases != null && !this.hostAliases.isEmpty()) {
            sb.append("hostAliases:");
            sb.append(this.hostAliases + ",");
        }
        if (this.hostIPC != null) {
            sb.append("hostIPC:");
            sb.append(this.hostIPC + ",");
        }
        if (this.hostNetwork != null) {
            sb.append("hostNetwork:");
            sb.append(this.hostNetwork + ",");
        }
        if (this.hostPID != null) {
            sb.append("hostPID:");
            sb.append(this.hostPID + ",");
        }
        if (this.hostUsers != null) {
            sb.append("hostUsers:");
            sb.append(this.hostUsers + ",");
        }
        if (this.hostname != null) {
            sb.append("hostname:");
            sb.append(this.hostname + ",");
        }
        if (this.imagePullSecrets != null && !this.imagePullSecrets.isEmpty()) {
            sb.append("imagePullSecrets:");
            sb.append(this.imagePullSecrets + ",");
        }
        if (this.initContainers != null && !this.initContainers.isEmpty()) {
            sb.append("initContainers:");
            sb.append(this.initContainers + ",");
        }
        if (this.nodeName != null) {
            sb.append("nodeName:");
            sb.append(this.nodeName + ",");
        }
        if (this.nodeSelector != null && !this.nodeSelector.isEmpty()) {
            sb.append("nodeSelector:");
            sb.append(this.nodeSelector + ",");
        }
        if (this.os != null) {
            sb.append("os:");
            sb.append(this.os + ",");
        }
        if (this.overhead != null && !this.overhead.isEmpty()) {
            sb.append("overhead:");
            sb.append(this.overhead + ",");
        }
        if (this.preemptionPolicy != null) {
            sb.append("preemptionPolicy:");
            sb.append(this.preemptionPolicy + ",");
        }
        if (this.priority != null) {
            sb.append("priority:");
            sb.append(this.priority + ",");
        }
        if (this.priorityClassName != null) {
            sb.append("priorityClassName:");
            sb.append(this.priorityClassName + ",");
        }
        if (this.readinessGates != null && !this.readinessGates.isEmpty()) {
            sb.append("readinessGates:");
            sb.append(this.readinessGates + ",");
        }
        if (this.resourceClaims != null && !this.resourceClaims.isEmpty()) {
            sb.append("resourceClaims:");
            sb.append(this.resourceClaims + ",");
        }
        if (this.restartPolicy != null) {
            sb.append("restartPolicy:");
            sb.append(this.restartPolicy + ",");
        }
        if (this.runtimeClassName != null) {
            sb.append("runtimeClassName:");
            sb.append(this.runtimeClassName + ",");
        }
        if (this.schedulerName != null) {
            sb.append("schedulerName:");
            sb.append(this.schedulerName + ",");
        }
        if (this.schedulingGates != null && !this.schedulingGates.isEmpty()) {
            sb.append("schedulingGates:");
            sb.append(this.schedulingGates + ",");
        }
        if (this.securityContext != null) {
            sb.append("securityContext:");
            sb.append(this.securityContext + ",");
        }
        if (this.serviceAccount != null) {
            sb.append("serviceAccount:");
            sb.append(this.serviceAccount + ",");
        }
        if (this.serviceAccountName != null) {
            sb.append("serviceAccountName:");
            sb.append(this.serviceAccountName + ",");
        }
        if (this.setHostnameAsFQDN != null) {
            sb.append("setHostnameAsFQDN:");
            sb.append(this.setHostnameAsFQDN + ",");
        }
        if (this.shareProcessNamespace != null) {
            sb.append("shareProcessNamespace:");
            sb.append(this.shareProcessNamespace + ",");
        }
        if (this.subdomain != null) {
            sb.append("subdomain:");
            sb.append(this.subdomain + ",");
        }
        if (this.terminationGracePeriodSeconds != null) {
            sb.append("terminationGracePeriodSeconds:");
            sb.append(this.terminationGracePeriodSeconds + ",");
        }
        if (this.tolerations != null && !this.tolerations.isEmpty()) {
            sb.append("tolerations:");
            sb.append(this.tolerations + ",");
        }
        if (this.topologySpreadConstraints != null && !this.topologySpreadConstraints.isEmpty()) {
            sb.append("topologySpreadConstraints:");
            sb.append(this.topologySpreadConstraints + ",");
        }
        if (this.volumes != null && !this.volumes.isEmpty()) {
            sb.append("volumes:");
            sb.append(this.volumes + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    @Override
    public A withAutomountServiceAccountToken() {
        return this.withAutomountServiceAccountToken(true);
    }

    @Override
    public A withEnableServiceLinks() {
        return this.withEnableServiceLinks(true);
    }

    @Override
    public A withHostIPC() {
        return this.withHostIPC(true);
    }

    @Override
    public A withHostNetwork() {
        return this.withHostNetwork(true);
    }

    @Override
    public A withHostPID() {
        return this.withHostPID(true);
    }

    @Override
    public A withHostUsers() {
        return this.withHostUsers(true);
    }

    @Override
    public A withSetHostnameAsFQDN() {
        return this.withSetHostnameAsFQDN(true);
    }

    @Override
    public A withShareProcessNamespace() {
        return this.withShareProcessNamespace(true);
    }

    class VolumesNestedImpl<N>
    extends VolumeFluentImpl<PodSpecFluent.VolumesNested<N>>
    implements PodSpecFluent.VolumesNested<N>,
    Nested<N> {
        VolumeBuilder builder;
        Integer index;

        VolumesNestedImpl(Integer index, Volume item) {
            this.index = index;
            this.builder = new VolumeBuilder(this, item);
        }

        VolumesNestedImpl() {
            this.index = -1;
            this.builder = new VolumeBuilder(this);
        }

        @Override
        public N and() {
            return (N)PodSpecFluentImpl.this.setToVolumes(this.index, this.builder.build());
        }

        @Override
        public N endVolume() {
            return this.and();
        }
    }

    class TopologySpreadConstraintsNestedImpl<N>
    extends TopologySpreadConstraintFluentImpl<PodSpecFluent.TopologySpreadConstraintsNested<N>>
    implements PodSpecFluent.TopologySpreadConstraintsNested<N>,
    Nested<N> {
        TopologySpreadConstraintBuilder builder;
        Integer index;

        TopologySpreadConstraintsNestedImpl(Integer index, TopologySpreadConstraint item) {
            this.index = index;
            this.builder = new TopologySpreadConstraintBuilder(this, item);
        }

        TopologySpreadConstraintsNestedImpl() {
            this.index = -1;
            this.builder = new TopologySpreadConstraintBuilder(this);
        }

        @Override
        public N and() {
            return (N)PodSpecFluentImpl.this.setToTopologySpreadConstraints(this.index, this.builder.build());
        }

        @Override
        public N endTopologySpreadConstraint() {
            return this.and();
        }
    }

    class TolerationsNestedImpl<N>
    extends TolerationFluentImpl<PodSpecFluent.TolerationsNested<N>>
    implements PodSpecFluent.TolerationsNested<N>,
    Nested<N> {
        TolerationBuilder builder;
        Integer index;

        TolerationsNestedImpl(Integer index, Toleration item) {
            this.index = index;
            this.builder = new TolerationBuilder(this, item);
        }

        TolerationsNestedImpl() {
            this.index = -1;
            this.builder = new TolerationBuilder(this);
        }

        @Override
        public N and() {
            return (N)PodSpecFluentImpl.this.setToTolerations(this.index, this.builder.build());
        }

        @Override
        public N endToleration() {
            return this.and();
        }
    }

    class SecurityContextNestedImpl<N>
    extends PodSecurityContextFluentImpl<PodSpecFluent.SecurityContextNested<N>>
    implements PodSpecFluent.SecurityContextNested<N>,
    Nested<N> {
        PodSecurityContextBuilder builder;

        SecurityContextNestedImpl(PodSecurityContext item) {
            this.builder = new PodSecurityContextBuilder(this, item);
        }

        SecurityContextNestedImpl() {
            this.builder = new PodSecurityContextBuilder(this);
        }

        @Override
        public N and() {
            return (N)PodSpecFluentImpl.this.withSecurityContext(this.builder.build());
        }

        @Override
        public N endSecurityContext() {
            return this.and();
        }
    }

    class SchedulingGatesNestedImpl<N>
    extends PodSchedulingGateFluentImpl<PodSpecFluent.SchedulingGatesNested<N>>
    implements PodSpecFluent.SchedulingGatesNested<N>,
    Nested<N> {
        PodSchedulingGateBuilder builder;
        Integer index;

        SchedulingGatesNestedImpl(Integer index, PodSchedulingGate item) {
            this.index = index;
            this.builder = new PodSchedulingGateBuilder(this, item);
        }

        SchedulingGatesNestedImpl() {
            this.index = -1;
            this.builder = new PodSchedulingGateBuilder(this);
        }

        @Override
        public N and() {
            return (N)PodSpecFluentImpl.this.setToSchedulingGates(this.index, this.builder.build());
        }

        @Override
        public N endSchedulingGate() {
            return this.and();
        }
    }

    class ResourceClaimsNestedImpl<N>
    extends PodResourceClaimFluentImpl<PodSpecFluent.ResourceClaimsNested<N>>
    implements PodSpecFluent.ResourceClaimsNested<N>,
    Nested<N> {
        PodResourceClaimBuilder builder;
        Integer index;

        ResourceClaimsNestedImpl(Integer index, PodResourceClaim item) {
            this.index = index;
            this.builder = new PodResourceClaimBuilder(this, item);
        }

        ResourceClaimsNestedImpl() {
            this.index = -1;
            this.builder = new PodResourceClaimBuilder(this);
        }

        @Override
        public N and() {
            return (N)PodSpecFluentImpl.this.setToResourceClaims(this.index, this.builder.build());
        }

        @Override
        public N endResourceClaim() {
            return this.and();
        }
    }

    class ReadinessGatesNestedImpl<N>
    extends PodReadinessGateFluentImpl<PodSpecFluent.ReadinessGatesNested<N>>
    implements PodSpecFluent.ReadinessGatesNested<N>,
    Nested<N> {
        PodReadinessGateBuilder builder;
        Integer index;

        ReadinessGatesNestedImpl(Integer index, PodReadinessGate item) {
            this.index = index;
            this.builder = new PodReadinessGateBuilder(this, item);
        }

        ReadinessGatesNestedImpl() {
            this.index = -1;
            this.builder = new PodReadinessGateBuilder(this);
        }

        @Override
        public N and() {
            return (N)PodSpecFluentImpl.this.setToReadinessGates(this.index, this.builder.build());
        }

        @Override
        public N endReadinessGate() {
            return this.and();
        }
    }

    class OsNestedImpl<N>
    extends PodOSFluentImpl<PodSpecFluent.OsNested<N>>
    implements PodSpecFluent.OsNested<N>,
    Nested<N> {
        PodOSBuilder builder;

        OsNestedImpl(PodOS item) {
            this.builder = new PodOSBuilder(this, item);
        }

        OsNestedImpl() {
            this.builder = new PodOSBuilder(this);
        }

        @Override
        public N and() {
            return (N)PodSpecFluentImpl.this.withOs(this.builder.build());
        }

        @Override
        public N endOs() {
            return this.and();
        }
    }

    class InitContainersNestedImpl<N>
    extends ContainerFluentImpl<PodSpecFluent.InitContainersNested<N>>
    implements PodSpecFluent.InitContainersNested<N>,
    Nested<N> {
        ContainerBuilder builder;
        Integer index;

        InitContainersNestedImpl(Integer index, Container item) {
            this.index = index;
            this.builder = new ContainerBuilder(this, item);
        }

        InitContainersNestedImpl() {
            this.index = -1;
            this.builder = new ContainerBuilder(this);
        }

        @Override
        public N and() {
            return (N)PodSpecFluentImpl.this.setToInitContainers(this.index, this.builder.build());
        }

        @Override
        public N endInitContainer() {
            return this.and();
        }
    }

    class ImagePullSecretsNestedImpl<N>
    extends LocalObjectReferenceFluentImpl<PodSpecFluent.ImagePullSecretsNested<N>>
    implements PodSpecFluent.ImagePullSecretsNested<N>,
    Nested<N> {
        LocalObjectReferenceBuilder builder;
        Integer index;

        ImagePullSecretsNestedImpl(Integer index, LocalObjectReference item) {
            this.index = index;
            this.builder = new LocalObjectReferenceBuilder(this, item);
        }

        ImagePullSecretsNestedImpl() {
            this.index = -1;
            this.builder = new LocalObjectReferenceBuilder(this);
        }

        @Override
        public N and() {
            return (N)PodSpecFluentImpl.this.setToImagePullSecrets(this.index, this.builder.build());
        }

        @Override
        public N endImagePullSecret() {
            return this.and();
        }
    }

    class HostAliasesNestedImpl<N>
    extends HostAliasFluentImpl<PodSpecFluent.HostAliasesNested<N>>
    implements PodSpecFluent.HostAliasesNested<N>,
    Nested<N> {
        HostAliasBuilder builder;
        Integer index;

        HostAliasesNestedImpl(Integer index, HostAlias item) {
            this.index = index;
            this.builder = new HostAliasBuilder(this, item);
        }

        HostAliasesNestedImpl() {
            this.index = -1;
            this.builder = new HostAliasBuilder(this);
        }

        @Override
        public N and() {
            return (N)PodSpecFluentImpl.this.setToHostAliases(this.index, this.builder.build());
        }

        @Override
        public N endHostAlias() {
            return this.and();
        }
    }

    class EphemeralContainersNestedImpl<N>
    extends EphemeralContainerFluentImpl<PodSpecFluent.EphemeralContainersNested<N>>
    implements PodSpecFluent.EphemeralContainersNested<N>,
    Nested<N> {
        EphemeralContainerBuilder builder;
        Integer index;

        EphemeralContainersNestedImpl(Integer index, EphemeralContainer item) {
            this.index = index;
            this.builder = new EphemeralContainerBuilder(this, item);
        }

        EphemeralContainersNestedImpl() {
            this.index = -1;
            this.builder = new EphemeralContainerBuilder(this);
        }

        @Override
        public N and() {
            return (N)PodSpecFluentImpl.this.setToEphemeralContainers(this.index, this.builder.build());
        }

        @Override
        public N endEphemeralContainer() {
            return this.and();
        }
    }

    class DnsConfigNestedImpl<N>
    extends PodDNSConfigFluentImpl<PodSpecFluent.DnsConfigNested<N>>
    implements PodSpecFluent.DnsConfigNested<N>,
    Nested<N> {
        PodDNSConfigBuilder builder;

        DnsConfigNestedImpl(PodDNSConfig item) {
            this.builder = new PodDNSConfigBuilder(this, item);
        }

        DnsConfigNestedImpl() {
            this.builder = new PodDNSConfigBuilder(this);
        }

        @Override
        public N and() {
            return (N)PodSpecFluentImpl.this.withDnsConfig(this.builder.build());
        }

        @Override
        public N endDnsConfig() {
            return this.and();
        }
    }

    class ContainersNestedImpl<N>
    extends ContainerFluentImpl<PodSpecFluent.ContainersNested<N>>
    implements PodSpecFluent.ContainersNested<N>,
    Nested<N> {
        ContainerBuilder builder;
        Integer index;

        ContainersNestedImpl(Integer index, Container item) {
            this.index = index;
            this.builder = new ContainerBuilder(this, item);
        }

        ContainersNestedImpl() {
            this.index = -1;
            this.builder = new ContainerBuilder(this);
        }

        @Override
        public N and() {
            return (N)PodSpecFluentImpl.this.setToContainers(this.index, this.builder.build());
        }

        @Override
        public N endContainer() {
            return this.and();
        }
    }

    class AffinityNestedImpl<N>
    extends AffinityFluentImpl<PodSpecFluent.AffinityNested<N>>
    implements PodSpecFluent.AffinityNested<N>,
    Nested<N> {
        AffinityBuilder builder;

        AffinityNestedImpl(Affinity item) {
            this.builder = new AffinityBuilder(this, item);
        }

        AffinityNestedImpl() {
            this.builder = new AffinityBuilder(this);
        }

        @Override
        public N and() {
            return (N)PodSpecFluentImpl.this.withAffinity(this.builder.build());
        }

        @Override
        public N endAffinity() {
            return this.and();
        }
    }
}

