/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.builder.BaseFluent;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.builder.Nested;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.Quantity;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.ResourceClaim;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.ResourceClaimBuilder;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.ResourceClaimFluentImpl;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.ResourceRequirements;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.ResourceRequirementsFluent;

public class ResourceRequirementsFluentImpl<A extends ResourceRequirementsFluent<A>>
extends BaseFluent<A>
implements ResourceRequirementsFluent<A> {
    private ArrayList<ResourceClaimBuilder> claims = new ArrayList();
    private Map<String, Quantity> limits;
    private Map<String, Quantity> requests;
    private Map<String, Object> additionalProperties;

    public ResourceRequirementsFluentImpl() {
    }

    public ResourceRequirementsFluentImpl(ResourceRequirements instance) {
        this.withClaims(instance.getClaims());
        this.withLimits(instance.getLimits());
        this.withRequests(instance.getRequests());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    public A addToClaims(Integer index, ResourceClaim item) {
        if (this.claims == null) {
            this.claims = new ArrayList();
        }
        ResourceClaimBuilder builder = new ResourceClaimBuilder(item);
        this._visitables.get("claims").add(index >= 0 ? index.intValue() : this._visitables.get("claims").size(), builder);
        this.claims.add(index >= 0 ? index.intValue() : this.claims.size(), builder);
        return (A)this;
    }

    @Override
    public A setToClaims(Integer index, ResourceClaim item) {
        if (this.claims == null) {
            this.claims = new ArrayList();
        }
        ResourceClaimBuilder builder = new ResourceClaimBuilder(item);
        if (index < 0 || index >= this._visitables.get("claims").size()) {
            this._visitables.get("claims").add(builder);
        } else {
            this._visitables.get("claims").set(index, builder);
        }
        if (index < 0 || index >= this.claims.size()) {
            this.claims.add(builder);
        } else {
            this.claims.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToClaims(ResourceClaim ... items) {
        if (this.claims == null) {
            this.claims = new ArrayList();
        }
        for (ResourceClaim item : items) {
            ResourceClaimBuilder builder = new ResourceClaimBuilder(item);
            this._visitables.get("claims").add(builder);
            this.claims.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToClaims(Collection<ResourceClaim> items) {
        if (this.claims == null) {
            this.claims = new ArrayList();
        }
        for (ResourceClaim item : items) {
            ResourceClaimBuilder builder = new ResourceClaimBuilder(item);
            this._visitables.get("claims").add(builder);
            this.claims.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromClaims(ResourceClaim ... items) {
        for (ResourceClaim item : items) {
            ResourceClaimBuilder builder = new ResourceClaimBuilder(item);
            this._visitables.get("claims").remove(builder);
            if (this.claims == null) continue;
            this.claims.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromClaims(Collection<ResourceClaim> items) {
        for (ResourceClaim item : items) {
            ResourceClaimBuilder builder = new ResourceClaimBuilder(item);
            this._visitables.get("claims").remove(builder);
            if (this.claims == null) continue;
            this.claims.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromClaims(Predicate<ResourceClaimBuilder> predicate) {
        if (this.claims == null) {
            return (A)this;
        }
        Iterator<ResourceClaimBuilder> each = this.claims.iterator();
        Object visitables = this._visitables.get("claims");
        while (each.hasNext()) {
            ResourceClaimBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<ResourceClaim> getClaims() {
        return this.claims != null ? ResourceRequirementsFluentImpl.build(this.claims) : null;
    }

    @Override
    public List<ResourceClaim> buildClaims() {
        return this.claims != null ? ResourceRequirementsFluentImpl.build(this.claims) : null;
    }

    @Override
    public ResourceClaim buildClaim(Integer index) {
        return this.claims.get(index).build();
    }

    @Override
    public ResourceClaim buildFirstClaim() {
        return this.claims.get(0).build();
    }

    @Override
    public ResourceClaim buildLastClaim() {
        return this.claims.get(this.claims.size() - 1).build();
    }

    @Override
    public ResourceClaim buildMatchingClaim(Predicate<ResourceClaimBuilder> predicate) {
        for (ResourceClaimBuilder item : this.claims) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingClaim(Predicate<ResourceClaimBuilder> predicate) {
        for (ResourceClaimBuilder item : this.claims) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withClaims(List<ResourceClaim> claims) {
        if (this.claims != null) {
            this._visitables.get("claims").removeAll(this.claims);
        }
        if (claims != null) {
            this.claims = new ArrayList();
            for (ResourceClaim item : claims) {
                this.addToClaims(item);
            }
        } else {
            this.claims = null;
        }
        return (A)this;
    }

    @Override
    public A withClaims(ResourceClaim ... claims) {
        if (this.claims != null) {
            this.claims.clear();
        }
        if (claims != null) {
            for (ResourceClaim item : claims) {
                this.addToClaims(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasClaims() {
        return this.claims != null && !this.claims.isEmpty();
    }

    @Override
    public A addNewClaim(String name) {
        return this.addToClaims(new ResourceClaim(name));
    }

    @Override
    public ResourceRequirementsFluent.ClaimsNested<A> addNewClaim() {
        return new ClaimsNestedImpl();
    }

    @Override
    public ResourceRequirementsFluent.ClaimsNested<A> addNewClaimLike(ResourceClaim item) {
        return new ClaimsNestedImpl(-1, item);
    }

    @Override
    public ResourceRequirementsFluent.ClaimsNested<A> setNewClaimLike(Integer index, ResourceClaim item) {
        return new ClaimsNestedImpl(index, item);
    }

    @Override
    public ResourceRequirementsFluent.ClaimsNested<A> editClaim(Integer index) {
        if (this.claims.size() <= index) {
            throw new RuntimeException("Can't edit claims. Index exceeds size.");
        }
        return this.setNewClaimLike(index, this.buildClaim(index));
    }

    @Override
    public ResourceRequirementsFluent.ClaimsNested<A> editFirstClaim() {
        if (this.claims.size() == 0) {
            throw new RuntimeException("Can't edit first claims. The list is empty.");
        }
        return this.setNewClaimLike(0, this.buildClaim(0));
    }

    @Override
    public ResourceRequirementsFluent.ClaimsNested<A> editLastClaim() {
        int index = this.claims.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last claims. The list is empty.");
        }
        return this.setNewClaimLike(index, this.buildClaim(index));
    }

    @Override
    public ResourceRequirementsFluent.ClaimsNested<A> editMatchingClaim(Predicate<ResourceClaimBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.claims.size(); ++i) {
            if (!predicate.test(this.claims.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching claims. No match found.");
        }
        return this.setNewClaimLike(index, this.buildClaim(index));
    }

    @Override
    public A addToLimits(String key, Quantity value) {
        if (this.limits == null && key != null && value != null) {
            this.limits = new LinkedHashMap<String, Quantity>();
        }
        if (key != null && value != null) {
            this.limits.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToLimits(Map<String, Quantity> map) {
        if (this.limits == null && map != null) {
            this.limits = new LinkedHashMap<String, Quantity>();
        }
        if (map != null) {
            this.limits.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromLimits(String key) {
        if (this.limits == null) {
            return (A)this;
        }
        if (key != null && this.limits != null) {
            this.limits.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromLimits(Map<String, Quantity> map) {
        if (this.limits == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.limits == null) continue;
                this.limits.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Quantity> getLimits() {
        return this.limits;
    }

    @Override
    public <K, V> A withLimits(Map<String, Quantity> limits) {
        this.limits = limits == null ? null : new LinkedHashMap<String, Quantity>(limits);
        return (A)this;
    }

    @Override
    public Boolean hasLimits() {
        return this.limits != null;
    }

    @Override
    public A addToRequests(String key, Quantity value) {
        if (this.requests == null && key != null && value != null) {
            this.requests = new LinkedHashMap<String, Quantity>();
        }
        if (key != null && value != null) {
            this.requests.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToRequests(Map<String, Quantity> map) {
        if (this.requests == null && map != null) {
            this.requests = new LinkedHashMap<String, Quantity>();
        }
        if (map != null) {
            this.requests.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromRequests(String key) {
        if (this.requests == null) {
            return (A)this;
        }
        if (key != null && this.requests != null) {
            this.requests.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromRequests(Map<String, Quantity> map) {
        if (this.requests == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.requests == null) continue;
                this.requests.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Quantity> getRequests() {
        return this.requests;
    }

    @Override
    public <K, V> A withRequests(Map<String, Quantity> requests) {
        this.requests = requests == null ? null : new LinkedHashMap<String, Quantity>(requests);
        return (A)this;
    }

    @Override
    public Boolean hasRequests() {
        return this.requests != null;
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResourceRequirementsFluentImpl that = (ResourceRequirementsFluentImpl)o;
        if (this.claims != null ? !this.claims.equals(that.claims) : that.claims != null) {
            return false;
        }
        if (this.limits != null ? !this.limits.equals(that.limits) : that.limits != null) {
            return false;
        }
        if (this.requests != null ? !this.requests.equals(that.requests) : that.requests != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.claims, this.limits, this.requests, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.claims != null && !this.claims.isEmpty()) {
            sb.append("claims:");
            sb.append(this.claims + ",");
        }
        if (this.limits != null && !this.limits.isEmpty()) {
            sb.append("limits:");
            sb.append(this.limits + ",");
        }
        if (this.requests != null && !this.requests.isEmpty()) {
            sb.append("requests:");
            sb.append(this.requests + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    class ClaimsNestedImpl<N>
    extends ResourceClaimFluentImpl<ResourceRequirementsFluent.ClaimsNested<N>>
    implements ResourceRequirementsFluent.ClaimsNested<N>,
    Nested<N> {
        ResourceClaimBuilder builder;
        Integer index;

        ClaimsNestedImpl(Integer index, ResourceClaim item) {
            this.index = index;
            this.builder = new ResourceClaimBuilder(this, item);
        }

        ClaimsNestedImpl() {
            this.index = -1;
            this.builder = new ResourceClaimBuilder(this);
        }

        @Override
        public N and() {
            return (N)ResourceRequirementsFluentImpl.this.setToClaims(this.index, this.builder.build());
        }

        @Override
        public N endClaim() {
            return this.and();
        }
    }
}

