/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model;

import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.builder.VisitableBuilder;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.SecurityContext;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.SecurityContextFluent;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.SecurityContextFluentImpl;

public class SecurityContextBuilder
extends SecurityContextFluentImpl<SecurityContextBuilder>
implements VisitableBuilder<SecurityContext, SecurityContextBuilder> {
    SecurityContextFluent<?> fluent;
    Boolean validationEnabled;

    public SecurityContextBuilder() {
        this(false);
    }

    public SecurityContextBuilder(Boolean validationEnabled) {
        this(new SecurityContext(), validationEnabled);
    }

    public SecurityContextBuilder(SecurityContextFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public SecurityContextBuilder(SecurityContextFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new SecurityContext(), validationEnabled);
    }

    public SecurityContextBuilder(SecurityContextFluent<?> fluent, SecurityContext instance) {
        this(fluent, instance, false);
    }

    public SecurityContextBuilder(SecurityContextFluent<?> fluent, SecurityContext instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withAllowPrivilegeEscalation(instance.getAllowPrivilegeEscalation());
        fluent.withCapabilities(instance.getCapabilities());
        fluent.withPrivileged(instance.getPrivileged());
        fluent.withProcMount(instance.getProcMount());
        fluent.withReadOnlyRootFilesystem(instance.getReadOnlyRootFilesystem());
        fluent.withRunAsGroup(instance.getRunAsGroup());
        fluent.withRunAsNonRoot(instance.getRunAsNonRoot());
        fluent.withRunAsUser(instance.getRunAsUser());
        fluent.withSeLinuxOptions(instance.getSeLinuxOptions());
        fluent.withSeccompProfile(instance.getSeccompProfile());
        fluent.withWindowsOptions(instance.getWindowsOptions());
        fluent.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    public SecurityContextBuilder(SecurityContext instance) {
        this(instance, (Boolean)false);
    }

    public SecurityContextBuilder(SecurityContext instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withAllowPrivilegeEscalation(instance.getAllowPrivilegeEscalation());
        this.withCapabilities(instance.getCapabilities());
        this.withPrivileged(instance.getPrivileged());
        this.withProcMount(instance.getProcMount());
        this.withReadOnlyRootFilesystem(instance.getReadOnlyRootFilesystem());
        this.withRunAsGroup(instance.getRunAsGroup());
        this.withRunAsNonRoot(instance.getRunAsNonRoot());
        this.withRunAsUser(instance.getRunAsUser());
        this.withSeLinuxOptions(instance.getSeLinuxOptions());
        this.withSeccompProfile(instance.getSeccompProfile());
        this.withWindowsOptions(instance.getWindowsOptions());
        this.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public SecurityContext build() {
        SecurityContext buildable = new SecurityContext(this.fluent.getAllowPrivilegeEscalation(), this.fluent.getCapabilities(), this.fluent.getPrivileged(), this.fluent.getProcMount(), this.fluent.getReadOnlyRootFilesystem(), this.fluent.getRunAsGroup(), this.fluent.getRunAsNonRoot(), this.fluent.getRunAsUser(), this.fluent.getSeLinuxOptions(), this.fluent.getSeccompProfile(), this.fluent.getWindowsOptions());
        buildable.setAdditionalProperties(this.fluent.getAdditionalProperties());
        return buildable;
    }
}

