/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.networking.v1beta1;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.builder.BaseFluent;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.builder.Nested;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.networking.v1beta1.HTTPIngressRuleValue;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.networking.v1beta1.HTTPIngressRuleValueBuilder;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.networking.v1beta1.HTTPIngressRuleValueFluentImpl;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.networking.v1beta1.IngressRule;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.networking.v1beta1.IngressRuleFluent;

public class IngressRuleFluentImpl<A extends IngressRuleFluent<A>>
extends BaseFluent<A>
implements IngressRuleFluent<A> {
    private String host;
    private HTTPIngressRuleValueBuilder http;
    private Map<String, Object> additionalProperties;

    public IngressRuleFluentImpl() {
    }

    public IngressRuleFluentImpl(IngressRule instance) {
        this.withHost(instance.getHost());
        this.withHttp(instance.getHttp());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    public String getHost() {
        return this.host;
    }

    @Override
    public A withHost(String host) {
        this.host = host;
        return (A)this;
    }

    @Override
    public Boolean hasHost() {
        return this.host != null;
    }

    @Override
    @Deprecated
    public HTTPIngressRuleValue getHttp() {
        return this.http != null ? this.http.build() : null;
    }

    @Override
    public HTTPIngressRuleValue buildHttp() {
        return this.http != null ? this.http.build() : null;
    }

    @Override
    public A withHttp(HTTPIngressRuleValue http) {
        this._visitables.get("http").remove(this.http);
        if (http != null) {
            this.http = new HTTPIngressRuleValueBuilder(http);
            this._visitables.get("http").add(this.http);
        } else {
            this.http = null;
            this._visitables.get("http").remove(this.http);
        }
        return (A)this;
    }

    @Override
    public Boolean hasHttp() {
        return this.http != null;
    }

    @Override
    public IngressRuleFluent.HttpNested<A> withNewHttp() {
        return new HttpNestedImpl();
    }

    @Override
    public IngressRuleFluent.HttpNested<A> withNewHttpLike(HTTPIngressRuleValue item) {
        return new HttpNestedImpl(item);
    }

    @Override
    public IngressRuleFluent.HttpNested<A> editHttp() {
        return this.withNewHttpLike(this.getHttp());
    }

    @Override
    public IngressRuleFluent.HttpNested<A> editOrNewHttp() {
        return this.withNewHttpLike(this.getHttp() != null ? this.getHttp() : new HTTPIngressRuleValueBuilder().build());
    }

    @Override
    public IngressRuleFluent.HttpNested<A> editOrNewHttpLike(HTTPIngressRuleValue item) {
        return this.withNewHttpLike(this.getHttp() != null ? this.getHttp() : item);
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IngressRuleFluentImpl that = (IngressRuleFluentImpl)o;
        if (this.host != null ? !this.host.equals(that.host) : that.host != null) {
            return false;
        }
        if (this.http != null ? !this.http.equals(that.http) : that.http != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.host, this.http, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.host != null) {
            sb.append("host:");
            sb.append(this.host + ",");
        }
        if (this.http != null) {
            sb.append("http:");
            sb.append(this.http + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    class HttpNestedImpl<N>
    extends HTTPIngressRuleValueFluentImpl<IngressRuleFluent.HttpNested<N>>
    implements IngressRuleFluent.HttpNested<N>,
    Nested<N> {
        HTTPIngressRuleValueBuilder builder;

        HttpNestedImpl(HTTPIngressRuleValue item) {
            this.builder = new HTTPIngressRuleValueBuilder(this, item);
        }

        HttpNestedImpl() {
            this.builder = new HTTPIngressRuleValueBuilder(this);
        }

        @Override
        public N and() {
            return (N)IngressRuleFluentImpl.this.withHttp(this.builder.build());
        }

        @Override
        public N endHttp() {
            return this.and();
        }
    }
}

