/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.extended.leaderelection;

import java.time.Duration;
import java.util.Objects;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.builder.BaseFluent;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.extended.leaderelection.LeaderCallbacks;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.extended.leaderelection.LeaderElectionConfig;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.extended.leaderelection.LeaderElectionConfigFluent;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.extended.leaderelection.resourcelock.Lock;

public class LeaderElectionConfigFluentImpl<A extends LeaderElectionConfigFluent<A>>
extends BaseFluent<A>
implements LeaderElectionConfigFluent<A> {
    private Lock lock;
    private Duration leaseDuration;
    private Duration renewDeadline;
    private Duration retryPeriod;
    private LeaderCallbacks leaderCallbacks;
    private boolean releaseOnCancel;
    private String name;

    public LeaderElectionConfigFluentImpl() {
    }

    public LeaderElectionConfigFluentImpl(LeaderElectionConfig instance) {
        this.withLock(instance.getLock());
        this.withLeaseDuration(instance.getLeaseDuration());
        this.withRenewDeadline(instance.getRenewDeadline());
        this.withRetryPeriod(instance.getRetryPeriod());
        this.withLeaderCallbacks(instance.getLeaderCallbacks());
        this.withReleaseOnCancel(instance.isReleaseOnCancel());
        this.withName(instance.getName());
    }

    @Override
    public Lock getLock() {
        return this.lock;
    }

    @Override
    public A withLock(Lock lock) {
        this.lock = lock;
        return (A)this;
    }

    @Override
    public Boolean hasLock() {
        return this.lock != null;
    }

    @Override
    public Duration getLeaseDuration() {
        return this.leaseDuration;
    }

    @Override
    public A withLeaseDuration(Duration leaseDuration) {
        this.leaseDuration = leaseDuration;
        return (A)this;
    }

    @Override
    public Boolean hasLeaseDuration() {
        return this.leaseDuration != null;
    }

    @Override
    public Duration getRenewDeadline() {
        return this.renewDeadline;
    }

    @Override
    public A withRenewDeadline(Duration renewDeadline) {
        this.renewDeadline = renewDeadline;
        return (A)this;
    }

    @Override
    public Boolean hasRenewDeadline() {
        return this.renewDeadline != null;
    }

    @Override
    public Duration getRetryPeriod() {
        return this.retryPeriod;
    }

    @Override
    public A withRetryPeriod(Duration retryPeriod) {
        this.retryPeriod = retryPeriod;
        return (A)this;
    }

    @Override
    public Boolean hasRetryPeriod() {
        return this.retryPeriod != null;
    }

    @Override
    public LeaderCallbacks getLeaderCallbacks() {
        return this.leaderCallbacks;
    }

    @Override
    public A withLeaderCallbacks(LeaderCallbacks leaderCallbacks) {
        this.leaderCallbacks = leaderCallbacks;
        return (A)this;
    }

    @Override
    public Boolean hasLeaderCallbacks() {
        return this.leaderCallbacks != null;
    }

    @Override
    public boolean isReleaseOnCancel() {
        return this.releaseOnCancel;
    }

    @Override
    public A withReleaseOnCancel(boolean releaseOnCancel) {
        this.releaseOnCancel = releaseOnCancel;
        return (A)this;
    }

    @Override
    public Boolean hasReleaseOnCancel() {
        return true;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public A withName(String name) {
        this.name = name;
        return (A)this;
    }

    @Override
    public Boolean hasName() {
        return this.name != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LeaderElectionConfigFluentImpl that = (LeaderElectionConfigFluentImpl)o;
        if (this.lock != null ? !this.lock.equals(that.lock) : that.lock != null) {
            return false;
        }
        if (this.leaseDuration != null ? !this.leaseDuration.equals(that.leaseDuration) : that.leaseDuration != null) {
            return false;
        }
        if (this.renewDeadline != null ? !this.renewDeadline.equals(that.renewDeadline) : that.renewDeadline != null) {
            return false;
        }
        if (this.retryPeriod != null ? !this.retryPeriod.equals(that.retryPeriod) : that.retryPeriod != null) {
            return false;
        }
        if (this.leaderCallbacks != null ? !this.leaderCallbacks.equals(that.leaderCallbacks) : that.leaderCallbacks != null) {
            return false;
        }
        if (this.releaseOnCancel != that.releaseOnCancel) {
            return false;
        }
        return !(this.name != null ? !this.name.equals(that.name) : that.name != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.lock, this.leaseDuration, this.renewDeadline, this.retryPeriod, this.leaderCallbacks, this.releaseOnCancel, this.name, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.lock != null) {
            sb.append("lock:");
            sb.append(this.lock + ",");
        }
        if (this.leaseDuration != null) {
            sb.append("leaseDuration:");
            sb.append(this.leaseDuration + ",");
        }
        if (this.renewDeadline != null) {
            sb.append("renewDeadline:");
            sb.append(this.renewDeadline + ",");
        }
        if (this.retryPeriod != null) {
            sb.append("retryPeriod:");
            sb.append(this.retryPeriod + ",");
        }
        if (this.leaderCallbacks != null) {
            sb.append("leaderCallbacks:");
            sb.append(this.leaderCallbacks + ",");
        }
        sb.append("releaseOnCancel:");
        sb.append(this.releaseOnCancel + ",");
        if (this.name != null) {
            sb.append("name:");
            sb.append(this.name);
        }
        sb.append("}");
        return sb.toString();
    }

    @Override
    public A withReleaseOnCancel() {
        return this.withReleaseOnCancel(true);
    }
}

