/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.extended.run;

import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.Pod;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.api.model.PodBuilder;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.KubernetesClient;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.NamespacedKubernetesClient;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.dsl.PodResource;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.extended.run.EditableRunConfig;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.extended.run.RunConfig;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.extended.run.RunConfigBuilder;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.extended.run.RunConfigFluent;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.extended.run.RunConfigFluentImpl;
import org.apache.flink.kubernetes.shaded.io.fabric8.kubernetes.client.extended.run.RunConfigUtil;

public class RunOperations {
    private final KubernetesClient client;
    private final RunConfig runConfig;

    public RunOperations(KubernetesClient client, RunConfig runConfig) {
        this.client = client;
        this.runConfig = runConfig;
    }

    public RunOperations inNamespace(String namespace) {
        return new RunOperations(this.client.adapt(NamespacedKubernetesClient.class).inNamespace(namespace), this.runConfig);
    }

    public RunOperations withImage(String image) {
        return new RunOperations(this.client, ((RunConfigBuilder)new RunConfigBuilder(this.runConfig).withImage(image)).build());
    }

    public RunOperations withName(String name) {
        return new RunOperations(this.client, ((RunConfigBuilder)new RunConfigBuilder(this.runConfig).withName(name)).build());
    }

    @Deprecated
    public RunOperations withRunConfig(RunConfig generatorRunConfig) {
        return new RunOperations(this.client, new RunConfigBuilder(generatorRunConfig).build());
    }

    public RunConfigNested withNewRunConfig() {
        return new RunConfigNestedImpl();
    }

    public Pod done() {
        return (Pod)((PodResource)this.client.pods().resource(this.convertRunConfigIntoPod())).create();
    }

    Pod convertRunConfigIntoPod() {
        return ((PodBuilder)((PodBuilder)new PodBuilder().withMetadata(RunConfigUtil.getObjectMetadataFromRunConfig(this.runConfig))).withSpec(RunConfigUtil.getPodSpecFromRunConfig(this.runConfig))).build();
    }

    private class RunConfigNestedImpl
    extends RunConfigFluentImpl<RunConfigNested>
    implements RunConfigNested {
        RunConfigNestedImpl() {
            super(RunOperations.this.runConfig);
        }

        @Override
        public Pod done() {
            EditableRunConfig runConfig = new RunConfigBuilder(this).build();
            return RunOperations.this.withRunConfig(runConfig).done();
        }
    }

    public static interface RunConfigNested
    extends RunConfigFluent<RunConfigNested> {
        public Pod done();
    }
}

