/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.highavailability;

import java.util.concurrent.Executor;
import java.util.function.Function;
import org.apache.flink.api.common.JobID;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.kubernetes.highavailability.KubernetesCheckpointIDCounter;
import org.apache.flink.kubernetes.kubeclient.FlinkKubeClient;
import org.apache.flink.kubernetes.utils.KubernetesUtils;
import org.apache.flink.runtime.checkpoint.CheckpointIDCounter;
import org.apache.flink.runtime.checkpoint.CheckpointRecoveryFactory;
import org.apache.flink.runtime.checkpoint.CompletedCheckpointStore;
import org.apache.flink.util.Preconditions;

public class KubernetesCheckpointRecoveryFactory
implements CheckpointRecoveryFactory {
    private final FlinkKubeClient kubeClient;
    private final Executor executor;
    private final Function<JobID, String> getConfigMapNameFunction;
    private final Configuration configuration;
    private final String lockIdentity;

    public KubernetesCheckpointRecoveryFactory(FlinkKubeClient kubeClient, Configuration configuration, Executor executor, Function<JobID, String> function, String lockIdentity) {
        this.kubeClient = (FlinkKubeClient)Preconditions.checkNotNull((Object)kubeClient);
        this.configuration = (Configuration)Preconditions.checkNotNull((Object)configuration);
        this.executor = (Executor)Preconditions.checkNotNull((Object)executor);
        this.getConfigMapNameFunction = (Function)Preconditions.checkNotNull(function);
        this.lockIdentity = (String)Preconditions.checkNotNull((Object)lockIdentity);
    }

    public CompletedCheckpointStore createCheckpointStore(JobID jobID, int maxNumberOfCheckpointsToRetain, ClassLoader userClassLoader) throws Exception {
        String configMapName = this.getConfigMapNameFunction.apply(jobID);
        return KubernetesUtils.createCompletedCheckpointStore(this.configuration, this.kubeClient, this.executor, configMapName, this.lockIdentity, maxNumberOfCheckpointsToRetain);
    }

    public CheckpointIDCounter createCheckpointIDCounter(JobID jobID) {
        return new KubernetesCheckpointIDCounter(this.kubeClient, this.getConfigMapNameFunction.apply(jobID), this.lockIdentity);
    }
}

