/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.kubeclient;

import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerBuilder;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodBuilder;
import org.apache.flink.util.Preconditions;

public class FlinkPod {
    private final Pod pod;
    private final Container mainContainer;

    public FlinkPod(Pod pod, Container mainContainer) {
        this.pod = pod;
        this.mainContainer = mainContainer;
    }

    public Pod getPod() {
        return this.pod;
    }

    public Container getMainContainer() {
        return this.mainContainer;
    }

    public static class Builder {
        private Pod pod;
        private Container mainContainer;

        public Builder() {
            this.pod = ((PodBuilder)((PodBuilder)new PodBuilder().withNewMetadata().endMetadata()).withNewSpec().endSpec()).build();
            this.mainContainer = new ContainerBuilder().build();
        }

        public Builder(FlinkPod flinkPod) {
            Preconditions.checkNotNull((Object)flinkPod);
            this.pod = (Pod)Preconditions.checkNotNull((Object)flinkPod.getPod());
            this.mainContainer = (Container)Preconditions.checkNotNull((Object)flinkPod.getMainContainer());
        }

        public Builder withPod(Pod pod) {
            this.pod = (Pod)Preconditions.checkNotNull((Object)pod);
            return this;
        }

        public Builder withMainContainer(Container mainContainer) {
            this.mainContainer = (Container)Preconditions.checkNotNull((Object)mainContainer);
            return this;
        }

        public FlinkPod build() {
            return new FlinkPod(this.pod, this.mainContainer);
        }
    }
}

