/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.kubeclient.decorators;

import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerBuilder;
import io.fabric8.kubernetes.api.model.ContainerFluent;
import io.fabric8.kubernetes.api.model.ContainerPort;
import io.fabric8.kubernetes.api.model.ContainerPortBuilder;
import io.fabric8.kubernetes.api.model.EnvVar;
import io.fabric8.kubernetes.api.model.EnvVarBuilder;
import io.fabric8.kubernetes.api.model.EnvVarSourceBuilder;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodBuilder;
import io.fabric8.kubernetes.api.model.PodFluent;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import io.fabric8.kubernetes.api.model.Toleration;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.flink.kubernetes.kubeclient.FlinkPod;
import org.apache.flink.kubernetes.kubeclient.decorators.AbstractKubernetesStepDecorator;
import org.apache.flink.kubernetes.kubeclient.parameters.KubernetesJobManagerParameters;
import org.apache.flink.kubernetes.kubeclient.resources.KubernetesToleration;
import org.apache.flink.kubernetes.utils.KubernetesUtils;
import org.apache.flink.util.Preconditions;

public class InitJobManagerDecorator
extends AbstractKubernetesStepDecorator {
    private final KubernetesJobManagerParameters kubernetesJobManagerParameters;

    public InitJobManagerDecorator(KubernetesJobManagerParameters kubernetesJobManagerParameters) {
        this.kubernetesJobManagerParameters = (KubernetesJobManagerParameters)Preconditions.checkNotNull((Object)kubernetesJobManagerParameters);
    }

    @Override
    public FlinkPod decorateFlinkPod(FlinkPod flinkPod) {
        Pod basicPod = ((PodBuilder)((PodFluent.SpecNested)((PodFluent.SpecNested)((PodFluent.SpecNested)((PodFluent.SpecNested)((PodBuilder)((PodFluent.MetadataNested)((PodFluent.MetadataNested)((PodBuilder)new PodBuilder(flinkPod.getPod()).withApiVersion("v1")).editOrNewMetadata().withLabels(this.kubernetesJobManagerParameters.getLabels())).withAnnotations(this.kubernetesJobManagerParameters.getAnnotations())).endMetadata()).editOrNewSpec().withServiceAccountName(this.kubernetesJobManagerParameters.getServiceAccount())).withImagePullSecrets(this.kubernetesJobManagerParameters.getImagePullSecrets())).withNodeSelector(this.kubernetesJobManagerParameters.getNodeSelector())).withTolerations(this.kubernetesJobManagerParameters.getTolerations().stream().map(e -> (Toleration)KubernetesToleration.fromMap(e).getInternalResource()).collect(Collectors.toList()))).endSpec()).build();
        Container basicMainContainer = this.decorateMainContainer(flinkPod.getMainContainer());
        return new FlinkPod.Builder(flinkPod).withPod(basicPod).withMainContainer(basicMainContainer).build();
    }

    private Container decorateMainContainer(Container container) {
        ResourceRequirements requirements = KubernetesUtils.getResourceRequirements(this.kubernetesJobManagerParameters.getJobManagerMemoryMB(), this.kubernetesJobManagerParameters.getJobManagerCPU(), Collections.emptyMap());
        return ((ContainerBuilder)((ContainerFluent.EnvNested)((ContainerFluent.EnvNested)((ContainerBuilder)((ContainerBuilder)((ContainerBuilder)((ContainerBuilder)((ContainerBuilder)((ContainerBuilder)new ContainerBuilder(container).withName(this.kubernetesJobManagerParameters.getJobManagerMainContainerName())).withImage(this.kubernetesJobManagerParameters.getImage())).withImagePullPolicy(this.kubernetesJobManagerParameters.getImagePullPolicy().name())).withResources(requirements)).withPorts(this.getContainerPorts())).withEnv(this.getCustomizedEnvs())).addNewEnv().withName("_POD_IP_ADDRESS")).withValueFrom(((EnvVarSourceBuilder)new EnvVarSourceBuilder().withNewFieldRef("v1", "status.podIP")).build())).endEnv()).build();
    }

    private List<ContainerPort> getContainerPorts() {
        return Arrays.asList(((ContainerPortBuilder)((ContainerPortBuilder)new ContainerPortBuilder().withName("rest")).withContainerPort(this.kubernetesJobManagerParameters.getRestPort())).build(), ((ContainerPortBuilder)((ContainerPortBuilder)new ContainerPortBuilder().withName("jobmanager-rpc")).withContainerPort(this.kubernetesJobManagerParameters.getRPCPort())).build(), ((ContainerPortBuilder)((ContainerPortBuilder)new ContainerPortBuilder().withName("blobserver")).withContainerPort(this.kubernetesJobManagerParameters.getBlobServerPort())).build());
    }

    private List<EnvVar> getCustomizedEnvs() {
        return this.kubernetesJobManagerParameters.getEnvironments().entrySet().stream().map(kv -> ((EnvVarBuilder)((EnvVarBuilder)new EnvVarBuilder().withName((String)kv.getKey())).withValue((String)kv.getValue())).build()).collect(Collectors.toList());
    }
}

