/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.kubeclient.decorators;

import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerBuilder;
import java.util.Arrays;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.kubernetes.kubeclient.FlinkPod;
import org.apache.flink.kubernetes.kubeclient.decorators.AbstractKubernetesStepDecorator;
import org.apache.flink.kubernetes.kubeclient.parameters.KubernetesTaskManagerParameters;
import org.apache.flink.kubernetes.taskmanager.KubernetesTaskExecutorRunner;
import org.apache.flink.kubernetes.utils.KubernetesUtils;
import org.apache.flink.runtime.clusterframework.ContaineredTaskManagerParameters;
import org.apache.flink.runtime.clusterframework.TaskExecutorProcessSpec;
import org.apache.flink.runtime.clusterframework.TaskExecutorProcessUtils;
import org.apache.flink.runtime.entrypoint.parser.CommandLineOptions;
import org.apache.flink.runtime.util.config.memory.ProcessMemorySpec;
import org.apache.flink.runtime.util.config.memory.ProcessMemoryUtils;
import org.apache.flink.util.Preconditions;

public class JavaCmdTaskManagerDecorator
extends AbstractKubernetesStepDecorator {
    private final KubernetesTaskManagerParameters kubernetesTaskManagerParameters;

    public JavaCmdTaskManagerDecorator(KubernetesTaskManagerParameters kubernetesTaskManagerParameters) {
        this.kubernetesTaskManagerParameters = (KubernetesTaskManagerParameters)Preconditions.checkNotNull((Object)kubernetesTaskManagerParameters);
    }

    @Override
    public FlinkPod decorateFlinkPod(FlinkPod flinkPod) {
        Container mainContainerWithStartCmd = ((ContainerBuilder)((ContainerBuilder)new ContainerBuilder(flinkPod.getMainContainer()).withCommand(this.kubernetesTaskManagerParameters.getContainerEntrypoint())).withArgs(Arrays.asList("native-k8s", this.getTaskManagerStartCommand()))).build();
        return new FlinkPod.Builder(flinkPod).withMainContainer(mainContainerWithStartCmd).build();
    }

    private String getTaskManagerStartCommand() {
        String confDirInPod = this.kubernetesTaskManagerParameters.getFlinkConfDirInPod();
        String logDirInPod = this.kubernetesTaskManagerParameters.getFlinkLogDirInPod();
        String mainClassArgs = "--" + CommandLineOptions.CONFIG_DIR_OPTION.getLongOpt() + " " + confDirInPod + " " + this.kubernetesTaskManagerParameters.getDynamicProperties();
        return JavaCmdTaskManagerDecorator.getTaskManagerStartCommand(this.kubernetesTaskManagerParameters.getFlinkConfiguration(), this.kubernetesTaskManagerParameters.getContaineredTaskManagerParameters(), confDirInPod, logDirInPod, this.kubernetesTaskManagerParameters.hasLogback(), this.kubernetesTaskManagerParameters.hasLog4j(), KubernetesTaskExecutorRunner.class.getCanonicalName(), mainClassArgs);
    }

    private static String getTaskManagerStartCommand(Configuration flinkConfig, ContaineredTaskManagerParameters tmParams, String configDirectory, String logDirectory, boolean hasLogback, boolean hasLog4j, String mainClass, String mainArgs) {
        TaskExecutorProcessSpec taskExecutorProcessSpec = tmParams.getTaskExecutorProcessSpec();
        String jvmMemOpts = ProcessMemoryUtils.generateJvmParametersStr((ProcessMemorySpec)taskExecutorProcessSpec);
        String args = TaskExecutorProcessUtils.generateDynamicConfigsStr((TaskExecutorProcessSpec)taskExecutorProcessSpec);
        if (mainArgs != null) {
            args = args + " " + mainArgs;
        }
        return KubernetesUtils.getCommonStartCommand(flinkConfig, KubernetesUtils.ClusterComponent.TASK_MANAGER, jvmMemOpts, configDirectory, logDirectory, hasLogback, hasLog4j, mainClass, args);
    }
}

