/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.kubeclient.parameters;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.client.deployment.ClusterSpecification;
import org.apache.flink.configuration.BlobServerOptions;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ConfigurationUtils;
import org.apache.flink.configuration.JobManagerOptions;
import org.apache.flink.configuration.RestOptions;
import org.apache.flink.kubernetes.configuration.KubernetesConfigOptions;
import org.apache.flink.kubernetes.configuration.KubernetesConfigOptionsInternal;
import org.apache.flink.kubernetes.kubeclient.parameters.AbstractKubernetesParameters;
import org.apache.flink.kubernetes.utils.KubernetesUtils;
import org.apache.flink.runtime.jobmanager.HighAvailabilityMode;
import org.apache.flink.util.Preconditions;

public class KubernetesJobManagerParameters
extends AbstractKubernetesParameters {
    public static final String JOB_MANAGER_MAIN_CONTAINER_NAME = "flink-job-manager";
    private final ClusterSpecification clusterSpecification;

    public KubernetesJobManagerParameters(Configuration flinkConfig, ClusterSpecification clusterSpecification) {
        super(flinkConfig);
        this.clusterSpecification = (ClusterSpecification)Preconditions.checkNotNull((Object)clusterSpecification);
    }

    @Override
    public Map<String, String> getLabels() {
        HashMap labels = new HashMap();
        labels.putAll(this.flinkConfig.getOptional(KubernetesConfigOptions.JOB_MANAGER_LABELS).orElse(Collections.emptyMap()));
        labels.putAll(this.getCommonLabels());
        labels.put("component", "jobmanager");
        return Collections.unmodifiableMap(labels);
    }

    @Override
    public Map<String, String> getNodeSelector() {
        return Collections.unmodifiableMap(this.flinkConfig.getOptional(KubernetesConfigOptions.JOB_MANAGER_NODE_SELECTOR).orElse(Collections.emptyMap()));
    }

    @Override
    public Map<String, String> getEnvironments() {
        return ConfigurationUtils.getPrefixedKeyValuePairs((String)"containerized.master.env.", (Configuration)this.flinkConfig);
    }

    @Override
    public Map<String, String> getAnnotations() {
        return this.flinkConfig.getOptional(KubernetesConfigOptions.JOB_MANAGER_ANNOTATIONS).orElse(Collections.emptyMap());
    }

    @Override
    public List<Map<String, String>> getTolerations() {
        return this.flinkConfig.getOptional(KubernetesConfigOptions.JOB_MANAGER_TOLERATIONS).orElse(Collections.emptyList());
    }

    public List<Map<String, String>> getOwnerReference() {
        return this.flinkConfig.getOptional(KubernetesConfigOptions.JOB_MANAGER_OWNER_REFERENCE).orElse(Collections.emptyList());
    }

    public Map<String, String> getRestServiceAnnotations() {
        return this.flinkConfig.getOptional(KubernetesConfigOptions.REST_SERVICE_ANNOTATIONS).orElse(Collections.emptyMap());
    }

    public String getJobManagerMainContainerName() {
        return JOB_MANAGER_MAIN_CONTAINER_NAME;
    }

    public int getJobManagerMemoryMB() {
        return this.clusterSpecification.getMasterMemoryMB();
    }

    public double getJobManagerCPU() {
        return this.flinkConfig.getDouble(KubernetesConfigOptions.JOB_MANAGER_CPU);
    }

    public int getRestPort() {
        return this.flinkConfig.getInteger(RestOptions.PORT);
    }

    public int getRestBindPort() {
        return Integer.valueOf(this.flinkConfig.getString(RestOptions.BIND_PORT));
    }

    public int getRPCPort() {
        return this.flinkConfig.getInteger(JobManagerOptions.PORT);
    }

    public int getBlobServerPort() {
        int blobServerPort = KubernetesUtils.parsePort(this.flinkConfig, (ConfigOption<String>)BlobServerOptions.PORT);
        Preconditions.checkArgument((blobServerPort > 0 ? 1 : 0) != 0, (String)"%s should not be 0.", (Object[])new Object[]{BlobServerOptions.PORT.key()});
        return blobServerPort;
    }

    public String getServiceAccount() {
        return this.flinkConfig.getOptional(KubernetesConfigOptions.JOB_MANAGER_SERVICE_ACCOUNT).orElse(this.flinkConfig.getString(KubernetesConfigOptions.KUBERNETES_SERVICE_ACCOUNT));
    }

    public String getEntrypointClass() {
        String entrypointClass = this.flinkConfig.getString(KubernetesConfigOptionsInternal.ENTRY_POINT_CLASS);
        Preconditions.checkNotNull((Object)entrypointClass, (String)(KubernetesConfigOptionsInternal.ENTRY_POINT_CLASS + " must be specified!"));
        return entrypointClass;
    }

    public KubernetesConfigOptions.ServiceExposedType getRestServiceExposedType() {
        return (KubernetesConfigOptions.ServiceExposedType)((Object)this.flinkConfig.get(KubernetesConfigOptions.REST_SERVICE_EXPOSED_TYPE));
    }

    public boolean isInternalServiceEnabled() {
        return !HighAvailabilityMode.isHighAvailabilityModeActivated((Configuration)this.flinkConfig);
    }
}

