/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.kubeclient.parameters;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.TaskManagerOptions;
import org.apache.flink.kubernetes.configuration.KubernetesConfigOptions;
import org.apache.flink.kubernetes.kubeclient.parameters.AbstractKubernetesParameters;
import org.apache.flink.kubernetes.utils.KubernetesUtils;
import org.apache.flink.runtime.clusterframework.ContaineredTaskManagerParameters;
import org.apache.flink.util.Preconditions;

public class KubernetesTaskManagerParameters
extends AbstractKubernetesParameters {
    public static final String TASK_MANAGER_MAIN_CONTAINER_NAME = "flink-task-manager";
    private final String podName;
    private final String dynamicProperties;
    private final ContaineredTaskManagerParameters containeredTaskManagerParameters;
    private final Map<String, Long> taskManagerExternalResources;

    public KubernetesTaskManagerParameters(Configuration flinkConfig, String podName, String dynamicProperties, ContaineredTaskManagerParameters containeredTaskManagerParameters, Map<String, Long> taskManagerExternalResources) {
        super(flinkConfig);
        this.podName = (String)Preconditions.checkNotNull((Object)podName);
        this.dynamicProperties = (String)Preconditions.checkNotNull((Object)dynamicProperties);
        this.containeredTaskManagerParameters = (ContaineredTaskManagerParameters)Preconditions.checkNotNull((Object)containeredTaskManagerParameters);
        this.taskManagerExternalResources = (Map)Preconditions.checkNotNull(taskManagerExternalResources);
    }

    @Override
    public Map<String, String> getLabels() {
        HashMap labels = new HashMap();
        labels.putAll(this.flinkConfig.getOptional(KubernetesConfigOptions.TASK_MANAGER_LABELS).orElse(Collections.emptyMap()));
        labels.putAll(KubernetesUtils.getTaskManagerLabels(this.getClusterId()));
        return Collections.unmodifiableMap(labels);
    }

    @Override
    public Map<String, String> getNodeSelector() {
        return Collections.unmodifiableMap(this.flinkConfig.getOptional(KubernetesConfigOptions.TASK_MANAGER_NODE_SELECTOR).orElse(Collections.emptyMap()));
    }

    @Override
    public Map<String, String> getEnvironments() {
        return this.containeredTaskManagerParameters.taskManagerEnv();
    }

    @Override
    public Map<String, String> getAnnotations() {
        return this.flinkConfig.getOptional(KubernetesConfigOptions.TASK_MANAGER_ANNOTATIONS).orElse(Collections.emptyMap());
    }

    @Override
    public List<Map<String, String>> getTolerations() {
        return this.flinkConfig.getOptional(KubernetesConfigOptions.TASK_MANAGER_TOLERATIONS).orElse(Collections.emptyList());
    }

    public String getTaskManagerMainContainerName() {
        return TASK_MANAGER_MAIN_CONTAINER_NAME;
    }

    public String getPodName() {
        return this.podName;
    }

    public int getTaskManagerMemoryMB() {
        return this.containeredTaskManagerParameters.getTaskExecutorProcessSpec().getTotalProcessMemorySize().getMebiBytes();
    }

    public double getTaskManagerCPU() {
        return this.containeredTaskManagerParameters.getTaskExecutorProcessSpec().getCpuCores().getValue().doubleValue();
    }

    public String getServiceAccount() {
        return this.flinkConfig.getOptional(KubernetesConfigOptions.TASK_MANAGER_SERVICE_ACCOUNT).orElse(this.flinkConfig.getString(KubernetesConfigOptions.KUBERNETES_SERVICE_ACCOUNT));
    }

    public Map<String, Long> getTaskManagerExternalResources() {
        return this.taskManagerExternalResources;
    }

    public int getRPCPort() {
        int taskManagerRpcPort = KubernetesUtils.parsePort(this.flinkConfig, (ConfigOption<String>)TaskManagerOptions.RPC_PORT);
        Preconditions.checkArgument((taskManagerRpcPort > 0 ? 1 : 0) != 0, (String)"%s should not be 0.", (Object[])new Object[]{TaskManagerOptions.RPC_PORT.key()});
        return taskManagerRpcPort;
    }

    public String getDynamicProperties() {
        return this.dynamicProperties;
    }

    public ContaineredTaskManagerParameters getContaineredTaskManagerParameters() {
        return this.containeredTaskManagerParameters;
    }
}

