/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.utils;

import io.fabric8.kubernetes.api.model.KubernetesResource;
import io.fabric8.kubernetes.api.model.Quantity;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import io.fabric8.kubernetes.api.model.ResourceRequirementsBuilder;
import java.io.File;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.flink.client.program.PackagedProgramUtils;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.CoreOptions;
import org.apache.flink.configuration.PipelineOptions;
import org.apache.flink.kubernetes.configuration.KubernetesConfigOptions;
import org.apache.flink.kubernetes.highavailability.KubernetesCheckpointStoreUtil;
import org.apache.flink.kubernetes.highavailability.KubernetesJobGraphStoreUtil;
import org.apache.flink.kubernetes.highavailability.KubernetesStateHandleStore;
import org.apache.flink.kubernetes.kubeclient.FlinkKubeClient;
import org.apache.flink.kubernetes.kubeclient.resources.KubernetesConfigMap;
import org.apache.flink.runtime.checkpoint.CheckpointStoreUtil;
import org.apache.flink.runtime.checkpoint.CompletedCheckpointStore;
import org.apache.flink.runtime.checkpoint.DefaultCompletedCheckpointStore;
import org.apache.flink.runtime.clusterframework.BootstrapTools;
import org.apache.flink.runtime.highavailability.HighAvailabilityServicesUtils;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.runtime.jobmanager.DefaultJobGraphStore;
import org.apache.flink.runtime.jobmanager.JobGraphStore;
import org.apache.flink.runtime.jobmanager.JobGraphStoreUtil;
import org.apache.flink.runtime.jobmanager.JobGraphStoreWatcher;
import org.apache.flink.runtime.jobmanager.NoOpJobGraphStoreWatcher;
import org.apache.flink.runtime.leaderelection.LeaderInformation;
import org.apache.flink.runtime.persistence.RetrievableStateStorageHelper;
import org.apache.flink.runtime.persistence.filesystem.FileSystemStateStorageHelper;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.dataformat.yaml.YAMLMapper;
import org.apache.flink.util.FlinkRuntimeException;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.function.FunctionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KubernetesUtils {
    private static final Logger LOG = LoggerFactory.getLogger(KubernetesUtils.class);
    private static final YAMLMapper yamlMapper = new YAMLMapper();

    public static void checkAndUpdatePortConfigOption(Configuration flinkConfig, ConfigOption<String> port, int fallbackPort) {
        if (KubernetesUtils.parsePort(flinkConfig, port) == 0) {
            flinkConfig.setString(port, String.valueOf(fallbackPort));
            LOG.info("Kubernetes deployment requires a fixed port. Configuration {} will be set to {}", (Object)port.key(), (Object)fallbackPort);
        }
    }

    public static Integer parsePort(Configuration flinkConfig, ConfigOption<String> port) {
        Preconditions.checkNotNull((Object)flinkConfig.get(port), (String)(port.key() + " should not be null."));
        try {
            return Integer.parseInt((String)flinkConfig.get(port));
        }
        catch (NumberFormatException ex) {
            throw new FlinkRuntimeException(port.key() + " should be specified to a fixed port. Do not support a range of ports.", (Throwable)ex);
        }
    }

    public static String getDeploymentName(String clusterId) {
        return clusterId;
    }

    public static Map<String, String> getTaskManagerLabels(String clusterId) {
        Map<String, String> labels = KubernetesUtils.getCommonLabels(clusterId);
        labels.put("component", "taskmanager");
        return Collections.unmodifiableMap(labels);
    }

    public static Map<String, String> getCommonLabels(String clusterId) {
        HashMap<String, String> commonLabels = new HashMap<String, String>();
        commonLabels.put("type", "flink-native-kubernetes");
        commonLabels.put("app", clusterId);
        return commonLabels;
    }

    public static Map<String, String> getConfigMapLabels(String clusterId, String type) {
        HashMap<String, String> labels = new HashMap<String, String>(KubernetesUtils.getCommonLabels(clusterId));
        labels.put("configmap-type", type);
        return Collections.unmodifiableMap(labels);
    }

    public static KubernetesConfigMap checkConfigMaps(List<KubernetesConfigMap> configMaps, String expectedConfigMapName) {
        assert (configMaps.size() == 1);
        assert (configMaps.get(0).getName().equals(expectedConfigMapName));
        return configMaps.get(0);
    }

    public static LeaderInformation getLeaderInformationFromConfigMap(KubernetesConfigMap configMap) {
        UUID sessionID;
        String leaderAddress = configMap.getData().get("address");
        String sessionIDStr = configMap.getData().get("sessionId");
        UUID uUID = sessionID = sessionIDStr == null ? null : UUID.fromString(sessionIDStr);
        if (leaderAddress == null && sessionIDStr == null) {
            return LeaderInformation.empty();
        }
        return LeaderInformation.known((UUID)sessionID, (String)leaderAddress);
    }

    public static JobGraphStore createJobGraphStore(Configuration configuration, FlinkKubeClient flinkKubeClient, String configMapName, String lockIdentity) throws Exception {
        KubernetesStateHandleStore<JobGraph> stateHandleStore = KubernetesUtils.createJobGraphStateHandleStore(configuration, flinkKubeClient, configMapName, lockIdentity);
        return new DefaultJobGraphStore(stateHandleStore, (JobGraphStoreWatcher)NoOpJobGraphStoreWatcher.INSTANCE, (JobGraphStoreUtil)KubernetesJobGraphStoreUtil.INSTANCE);
    }

    public static KubernetesStateHandleStore<JobGraph> createJobGraphStateHandleStore(Configuration configuration, FlinkKubeClient flinkKubeClient, String configMapName, String lockIdentity) throws Exception {
        FileSystemStateStorageHelper stateStorage = new FileSystemStateStorageHelper(HighAvailabilityServicesUtils.getClusterHighAvailableStoragePath((Configuration)configuration), "submittedJobGraph");
        return new KubernetesStateHandleStore<JobGraph>(flinkKubeClient, configMapName, (RetrievableStateStorageHelper<JobGraph>)stateStorage, k -> k.startsWith("jobGraph-"), lockIdentity);
    }

    public static CompletedCheckpointStore createCompletedCheckpointStore(Configuration configuration, FlinkKubeClient kubeClient, Executor executor, String configMapName, String lockIdentity, int maxNumberOfCheckpointsToRetain) throws Exception {
        FileSystemStateStorageHelper stateStorage = new FileSystemStateStorageHelper(HighAvailabilityServicesUtils.getClusterHighAvailableStoragePath((Configuration)configuration), "completedCheckpoint");
        KubernetesStateHandleStore stateHandleStore = new KubernetesStateHandleStore(kubeClient, configMapName, stateStorage, k -> k.startsWith("checkpointID-"), lockIdentity);
        return new DefaultCompletedCheckpointStore(maxNumberOfCheckpointsToRetain, stateHandleStore, (CheckpointStoreUtil)KubernetesCheckpointStoreUtil.INSTANCE, executor);
    }

    public static ResourceRequirements getResourceRequirements(int mem, double cpu, Map<String, Long> externalResources) {
        Quantity cpuQuantity = new Quantity(String.valueOf(cpu));
        Quantity memQuantity = new Quantity(mem + "Mi");
        ResourceRequirementsBuilder resourceRequirementsBuilder = (ResourceRequirementsBuilder)((ResourceRequirementsBuilder)((ResourceRequirementsBuilder)((ResourceRequirementsBuilder)new ResourceRequirementsBuilder().addToRequests("memory", memQuantity)).addToRequests("cpu", cpuQuantity)).addToLimits("memory", memQuantity)).addToLimits("cpu", cpuQuantity);
        for (Map.Entry<String, Long> externalResource : externalResources.entrySet()) {
            Quantity resourceQuantity = new Quantity(String.valueOf(externalResource.getValue()));
            ((ResourceRequirementsBuilder)resourceRequirementsBuilder.addToRequests(externalResource.getKey(), resourceQuantity)).addToLimits(externalResource.getKey(), resourceQuantity);
            LOG.info("Request external resource {} with config key {}.", (Object)resourceQuantity.getAmount(), (Object)externalResource.getKey());
        }
        return resourceRequirementsBuilder.build();
    }

    public static String getCommonStartCommand(Configuration flinkConfig, ClusterComponent mode, String jvmMemOpts, String configDirectory, String logDirectory, boolean hasLogback, boolean hasLog4j, String mainClass, @Nullable String mainArgs) {
        String logFileName;
        String opts;
        HashMap<String, String> startCommandValues = new HashMap<String, String>();
        startCommandValues.put("java", "$JAVA_HOME/bin/java");
        startCommandValues.put("classpath", "-classpath $FLINK_CLASSPATH");
        startCommandValues.put("jvmmem", jvmMemOpts);
        if (mode == ClusterComponent.JOB_MANAGER) {
            opts = KubernetesUtils.getJavaOpts(flinkConfig, (ConfigOption<String>)CoreOptions.FLINK_JM_JVM_OPTIONS);
            logFileName = "jobmanager";
        } else {
            opts = KubernetesUtils.getJavaOpts(flinkConfig, (ConfigOption<String>)CoreOptions.FLINK_TM_JVM_OPTIONS);
            logFileName = "taskmanager";
        }
        startCommandValues.put("jvmopts", opts);
        startCommandValues.put("logging", KubernetesUtils.getLogging(logDirectory + "/" + logFileName + ".log", configDirectory, hasLogback, hasLog4j));
        startCommandValues.put("class", mainClass);
        startCommandValues.put("args", mainArgs != null ? mainArgs : "");
        String commandTemplate = flinkConfig.getString(KubernetesConfigOptions.CONTAINER_START_COMMAND_TEMPLATE);
        return BootstrapTools.getStartCommand((String)commandTemplate, startCommandValues);
    }

    public static List<File> checkJarFileForApplicationMode(Configuration configuration) {
        return ((List)configuration.get(PipelineOptions.JARS)).stream().map(FunctionUtils.uncheckedFunction(uri -> {
            URI jarURI = PackagedProgramUtils.resolveURI((String)uri);
            if (jarURI.getScheme().equals("local") && jarURI.isAbsolute()) {
                return new File(jarURI.getPath());
            }
            throw new IllegalArgumentException("Only \"local\" is supported as schema for application mode. This assumes that the jar is located in the image, not the Flink client. An example of such path is: local:///opt/flink/examples/streaming/WindowJoin.jar");
        })).collect(Collectors.toList());
    }

    public static String tryToGetPrettyPrintYaml(KubernetesResource kubernetesResource) {
        try {
            return yamlMapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)kubernetesResource);
        }
        catch (Exception ex) {
            LOG.debug("Failed to get the pretty print yaml, fallback to {}", (Object)kubernetesResource, (Object)ex);
            return kubernetesResource.toString();
        }
    }

    private static String getJavaOpts(Configuration flinkConfig, ConfigOption<String> configOption) {
        String baseJavaOpts = flinkConfig.getString(CoreOptions.FLINK_JVM_OPTIONS);
        if (flinkConfig.getString(configOption).length() > 0) {
            return baseJavaOpts + " " + flinkConfig.getString(configOption);
        }
        return baseJavaOpts;
    }

    private static String getLogging(String logFile, String confDir, boolean hasLogback, boolean hasLog4j) {
        StringBuilder logging = new StringBuilder();
        if (hasLogback || hasLog4j) {
            logging.append("-Dlog.file=").append(logFile);
            if (hasLogback) {
                logging.append(" -Dlogback.configurationFile=file:").append(confDir).append("/").append("logback-console.xml");
            }
            if (hasLog4j) {
                logging.append(" -Dlog4j.configuration=file:").append(confDir).append("/").append("log4j-console.properties").append(" -Dlog4j.configurationFile=file:").append(confDir).append("/").append("log4j-console.properties");
            }
        }
        return logging.toString();
    }

    private KubernetesUtils() {
    }

    public static enum ClusterComponent {
        JOB_MANAGER,
        TASK_MANAGER;

    }
}

