/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.parquet;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.api.common.typeinfo.BasicArrayTypeInfo;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.PrimitiveArrayTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.MapTypeInfo;
import org.apache.flink.api.java.typeutils.ObjectArrayTypeInfo;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.core.fs.Path;
import org.apache.flink.formats.parquet.ParquetInputFormat;
import org.apache.flink.types.Row;
import org.apache.parquet.schema.MessageType;

public class ParquetMapInputFormat
extends ParquetInputFormat<Map> {
    public ParquetMapInputFormat(Path path, MessageType messageType) {
        super(path, messageType);
    }

    @Override
    protected Map convert(Row row) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        this.convert(map, row, this.getFieldTypes(), this.getFieldNames());
        return map;
    }

    private void convert(Map<String, Object> map, Row row, TypeInformation<?>[] fieldTypes, String[] fieldNames) {
        for (int i = 0; i < fieldNames.length; ++i) {
            if (row.getField(i) == null) continue;
            if (fieldTypes[i] instanceof BasicTypeInfo || fieldTypes[i] instanceof PrimitiveArrayTypeInfo || fieldTypes[i] instanceof BasicArrayTypeInfo) {
                map.put(fieldNames[i], row.getField(i));
                continue;
            }
            if (fieldTypes[i] instanceof RowTypeInfo) {
                HashMap<String, Object> nestedRow = new HashMap<String, Object>();
                RowTypeInfo nestedRowTypeInfo = (RowTypeInfo)fieldTypes[i];
                this.convert(nestedRow, (Row)row.getField(i), nestedRowTypeInfo.getFieldTypes(), nestedRowTypeInfo.getFieldNames());
                map.put(fieldNames[i], nestedRow);
                continue;
            }
            if (fieldTypes[i] instanceof MapTypeInfo) {
                HashMap<String, Object> nestedMap = new HashMap<String, Object>();
                MapTypeInfo mapTypeInfo = (MapTypeInfo)fieldTypes[i];
                this.convert(nestedMap, (Map)row.getField(i), mapTypeInfo);
                map.put(fieldNames[i], nestedMap);
                continue;
            }
            if (!(fieldTypes[i] instanceof ObjectArrayTypeInfo)) continue;
            ArrayList<Object> nestedObjectList = new ArrayList<Object>();
            ObjectArrayTypeInfo objectArrayTypeInfo = (ObjectArrayTypeInfo)fieldTypes[i];
            this.convert(nestedObjectList, (Row[])row.getField(i), objectArrayTypeInfo);
            map.put(fieldNames[i], nestedObjectList);
        }
    }

    private void convert(Map<String, Object> target, Map<String, Object> source, MapTypeInfo mapTypeInfo) {
        TypeInformation valueTypeInfp = mapTypeInfo.getValueTypeInfo();
        for (String key : source.keySet()) {
            if (valueTypeInfp instanceof RowTypeInfo) {
                HashMap<String, Object> nestedRow = new HashMap<String, Object>();
                this.convert(nestedRow, (Row)source.get(key), ((RowTypeInfo)valueTypeInfp).getFieldTypes(), ((RowTypeInfo)valueTypeInfp).getFieldNames());
                target.put(key, nestedRow);
                continue;
            }
            if (valueTypeInfp instanceof MapTypeInfo) {
                HashMap<String, Object> nestedMap = new HashMap<String, Object>();
                this.convert(nestedMap, (Map)source.get(key), (MapTypeInfo)valueTypeInfp);
                target.put(key, nestedMap);
                continue;
            }
            if (!(valueTypeInfp instanceof ObjectArrayTypeInfo)) continue;
            ArrayList<Object> nestedObjectList = new ArrayList<Object>();
            this.convert(nestedObjectList, (Object[])source.get(key), (ObjectArrayTypeInfo)valueTypeInfp);
            target.put(key, nestedObjectList);
        }
    }

    private void convert(List<Object> target, Object[] source, ObjectArrayTypeInfo objectArrayTypeInfo) {
        TypeInformation itemType = objectArrayTypeInfo.getComponentInfo();
        for (Object field : source) {
            if (itemType instanceof RowTypeInfo) {
                HashMap<String, Object> nestedRow = new HashMap<String, Object>();
                this.convert(nestedRow, (Row)field, ((RowTypeInfo)itemType).getFieldTypes(), ((RowTypeInfo)itemType).getFieldNames());
                target.add(nestedRow);
                continue;
            }
            if (itemType instanceof MapTypeInfo) {
                HashMap<String, Object> nestedMap = new HashMap<String, Object>();
                MapTypeInfo mapTypeInfo = (MapTypeInfo)itemType;
                this.convert(nestedMap, (Map)field, mapTypeInfo);
                target.add(nestedMap);
                continue;
            }
            if (!(itemType instanceof ObjectArrayTypeInfo)) continue;
            ArrayList<Object> nestedObjectList = new ArrayList<Object>();
            this.convert(nestedObjectList, (Row[])field, (ObjectArrayTypeInfo)itemType);
            target.add(nestedObjectList);
        }
    }
}

