/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.parquet.utils;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.flink.api.common.typeinfo.BasicArrayTypeInfo;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.SqlTimeTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeinfo.Types;
import org.apache.flink.api.java.typeutils.MapTypeInfo;
import org.apache.flink.api.java.typeutils.ObjectArrayTypeInfo;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.OriginalType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;
import org.apache.parquet.schema.Types;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParquetSchemaConverter {
    private static final Logger LOGGER = LoggerFactory.getLogger(ParquetSchemaConverter.class);
    public static final String MAP_VALUE = "value";
    public static final String LIST_ARRAY_TYPE = "array";
    public static final String LIST_ELEMENT = "element";
    public static final String LIST_GROUP_NAME = "list";
    public static final String MESSAGE_ROOT = "root";

    public static TypeInformation<?> fromParquetType(MessageType type) {
        return ParquetSchemaConverter.convertFields(type.getFields());
    }

    public static MessageType toParquetType(TypeInformation<?> typeInformation, boolean legacyMode) {
        return (MessageType)ParquetSchemaConverter.convertField(null, typeInformation, Type.Repetition.OPTIONAL, legacyMode);
    }

    private static TypeInformation<?> convertFields(List<Type> parquetFields) {
        ArrayList types = new ArrayList();
        ArrayList<String> names = new ArrayList<String>();
        for (Type field : parquetFields) {
            TypeInformation<?> subType = ParquetSchemaConverter.convertParquetTypeToTypeInfo(field);
            if (subType != null) {
                types.add(subType);
                names.add(field.getName());
                continue;
            }
            LOGGER.error("Parquet field {} in schema type {} can not be converted to Flink Internal Type", (Object)field.getName(), (Object)field.getOriginalType().name());
        }
        return new RowTypeInfo(types.toArray(new TypeInformation[0]), names.toArray(new String[0]));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static TypeInformation<?> convertParquetTypeToTypeInfo(Type fieldType) {
        if (fieldType.isPrimitive()) {
            OriginalType originalType = fieldType.getOriginalType();
            PrimitiveType primitiveType = fieldType.asPrimitiveType();
            switch (primitiveType.getPrimitiveTypeName()) {
                case BINARY: {
                    if (originalType == null) return BasicTypeInfo.STRING_TYPE_INFO;
                    switch (originalType) {
                        case DECIMAL: {
                            return BasicTypeInfo.BIG_DEC_TYPE_INFO;
                        }
                        case UTF8: 
                        case ENUM: 
                        case JSON: 
                        case BSON: {
                            return BasicTypeInfo.STRING_TYPE_INFO;
                        }
                    }
                    throw new UnsupportedOperationException("Unsupported original type : " + originalType.name() + " for primitive type BINARY");
                }
                case BOOLEAN: {
                    return BasicTypeInfo.BOOLEAN_TYPE_INFO;
                }
                case INT32: {
                    if (originalType == null) return BasicTypeInfo.INT_TYPE_INFO;
                    switch (originalType) {
                        case TIME_MICROS: 
                        case TIME_MILLIS: {
                            return SqlTimeTypeInfo.TIME;
                        }
                        case TIMESTAMP_MICROS: 
                        case TIMESTAMP_MILLIS: {
                            return SqlTimeTypeInfo.TIMESTAMP;
                        }
                        case DATE: {
                            return SqlTimeTypeInfo.DATE;
                        }
                        case UINT_8: 
                        case UINT_16: 
                        case UINT_32: {
                            return BasicTypeInfo.INT_TYPE_INFO;
                        }
                        case INT_8: {
                            return Types.BYTE;
                        }
                        case INT_16: {
                            return Types.SHORT;
                        }
                        case INT_32: {
                            return BasicTypeInfo.INT_TYPE_INFO;
                        }
                    }
                    throw new UnsupportedOperationException("Unsupported original type : " + originalType.name() + " for primitive type INT32");
                }
                case INT64: {
                    if (originalType == null) return BasicTypeInfo.LONG_TYPE_INFO;
                    switch (originalType) {
                        case TIME_MICROS: {
                            return SqlTimeTypeInfo.TIME;
                        }
                        case TIMESTAMP_MICROS: 
                        case TIMESTAMP_MILLIS: {
                            return SqlTimeTypeInfo.TIMESTAMP;
                        }
                        case DECIMAL: 
                        case INT_64: {
                            return BasicTypeInfo.LONG_TYPE_INFO;
                        }
                    }
                    throw new UnsupportedOperationException("Unsupported original type : " + originalType.name() + " for primitive type INT64");
                }
                case INT96: {
                    return SqlTimeTypeInfo.TIMESTAMP;
                }
                case FLOAT: {
                    return BasicTypeInfo.FLOAT_TYPE_INFO;
                }
                case DOUBLE: {
                    return BasicTypeInfo.DOUBLE_TYPE_INFO;
                }
                case FIXED_LEN_BYTE_ARRAY: {
                    if (originalType == null) return BasicTypeInfo.BIG_DEC_TYPE_INFO;
                    switch (originalType) {
                        case DECIMAL: {
                            return BasicTypeInfo.BIG_DEC_TYPE_INFO;
                        }
                    }
                    throw new UnsupportedOperationException("Unsupported original type : " + originalType.name() + " for primitive type FIXED_LEN_BYTE_ARRAY");
                }
                default: {
                    throw new UnsupportedOperationException("Unsupported schema: " + fieldType);
                }
            }
        }
        GroupType parquetGroupType = fieldType.asGroupType();
        OriginalType originalType = parquetGroupType.getOriginalType();
        if (originalType == null) return ParquetSchemaConverter.convertFields(parquetGroupType.getFields());
        switch (originalType) {
            case LIST: {
                if (parquetGroupType.getFieldCount() != 1) {
                    throw new UnsupportedOperationException("Invalid list type " + parquetGroupType);
                }
                Type repeatedType = parquetGroupType.getType(0);
                if (!repeatedType.isRepetition(Type.Repetition.REPEATED)) {
                    throw new UnsupportedOperationException("Invalid list type " + parquetGroupType);
                }
                if (repeatedType.isPrimitive()) {
                    return ParquetSchemaConverter.convertParquetPrimitiveListToFlinkArray(repeatedType);
                }
                GroupType elementType = repeatedType.asGroupType();
                if (elementType.getFieldCount() > 1) {
                    Type type;
                    Iterator iterator = elementType.getFields().iterator();
                    do {
                        if (!iterator.hasNext()) return ObjectArrayTypeInfo.getInfoFor(ParquetSchemaConverter.convertParquetTypeToTypeInfo((Type)elementType));
                    } while ((type = (Type)iterator.next()).isRepetition(Type.Repetition.REQUIRED));
                    throw new UnsupportedOperationException(String.format("List field [%s] in List [%s] has to be required. ", type.toString(), fieldType.getName()));
                }
                Type internalType = elementType.getType(0);
                if (internalType.isPrimitive()) {
                    return ParquetSchemaConverter.convertParquetPrimitiveListToFlinkArray(internalType);
                }
                GroupType tupleGroup = internalType.asGroupType();
                if (tupleGroup.getFieldCount() != 1 || !((Type)tupleGroup.getFields().get(0)).isRepetition(Type.Repetition.REQUIRED)) throw new UnsupportedOperationException(String.format("Unrecgonized List schema [%s] according to Parquet standard", parquetGroupType.toString()));
                return ObjectArrayTypeInfo.getInfoFor(ParquetSchemaConverter.convertParquetTypeToTypeInfo(internalType));
            }
            case MAP_KEY_VALUE: 
            case MAP: {
                if (parquetGroupType.getFieldCount() != 1) throw new UnsupportedOperationException("Invalid map type " + parquetGroupType);
                if (parquetGroupType.getType(0).isPrimitive()) {
                    throw new UnsupportedOperationException("Invalid map type " + parquetGroupType);
                }
                GroupType mapKeyValType = parquetGroupType.getType(0).asGroupType();
                if (!mapKeyValType.isRepetition(Type.Repetition.REPEATED)) throw new UnsupportedOperationException("The middle level of Map should be single field named key_value. Invalid map type " + parquetGroupType);
                if (mapKeyValType.getFieldCount() != 2) {
                    throw new UnsupportedOperationException("The middle level of Map should be single field named key_value. Invalid map type " + parquetGroupType);
                }
                Type keyType = mapKeyValType.getType(0);
                if (!keyType.isPrimitive()) throw new IllegalArgumentException("Map key type must be required binary (UTF8): " + keyType);
                if (!keyType.isRepetition(Type.Repetition.REQUIRED)) throw new IllegalArgumentException("Map key type must be required binary (UTF8): " + keyType);
                if (!keyType.asPrimitiveType().getPrimitiveTypeName().equals((Object)PrimitiveType.PrimitiveTypeName.BINARY)) throw new IllegalArgumentException("Map key type must be required binary (UTF8): " + keyType);
                if (!keyType.getOriginalType().equals((Object)OriginalType.UTF8)) {
                    throw new IllegalArgumentException("Map key type must be required binary (UTF8): " + keyType);
                }
                Type valueType = mapKeyValType.getType(1);
                return new MapTypeInfo((TypeInformation)BasicTypeInfo.STRING_TYPE_INFO, ParquetSchemaConverter.convertParquetTypeToTypeInfo(valueType));
            }
            default: {
                throw new UnsupportedOperationException("Unsupported schema: " + fieldType);
            }
        }
    }

    private static TypeInformation<?> convertParquetPrimitiveListToFlinkArray(Type type) {
        TypeInformation<?> flinkType = ParquetSchemaConverter.convertParquetTypeToTypeInfo(type);
        if (flinkType.isBasicType()) {
            return BasicArrayTypeInfo.getInfoFor(Array.newInstance(flinkType.getTypeClass(), 0).getClass());
        }
        return ObjectArrayTypeInfo.getInfoFor(flinkType);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Type convertField(String fieldName, TypeInformation<?> typeInfo, Type.Repetition inheritRepetition, boolean legacyMode) {
        void var4_26;
        Type.Repetition repetition;
        Object var4_4 = null;
        Type.Repetition repetition2 = repetition = inheritRepetition == null ? Type.Repetition.OPTIONAL : inheritRepetition;
        if (typeInfo instanceof BasicTypeInfo) {
            BasicTypeInfo basicTypeInfo = (BasicTypeInfo)typeInfo;
            if (basicTypeInfo.equals((Object)BasicTypeInfo.BIG_DEC_TYPE_INFO) || basicTypeInfo.equals((Object)BasicTypeInfo.BIG_INT_TYPE_INFO)) {
                Type type = (Type)((Types.PrimitiveBuilder)org.apache.parquet.schema.Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY, (Type.Repetition)repetition).as(OriginalType.DECIMAL)).named(fieldName);
                return var4_26;
            } else if (basicTypeInfo.equals((Object)BasicTypeInfo.INT_TYPE_INFO)) {
                Type type = (Type)((Types.PrimitiveBuilder)org.apache.parquet.schema.Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32, (Type.Repetition)repetition).as(OriginalType.INT_32)).named(fieldName);
                return var4_26;
            } else if (basicTypeInfo.equals((Object)BasicTypeInfo.DOUBLE_TYPE_INFO)) {
                Type type = (Type)org.apache.parquet.schema.Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.DOUBLE, (Type.Repetition)repetition).named(fieldName);
                return var4_26;
            } else if (basicTypeInfo.equals((Object)BasicTypeInfo.FLOAT_TYPE_INFO)) {
                Type type = (Type)org.apache.parquet.schema.Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.FLOAT, (Type.Repetition)repetition).named(fieldName);
                return var4_26;
            } else if (basicTypeInfo.equals((Object)BasicTypeInfo.LONG_TYPE_INFO)) {
                Type type = (Type)((Types.PrimitiveBuilder)org.apache.parquet.schema.Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64, (Type.Repetition)repetition).as(OriginalType.INT_64)).named(fieldName);
                return var4_26;
            } else if (basicTypeInfo.equals((Object)BasicTypeInfo.SHORT_TYPE_INFO)) {
                Type type = (Type)((Types.PrimitiveBuilder)org.apache.parquet.schema.Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32, (Type.Repetition)repetition).as(OriginalType.INT_16)).named(fieldName);
                return var4_26;
            } else if (basicTypeInfo.equals((Object)BasicTypeInfo.BYTE_TYPE_INFO)) {
                Type type = (Type)((Types.PrimitiveBuilder)org.apache.parquet.schema.Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32, (Type.Repetition)repetition).as(OriginalType.INT_8)).named(fieldName);
                return var4_26;
            } else if (basicTypeInfo.equals((Object)BasicTypeInfo.CHAR_TYPE_INFO)) {
                Type type = (Type)((Types.PrimitiveBuilder)org.apache.parquet.schema.Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY, (Type.Repetition)repetition).as(OriginalType.UTF8)).named(fieldName);
                return var4_26;
            } else if (basicTypeInfo.equals((Object)BasicTypeInfo.BOOLEAN_TYPE_INFO)) {
                Type type = (Type)org.apache.parquet.schema.Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BOOLEAN, (Type.Repetition)repetition).named(fieldName);
                return var4_26;
            } else {
                if (!basicTypeInfo.equals((Object)BasicTypeInfo.DATE_TYPE_INFO) && !basicTypeInfo.equals((Object)BasicTypeInfo.STRING_TYPE_INFO)) return var4_26;
                Type type = (Type)((Types.PrimitiveBuilder)org.apache.parquet.schema.Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY, (Type.Repetition)repetition).as(OriginalType.UTF8)).named(fieldName);
            }
            return var4_26;
        } else if (typeInfo instanceof MapTypeInfo) {
            MapTypeInfo mapTypeInfo = (MapTypeInfo)typeInfo;
            if (!mapTypeInfo.getKeyTypeInfo().equals((Object)BasicTypeInfo.STRING_TYPE_INFO)) throw new UnsupportedOperationException(String.format("Can not convert Flink MapTypeInfo %s to Parquet Map type as key has to be String", typeInfo.toString()));
            Type type = (Type)((Types.MapBuilder)org.apache.parquet.schema.Types.map((Type.Repetition)repetition).value(ParquetSchemaConverter.convertField(MAP_VALUE, mapTypeInfo.getValueTypeInfo(), Type.Repetition.OPTIONAL, legacyMode))).named(fieldName);
            return var4_26;
        } else if (typeInfo instanceof ObjectArrayTypeInfo) {
            ObjectArrayTypeInfo objectArrayTypeInfo = (ObjectArrayTypeInfo)typeInfo;
            GroupType componentGroup = (GroupType)ParquetSchemaConverter.convertField(LIST_ELEMENT, objectArrayTypeInfo.getComponentInfo(), Type.Repetition.REQUIRED, legacyMode);
            GroupType elementGroup = (GroupType)org.apache.parquet.schema.Types.repeatedGroup().named(LIST_ELEMENT);
            elementGroup = elementGroup.withNewFields(componentGroup.getFields());
            Type type = (Type)((Types.GroupBuilder)((Types.GroupBuilder)org.apache.parquet.schema.Types.buildGroup((Type.Repetition)repetition).addField((Type)elementGroup)).as(OriginalType.LIST)).named(fieldName);
            return var4_26;
        } else if (typeInfo instanceof BasicArrayTypeInfo) {
            BasicArrayTypeInfo basicArrayType = (BasicArrayTypeInfo)typeInfo;
            if (legacyMode) {
                Type listGroup = (Type)((Types.GroupBuilder)org.apache.parquet.schema.Types.repeatedGroup().addField(ParquetSchemaConverter.convertField(LIST_ELEMENT, basicArrayType.getComponentInfo(), Type.Repetition.REQUIRED, legacyMode))).named(LIST_GROUP_NAME);
                Type type = (Type)((Types.GroupBuilder)((Types.GroupBuilder)org.apache.parquet.schema.Types.buildGroup((Type.Repetition)repetition).addField(listGroup)).as(OriginalType.LIST)).named(fieldName);
                return var4_26;
            } else {
                PrimitiveType primitiveTyp = ParquetSchemaConverter.convertField(fieldName, basicArrayType.getComponentInfo(), Type.Repetition.REQUIRED, legacyMode).asPrimitiveType();
                Type type = (Type)((Types.GroupBuilder)((Types.GroupBuilder)((Types.PrimitiveBuilder)org.apache.parquet.schema.Types.buildGroup((Type.Repetition)repetition).repeated(primitiveTyp.getPrimitiveTypeName()).as(primitiveTyp.getOriginalType())).named(LIST_ARRAY_TYPE)).as(OriginalType.LIST)).named(fieldName);
            }
            return var4_26;
        } else if (typeInfo instanceof SqlTimeTypeInfo) {
            if (typeInfo.equals((Object)SqlTimeTypeInfo.DATE)) {
                Type type = (Type)((Types.PrimitiveBuilder)org.apache.parquet.schema.Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32, (Type.Repetition)repetition).as(OriginalType.DATE)).named(fieldName);
                return var4_26;
            } else if (typeInfo.equals((Object)SqlTimeTypeInfo.TIME)) {
                Type type = (Type)((Types.PrimitiveBuilder)org.apache.parquet.schema.Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32, (Type.Repetition)repetition).as(OriginalType.TIME_MILLIS)).named(fieldName);
                return var4_26;
            } else {
                if (!typeInfo.equals((Object)SqlTimeTypeInfo.TIMESTAMP)) throw new UnsupportedOperationException("Unsupported SqlTimeTypeInfo " + typeInfo.toString());
                Type type = (Type)((Types.PrimitiveBuilder)org.apache.parquet.schema.Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64, (Type.Repetition)repetition).as(OriginalType.TIMESTAMP_MILLIS)).named(fieldName);
            }
            return var4_26;
        } else {
            RowTypeInfo rowTypeInfo = (RowTypeInfo)typeInfo;
            ArrayList<Type> types = new ArrayList<Type>();
            String[] fieldNames = rowTypeInfo.getFieldNames();
            TypeInformation[] fieldTypes = rowTypeInfo.getFieldTypes();
            for (int i = 0; i < rowTypeInfo.getArity(); ++i) {
                types.add(ParquetSchemaConverter.convertField(fieldNames[i], fieldTypes[i], repetition, legacyMode));
            }
            if (fieldName == null) {
                MessageType messageType = new MessageType(MESSAGE_ROOT, types);
                return var4_26;
            } else {
                GroupType groupType = new GroupType(repetition, fieldName, types);
            }
        }
        return var4_26;
    }
}

