/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.flink.runtime.state.CheckpointStreamFactory;
import org.apache.flink.runtime.state.StreamStateHandle;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.ResourceGuard;

public abstract class NonClosingCheckpointOutputStream<T extends StreamStateHandle>
extends OutputStream {
    protected final CheckpointStreamFactory.CheckpointStateOutputStream delegate;
    private final ResourceGuard resourceGuard = new ResourceGuard();

    public NonClosingCheckpointOutputStream(CheckpointStreamFactory.CheckpointStateOutputStream delegate2) {
        this.delegate = (CheckpointStreamFactory.CheckpointStateOutputStream)((Object)Preconditions.checkNotNull((Object)((Object)delegate2)));
    }

    @Override
    public void flush() throws IOException {
        this.delegate.flush();
    }

    @Override
    public void write(int b) throws IOException {
        this.delegate.write(b);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.delegate.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.delegate.write(b, off, len);
    }

    @Override
    public void close() throws IOException {
    }

    public final ResourceGuard.Lease acquireLease() throws IOException {
        return this.resourceGuard.acquireResource();
    }

    CheckpointStreamFactory.CheckpointStateOutputStream getDelegate() {
        return this.delegate;
    }

    abstract T closeAndGetHandle() throws IOException;

    StreamStateHandle closeAndGetHandleAfterLeasesReleased() throws IOException {
        try {
            this.resourceGuard.closeInterruptibly();
            return this.delegate.closeAndGetHandle();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            this.delegate.closeAndGetHandle();
            throw new IOException("Interrupted while awaiting handle.", e);
        }
    }
}

