/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint;

import java.io.Serializable;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.checkpoint.CheckpointProperties;
import org.apache.flink.runtime.checkpoint.CompletedCheckpointStats;
import org.apache.flink.runtime.checkpoint.TaskState;
import org.apache.flink.runtime.checkpoint.savepoint.SavepointStore;
import org.apache.flink.runtime.jobgraph.JobStatus;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.state.StateUtil;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompletedCheckpoint
implements Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(CompletedCheckpoint.class);
    private static final long serialVersionUID = -8360248179615702014L;
    private final JobID job;
    private final long checkpointID;
    private final long timestamp;
    private final long duration;
    private final Map<JobVertexID, TaskState> taskStates;
    private final CheckpointProperties props;
    private final String externalPath;
    @Nullable
    private transient CompletedCheckpointStats.DiscardCallback discardCallback;

    public CompletedCheckpoint(JobID job, long checkpointID, long timestamp, long completionTimestamp, Map<JobVertexID, TaskState> taskStates) {
        this(job, checkpointID, timestamp, completionTimestamp, taskStates, CheckpointProperties.forStandardCheckpoint(), null);
    }

    public CompletedCheckpoint(JobID job, long checkpointID, long timestamp, long completionTimestamp, Map<JobVertexID, TaskState> taskStates, CheckpointProperties props, String externalPath) {
        Preconditions.checkArgument((checkpointID >= 0L ? 1 : 0) != 0);
        Preconditions.checkArgument((timestamp >= 0L ? 1 : 0) != 0);
        Preconditions.checkArgument((completionTimestamp >= 0L ? 1 : 0) != 0);
        this.job = (JobID)Preconditions.checkNotNull((Object)job);
        this.checkpointID = checkpointID;
        this.timestamp = timestamp;
        this.duration = completionTimestamp - timestamp;
        this.taskStates = (Map)Preconditions.checkNotNull(taskStates);
        this.props = (CheckpointProperties)Preconditions.checkNotNull((Object)props);
        this.externalPath = externalPath;
        if (props.externalizeCheckpoint() && externalPath == null) {
            throw new NullPointerException("Checkpoint properties say that the checkpoint should have been persisted, but missing external path.");
        }
    }

    public JobID getJobId() {
        return this.job;
    }

    public long getCheckpointID() {
        return this.checkpointID;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public long getDuration() {
        return this.duration;
    }

    public CheckpointProperties getProperties() {
        return this.props;
    }

    public boolean subsume() throws Exception {
        if (this.props.discardOnSubsumed()) {
            this.discard();
            return true;
        }
        return false;
    }

    public boolean discard(JobStatus jobStatus) throws Exception {
        if (jobStatus == JobStatus.FINISHED && this.props.discardOnJobFinished() || jobStatus == JobStatus.CANCELED && this.props.discardOnJobCancelled() || jobStatus == JobStatus.FAILED && this.props.discardOnJobFailed() || jobStatus == JobStatus.SUSPENDED && this.props.discardOnJobSuspended()) {
            this.discard();
            return true;
        }
        if (this.externalPath != null) {
            LOG.info("Persistent checkpoint with ID {} at '{}' not discarded.", (Object)this.checkpointID, (Object)this.externalPath);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void discard() throws Exception {
        try {
            if (this.externalPath != null) {
                SavepointStore.removeSavepoint(this.externalPath);
            }
            StateUtil.bestEffortDiscardAllStateObjects(this.taskStates.values());
        }
        finally {
            this.taskStates.clear();
            if (this.discardCallback != null) {
                this.discardCallback.notifyDiscardedCheckpoint();
            }
        }
    }

    public long getStateSize() {
        long result = 0L;
        for (TaskState taskState : this.taskStates.values()) {
            result += taskState.getStateSize();
        }
        return result;
    }

    public Map<JobVertexID, TaskState> getTaskStates() {
        return this.taskStates;
    }

    public TaskState getTaskState(JobVertexID jobVertexID) {
        return this.taskStates.get((Object)jobVertexID);
    }

    public String getExternalPath() {
        return this.externalPath;
    }

    void setDiscardCallback(@Nullable CompletedCheckpointStats.DiscardCallback discardCallback) {
        this.discardCallback = discardCallback;
    }

    public boolean equals(Object obj) {
        if (obj instanceof CompletedCheckpoint) {
            CompletedCheckpoint other = (CompletedCheckpoint)obj;
            return this.job.equals((Object)other.job) && this.checkpointID == other.checkpointID && this.timestamp == other.timestamp && this.duration == other.duration && this.taskStates.equals(other.taskStates);
        }
        return false;
    }

    public int hashCode() {
        return (int)(this.checkpointID ^ this.checkpointID >>> 32) + 31 * ((int)(this.timestamp ^ this.timestamp >>> 32) + 31 * ((int)(this.duration ^ this.duration >>> 32) + 31 * Objects.hash(this.job, this.taskStates)));
    }

    public String toString() {
        return String.format("Checkpoint %d @ %d for %s", this.checkpointID, this.timestamp, this.job);
    }
}

