/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint;

import java.util.Arrays;
import org.apache.flink.runtime.state.ChainedStateHandle;
import org.apache.flink.runtime.state.KeyGroupsStateHandle;
import org.apache.flink.runtime.state.OperatorStateHandle;
import org.apache.flink.runtime.state.StateObject;
import org.apache.flink.runtime.state.StateUtil;
import org.apache.flink.runtime.state.StreamStateHandle;
import org.apache.flink.util.Preconditions;

public class SubtaskState
implements StateObject {
    private static final long serialVersionUID = -2394696997971923995L;
    @Deprecated
    private final ChainedStateHandle<StreamStateHandle> legacyOperatorState;
    private final ChainedStateHandle<OperatorStateHandle> managedOperatorState;
    private final ChainedStateHandle<OperatorStateHandle> rawOperatorState;
    private final KeyGroupsStateHandle managedKeyedState;
    private final KeyGroupsStateHandle rawKeyedState;
    private final long stateSize;

    public SubtaskState(ChainedStateHandle<StreamStateHandle> legacyOperatorState, ChainedStateHandle<OperatorStateHandle> managedOperatorState, ChainedStateHandle<OperatorStateHandle> rawOperatorState, KeyGroupsStateHandle managedKeyedState, KeyGroupsStateHandle rawKeyedState) {
        this.legacyOperatorState = (ChainedStateHandle)Preconditions.checkNotNull(legacyOperatorState, (String)"State");
        this.managedOperatorState = managedOperatorState;
        this.rawOperatorState = rawOperatorState;
        this.managedKeyedState = managedKeyedState;
        this.rawKeyedState = rawKeyedState;
        try {
            long calculateStateSize = SubtaskState.getSizeNullSafe(legacyOperatorState);
            calculateStateSize += SubtaskState.getSizeNullSafe(managedOperatorState);
            calculateStateSize += SubtaskState.getSizeNullSafe(rawOperatorState);
            calculateStateSize += SubtaskState.getSizeNullSafe(managedKeyedState);
            this.stateSize = calculateStateSize += SubtaskState.getSizeNullSafe(rawKeyedState);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to get state size.", e);
        }
    }

    private static final long getSizeNullSafe(StateObject stateObject) throws Exception {
        return stateObject != null ? stateObject.getStateSize() : 0L;
    }

    @Deprecated
    public ChainedStateHandle<StreamStateHandle> getLegacyOperatorState() {
        return this.legacyOperatorState;
    }

    public ChainedStateHandle<OperatorStateHandle> getManagedOperatorState() {
        return this.managedOperatorState;
    }

    public ChainedStateHandle<OperatorStateHandle> getRawOperatorState() {
        return this.rawOperatorState;
    }

    public KeyGroupsStateHandle getManagedKeyedState() {
        return this.managedKeyedState;
    }

    public KeyGroupsStateHandle getRawKeyedState() {
        return this.rawKeyedState;
    }

    @Override
    public long getStateSize() {
        return this.stateSize;
    }

    @Override
    public void discardState() throws Exception {
        StateUtil.bestEffortDiscardAllStateObjects(Arrays.asList(this.legacyOperatorState, this.managedOperatorState, this.rawOperatorState, this.managedKeyedState, this.rawKeyedState));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SubtaskState that = (SubtaskState)o;
        if (this.stateSize != that.stateSize) {
            return false;
        }
        if (this.legacyOperatorState != null ? !this.legacyOperatorState.equals(that.legacyOperatorState) : that.legacyOperatorState != null) {
            return false;
        }
        if (this.managedOperatorState != null ? !this.managedOperatorState.equals(that.managedOperatorState) : that.managedOperatorState != null) {
            return false;
        }
        if (this.rawOperatorState != null ? !this.rawOperatorState.equals(that.rawOperatorState) : that.rawOperatorState != null) {
            return false;
        }
        if (this.managedKeyedState != null ? !this.managedKeyedState.equals(that.managedKeyedState) : that.managedKeyedState != null) {
            return false;
        }
        return this.rawKeyedState != null ? this.rawKeyedState.equals(that.rawKeyedState) : that.rawKeyedState == null;
    }

    public int hashCode() {
        int result = this.legacyOperatorState != null ? this.legacyOperatorState.hashCode() : 0;
        result = 31 * result + (this.managedOperatorState != null ? this.managedOperatorState.hashCode() : 0);
        result = 31 * result + (this.rawOperatorState != null ? this.rawOperatorState.hashCode() : 0);
        result = 31 * result + (this.managedKeyedState != null ? this.managedKeyedState.hashCode() : 0);
        result = 31 * result + (this.rawKeyedState != null ? this.rawKeyedState.hashCode() : 0);
        result = 31 * result + (int)(this.stateSize ^ this.stateSize >>> 32);
        return result;
    }

    public String toString() {
        return "SubtaskState{chainedStateHandle=" + this.legacyOperatorState + ", operatorStateFromBackend=" + this.managedOperatorState + ", operatorStateFromStream=" + this.rawOperatorState + ", keyedStateFromBackend=" + this.managedKeyedState + ", keyedStateHandleFromStream=" + this.rawKeyedState + ", stateSize=" + this.stateSize + '}';
    }
}

