/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.client;

import akka.actor.ActorRef;
import akka.actor.Props;
import akka.actor.Status;
import akka.dispatch.Futures;
import java.util.concurrent.Callable;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.akka.ListeningBehaviour;
import org.apache.flink.runtime.client.JobClientActor;
import org.apache.flink.runtime.client.JobClientActorRegistrationTimeoutException;
import org.apache.flink.runtime.leaderretrieval.LeaderRetrievalService;
import org.apache.flink.runtime.messages.JobClientMessages;
import org.apache.flink.runtime.messages.JobManagerMessages;
import scala.concurrent.ExecutionContext;
import scala.concurrent.duration.FiniteDuration;

public class JobAttachmentClientActor
extends JobClientActor {
    private JobID jobID;
    private boolean successfullyRegisteredForJob = false;

    public JobAttachmentClientActor(LeaderRetrievalService leaderRetrievalService, FiniteDuration timeout, boolean sysoutUpdates) {
        super(leaderRetrievalService, timeout, sysoutUpdates);
    }

    @Override
    public void connectedToJobManager() {
        if (this.jobID != null && !this.successfullyRegisteredForJob) {
            this.tryToAttachToJob();
        }
    }

    @Override
    protected Class getClientMessageClass() {
        return JobClientMessages.AttachToJobAndWait.class;
    }

    @Override
    public void handleCustomMessage(Object message) {
        if (message instanceof JobClientMessages.AttachToJobAndWait) {
            if (this.client == null) {
                this.jobID = ((JobClientMessages.AttachToJobAndWait)message).jobID();
                if (this.jobID == null) {
                    this.LOG.error("Received null JobID");
                    this.sender().tell(this.decorateMessage(new Status.Failure((Throwable)new Exception("JobID is null"))), this.getSelf());
                } else {
                    this.LOG.info("Received JobID {}.", (Object)this.jobID);
                    this.client = this.getSender();
                    if (this.jobManager != null) {
                        this.tryToAttachToJob();
                    }
                }
            } else {
                String msg = "Received repeated 'AttachToJobAndWait'";
                this.LOG.error(msg);
                this.getSender().tell(this.decorateMessage(new Status.Failure((Throwable)new Exception(msg))), ActorRef.noSender());
                this.terminate();
            }
        } else if (message instanceof JobManagerMessages.RegisterJobClientSuccess) {
            JobManagerMessages.RegisterJobClientSuccess msg = (JobManagerMessages.RegisterJobClientSuccess)message;
            this.logAndPrintMessage("Successfully registered at the JobManager for Job " + msg.jobId());
            this.successfullyRegisteredForJob = true;
        } else if (message instanceof JobManagerMessages.JobNotFound) {
            this.LOG.info("Couldn't register JobClient for JobID {}", (Object)((JobManagerMessages.JobNotFound)message).jobID());
            this.client.tell(this.decorateMessage(message), this.getSelf());
            this.terminate();
        } else if (JobClientMessages.getRegistrationTimeout().equals(message)) {
            if (!this.successfullyRegisteredForJob) {
                if (this.isClientConnected()) {
                    this.client.tell(this.decorateMessage(new Status.Failure((Throwable)new JobClientActorRegistrationTimeoutException("Registration for Job at the JobManager timed out. You may increase 'akka.client.timeout' in case the JobManager needs more time to confirm the job client registration."))), this.getSelf());
                }
                this.terminate();
            }
        } else {
            this.LOG.error("{} received unknown message: ", this.getClass());
        }
    }

    private void tryToAttachToJob() {
        this.LOG.info("Sending message to JobManager {} to attach to job {} and wait for progress", (Object)this.jobManager, (Object)this.jobID);
        Futures.future((Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                JobAttachmentClientActor.this.LOG.info("Attaching to job {} at the job manager {}.", (Object)JobAttachmentClientActor.this.jobID, (Object)JobAttachmentClientActor.this.jobManager.path());
                JobAttachmentClientActor.this.jobManager.tell(JobAttachmentClientActor.this.decorateMessage(new JobManagerMessages.RegisterJobClient(JobAttachmentClientActor.this.jobID, ListeningBehaviour.EXECUTION_RESULT_AND_STATE_CHANGES)), JobAttachmentClientActor.this.getSelf());
                JobAttachmentClientActor.this.getContext().system().scheduler().scheduleOnce(JobAttachmentClientActor.this.timeout, JobAttachmentClientActor.this.getSelf(), JobAttachmentClientActor.this.decorateMessage(JobClientMessages.getRegistrationTimeout()), (ExecutionContext)JobAttachmentClientActor.this.getContext().dispatcher(), ActorRef.noSender());
                return null;
            }
        }, (ExecutionContext)this.getContext().dispatcher());
    }

    public static Props createActorProps(LeaderRetrievalService leaderRetrievalService, FiniteDuration timeout, boolean sysoutUpdates) {
        return Props.create(JobAttachmentClientActor.class, (Object[])new Object[]{leaderRetrievalService, timeout, sysoutUpdates});
    }
}

