/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobgraph;

import java.util.List;
import org.apache.flink.api.common.io.InputFormat;
import org.apache.flink.api.common.operators.util.UserCodeWrapper;
import org.apache.flink.core.io.InputSplitSource;
import org.apache.flink.runtime.jobgraph.JobVertex;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.operators.util.TaskConfig;

public class InputFormatVertex
extends JobVertex {
    private static final long serialVersionUID = 1L;
    private String formatDescription;

    public InputFormatVertex(String name) {
        super(name);
    }

    public InputFormatVertex(String name, JobVertexID id) {
        super(name, id);
    }

    public InputFormatVertex(String name, JobVertexID id, List<JobVertexID> alternativeIds) {
        super(name, id, alternativeIds);
    }

    public void setFormatDescription(String formatDescription) {
        this.formatDescription = formatDescription;
    }

    public String getFormatDescription() {
        return this.formatDescription;
    }

    @Override
    public void initializeOnMaster(ClassLoader loader) throws Exception {
        InputFormat inputFormat;
        UserCodeWrapper wrapper;
        TaskConfig cfg = new TaskConfig(this.getConfiguration());
        try {
            wrapper = cfg.getStubWrapper(loader);
        }
        catch (Throwable t) {
            throw new Exception("Deserializing the InputFormat (" + this.formatDescription + ") failed: " + t.getMessage(), t);
        }
        if (wrapper == null) {
            throw new Exception("No input format present in InputFormatVertex's task configuration.");
        }
        try {
            inputFormat = (InputFormat)wrapper.getUserCodeObject(InputFormat.class, loader);
        }
        catch (Throwable t) {
            throw new Exception("Instantiating the InputFormat (" + this.formatDescription + ") failed: " + t.getMessage(), t);
        }
        Thread thread = Thread.currentThread();
        ClassLoader original = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(loader);
            inputFormat.configure(cfg.getStubParameters());
        }
        catch (Throwable t) {
            throw new Exception("Configuring the InputFormat (" + this.formatDescription + ") failed: " + t.getMessage(), t);
        }
        finally {
            thread.setContextClassLoader(original);
        }
        this.setInputSplitSource((InputSplitSource<?>)inputFormat);
    }
}

