/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state;

import java.util.ArrayList;
import org.apache.flink.api.common.state.ListState;
import org.apache.flink.api.common.state.ValueState;
import org.apache.flink.runtime.state.KvState;

public class GenericListState<N, T, W extends ValueState<ArrayList<T>> & KvState<N>>
implements ListState<T>,
KvState<N> {
    private final W wrappedState;

    public GenericListState(ValueState<ArrayList<T>> wrappedState) {
        if (!(wrappedState instanceof KvState)) {
            throw new IllegalArgumentException("Wrapped state must be a KvState.");
        }
        this.wrappedState = wrappedState;
    }

    @Override
    public void setCurrentNamespace(N namespace) {
        ((KvState)this.wrappedState).setCurrentNamespace(namespace);
    }

    @Override
    public byte[] getSerializedValue(byte[] serializedKeyAndNamespace) throws Exception {
        return ((KvState)this.wrappedState).getSerializedValue(serializedKeyAndNamespace);
    }

    public Iterable<T> get() throws Exception {
        return (Iterable)this.wrappedState.value();
    }

    public void add(T value) throws Exception {
        ArrayList<T> currentValue = (ArrayList<T>)this.wrappedState.value();
        if (currentValue == null) {
            currentValue = new ArrayList<T>();
            currentValue.add(value);
            this.wrappedState.update(currentValue);
        } else {
            currentValue.add(value);
            this.wrappedState.update(currentValue);
        }
    }

    public void clear() {
        this.wrappedState.clear();
    }
}

