/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.heap;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.runtime.state.KeyGroupRange;
import org.apache.flink.runtime.state.RegisteredBackendStateMetaInfo;

public class StateTable<K, N, ST> {
    protected RegisteredBackendStateMetaInfo<N, ST> metaInfo;
    private final List<Map<N, Map<K, ST>>> state;
    protected final KeyGroupRange keyGroupRange;

    public StateTable(RegisteredBackendStateMetaInfo<N, ST> metaInfo, KeyGroupRange keyGroupRange) {
        this.metaInfo = metaInfo;
        this.keyGroupRange = keyGroupRange;
        this.state = Arrays.asList(new Map[keyGroupRange.getNumberOfKeyGroups()]);
    }

    private int indexToOffset(int index) {
        return index - this.keyGroupRange.getStartKeyGroup();
    }

    public Map<N, Map<K, ST>> get(int index) {
        return this.keyGroupRange.contains(index) ? this.state.get(this.indexToOffset(index)) : null;
    }

    public void set(int index, Map<N, Map<K, ST>> map) {
        if (!this.keyGroupRange.contains(index)) {
            throw new RuntimeException("Unexpected key group index. This indicates a bug.");
        }
        this.state.set(this.indexToOffset(index), map);
    }

    public TypeSerializer<ST> getStateSerializer() {
        return this.metaInfo.getStateSerializer();
    }

    public TypeSerializer<N> getNamespaceSerializer() {
        return this.metaInfo.getNamespaceSerializer();
    }

    public RegisteredBackendStateMetaInfo<N, ST> getMetaInfo() {
        return this.metaInfo;
    }

    public void setMetaInfo(RegisteredBackendStateMetaInfo<N, ST> metaInfo) {
        this.metaInfo = metaInfo;
    }

    public List<Map<N, Map<K, ST>>> getState() {
        return this.state;
    }
}

