/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.taskmanager;

import java.io.Serializable;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.accumulators.AccumulatorSnapshot;
import org.apache.flink.runtime.execution.ExecutionState;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.runtime.executiongraph.IOMetrics;
import org.apache.flink.runtime.util.SerializedThrowable;

public class TaskExecutionState
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final JobID jobID;
    private final ExecutionAttemptID executionId;
    private final ExecutionState executionState;
    private final SerializedThrowable throwable;
    private final AccumulatorSnapshot accumulators;
    private final IOMetrics ioMetrics;

    public TaskExecutionState(JobID jobID, ExecutionAttemptID executionId, ExecutionState executionState) {
        this(jobID, executionId, executionState, null, null, null);
    }

    public TaskExecutionState(JobID jobID, ExecutionAttemptID executionId, ExecutionState executionState, Throwable error) {
        this(jobID, executionId, executionState, error, null, null);
    }

    public TaskExecutionState(JobID jobID, ExecutionAttemptID executionId, ExecutionState executionState, Throwable error, AccumulatorSnapshot accumulators, IOMetrics ioMetrics) {
        if (jobID == null || executionId == null || executionState == null) {
            throw new NullPointerException();
        }
        this.jobID = jobID;
        this.executionId = executionId;
        this.executionState = executionState;
        this.throwable = error != null ? new SerializedThrowable(error) : null;
        this.accumulators = accumulators;
        this.ioMetrics = ioMetrics;
    }

    public Throwable getError(ClassLoader userCodeClassloader) {
        if (this.throwable == null) {
            return null;
        }
        return this.throwable.deserializeError(userCodeClassloader);
    }

    public ExecutionAttemptID getID() {
        return this.executionId;
    }

    public ExecutionState getExecutionState() {
        return this.executionState;
    }

    public JobID getJobID() {
        return this.jobID;
    }

    public AccumulatorSnapshot getAccumulators() {
        return this.accumulators;
    }

    public IOMetrics getIOMetrics() {
        return this.ioMetrics;
    }

    public boolean equals(Object obj) {
        if (obj instanceof TaskExecutionState) {
            TaskExecutionState other = (TaskExecutionState)obj;
            return other.jobID.equals((Object)this.jobID) && other.executionId.equals((Object)this.executionId) && other.executionState == this.executionState && other.throwable == null == (this.throwable == null);
        }
        return false;
    }

    public int hashCode() {
        return this.jobID.hashCode() + this.executionId.hashCode() + this.executionState.ordinal();
    }

    public String toString() {
        return String.format("TaskState jobId=%s, jobID=%s, state=%s, error=%s", new Object[]{this.jobID, this.executionId, this.executionState, this.throwable == null ? "(null)" : this.throwable.toString()});
    }
}

