/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.taskmanager;

import org.apache.flink.api.common.JobID;
import org.apache.flink.core.io.InputSplit;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.runtime.instance.ActorGateway;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.jobgraph.tasks.InputSplitProvider;
import org.apache.flink.runtime.messages.JobManagerMessages;
import org.apache.flink.util.InstantiationUtil;
import org.apache.flink.util.Preconditions;
import scala.concurrent.Await;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;

public class TaskInputSplitProvider
implements InputSplitProvider {
    private final ActorGateway jobManager;
    private final JobID jobID;
    private final JobVertexID vertexID;
    private final ExecutionAttemptID executionID;
    private final FiniteDuration timeout;

    public TaskInputSplitProvider(ActorGateway jobManager, JobID jobID, JobVertexID vertexID, ExecutionAttemptID executionID, FiniteDuration timeout) {
        this.jobManager = (ActorGateway)Preconditions.checkNotNull((Object)jobManager);
        this.jobID = (JobID)Preconditions.checkNotNull((Object)jobID);
        this.vertexID = (JobVertexID)((Object)Preconditions.checkNotNull((Object)((Object)vertexID)));
        this.executionID = (ExecutionAttemptID)((Object)Preconditions.checkNotNull((Object)((Object)executionID)));
        this.timeout = (FiniteDuration)Preconditions.checkNotNull((Object)timeout);
    }

    @Override
    public InputSplit getNextInputSplit(ClassLoader userCodeClassLoader) {
        Preconditions.checkNotNull((Object)userCodeClassLoader);
        try {
            Future<Object> response = this.jobManager.ask(new JobManagerMessages.RequestNextInputSplit(this.jobID, this.vertexID, this.executionID), this.timeout);
            Object result = Await.result(response, (Duration)this.timeout);
            if (result instanceof JobManagerMessages.NextInputSplit) {
                JobManagerMessages.NextInputSplit nextInputSplit = (JobManagerMessages.NextInputSplit)result;
                byte[] serializedData = nextInputSplit.splitData();
                if (serializedData == null) {
                    return null;
                }
                Object deserialized = InstantiationUtil.deserializeObject((byte[])serializedData, (ClassLoader)userCodeClassLoader);
                return (InputSplit)deserialized;
            }
            throw new Exception("RequestNextInputSplit requires a response of type NextInputSplit. Instead response is of type " + result.getClass() + '.');
        }
        catch (Exception e) {
            throw new RuntimeException("Requesting the next InputSplit failed.", e);
        }
    }
}

