/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.util;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.jobmanager.JobManager;
import org.apache.flink.runtime.leaderretrieval.StandaloneLeaderRetrievalService;
import org.apache.flink.runtime.taskmanager.TaskManager;
import org.apache.flink.util.NetUtils;
import scala.Option;
import scala.Tuple3;

public final class StandaloneUtils {
    public static StandaloneLeaderRetrievalService createLeaderRetrievalService(Configuration configuration) throws UnknownHostException {
        return StandaloneUtils.createLeaderRetrievalService(configuration, false);
    }

    public static StandaloneLeaderRetrievalService createLeaderRetrievalService(Configuration configuration, boolean resolveInitialHostName) throws UnknownHostException {
        return StandaloneUtils.createLeaderRetrievalService(configuration, resolveInitialHostName, null);
    }

    public static StandaloneLeaderRetrievalService createLeaderRetrievalService(Configuration configuration, boolean resolveInitialHostName, String jobManagerName) throws UnknownHostException {
        Tuple3<String, String, Object> stringIntPair = TaskManager.getAndCheckJobManagerAddress(configuration);
        String protocol = (String)stringIntPair._1();
        String jobManagerHostname = (String)stringIntPair._2();
        int jobManagerPort = (Integer)stringIntPair._3();
        String hostPort = NetUtils.unresolvedHostAndPortToNormalizedString((String)jobManagerHostname, (int)jobManagerPort);
        if (resolveInitialHostName) {
            try {
                InetAddress.getByName(jobManagerHostname);
            }
            catch (UnknownHostException e) {
                throw new UnknownHostException("Cannot resolve the JobManager hostname '" + jobManagerHostname + "' specified in the configuration");
            }
        }
        String jobManagerAkkaUrl = JobManager.getRemoteJobManagerAkkaURL(protocol, hostPort, (Option<String>)Option.apply((Object)jobManagerName));
        return new StandaloneLeaderRetrievalService(jobManagerAkkaUrl);
    }

    private StandaloneUtils() {
        throw new RuntimeException();
    }
}

