/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.disk.iomanager;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.util.Preconditions;

public class BufferFileChannelReader {
    private final ByteBuffer header = ByteBuffer.allocateDirect(8);
    private final FileChannel fileChannel;

    BufferFileChannelReader(FileChannel fileChannel) {
        this.fileChannel = fileChannel;
    }

    public boolean readBufferFromFileChannel(Buffer buffer) throws IOException {
        Preconditions.checkArgument((this.fileChannel.size() - this.fileChannel.position() > 0L ? 1 : 0) != 0);
        this.header.clear();
        this.fileChannel.read(this.header);
        this.header.flip();
        boolean isBuffer = this.header.getInt() == 1;
        int size = this.header.getInt();
        if (size > buffer.getMaxCapacity()) {
            throw new IllegalStateException("Buffer is too small for data: " + buffer.getMaxCapacity() + " bytes available, but " + size + " needed. This is most likely due to an serialized event, which is larger than the buffer size.");
        }
        Preconditions.checkArgument((buffer.getSize() == 0 ? 1 : 0) != 0, (Object)"Buffer not empty");
        this.fileChannel.read(buffer.getNioBuffer(0, size));
        buffer.setSize(size);
        if (!isBuffer) {
            buffer.tagAsEvent();
        }
        return this.fileChannel.size() - this.fileChannel.position() == 0L;
    }
}

