/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.buffer;

import java.nio.ByteBuffer;
import javax.annotation.concurrent.NotThreadSafe;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.runtime.io.network.buffer.BufferConsumer;
import org.apache.flink.runtime.io.network.buffer.BufferRecycler;
import org.apache.flink.util.Preconditions;

@NotThreadSafe
public class BufferBuilder {
    private final MemorySegment memorySegment;
    private final BufferRecycler recycler;
    private final SettablePositionMarker positionMarker = new SettablePositionMarker();
    private boolean bufferConsumerCreated = false;

    public BufferBuilder(MemorySegment memorySegment, BufferRecycler recycler) {
        this.memorySegment = (MemorySegment)Preconditions.checkNotNull((Object)memorySegment);
        this.recycler = (BufferRecycler)Preconditions.checkNotNull((Object)recycler);
    }

    public BufferConsumer createBufferConsumer() {
        Preconditions.checkState((!this.bufferConsumerCreated ? 1 : 0) != 0, (Object)"There can not exists two BufferConsumer for one BufferBuilder");
        this.bufferConsumerCreated = true;
        return new BufferConsumer(this.memorySegment, this.recycler, this.positionMarker);
    }

    public int appendAndCommit(ByteBuffer source) {
        int writtenBytes = this.append(source);
        this.commit();
        return writtenBytes;
    }

    public int append(ByteBuffer source) {
        Preconditions.checkState((!this.isFinished() ? 1 : 0) != 0);
        int needed = source.remaining();
        int available = this.getMaxCapacity() - this.positionMarker.getCached();
        int toCopy = Math.min(needed, available);
        this.memorySegment.put(this.positionMarker.getCached(), source, toCopy);
        this.positionMarker.move(toCopy);
        return toCopy;
    }

    public void commit() {
        this.positionMarker.commit();
    }

    public int finish() {
        int writtenBytes = this.positionMarker.markFinished();
        this.commit();
        return writtenBytes;
    }

    public boolean isFinished() {
        return this.positionMarker.isFinished();
    }

    public boolean isFull() {
        Preconditions.checkState((this.positionMarker.getCached() <= this.getMaxCapacity() ? 1 : 0) != 0);
        return this.positionMarker.getCached() == this.getMaxCapacity();
    }

    public int getMaxCapacity() {
        return this.memorySegment.size();
    }

    private static class SettablePositionMarker
    implements PositionMarker {
        private volatile int position = 0;
        private int cachedPosition = 0;

        private SettablePositionMarker() {
        }

        @Override
        public int get() {
            return this.position;
        }

        public boolean isFinished() {
            return PositionMarker.isFinished(this.cachedPosition);
        }

        public int getCached() {
            return PositionMarker.getAbsolute(this.cachedPosition);
        }

        public int markFinished() {
            int currentPosition = this.getCached();
            int newValue = -currentPosition;
            if (newValue == 0) {
                newValue = Integer.MIN_VALUE;
            }
            this.set(newValue);
            return currentPosition;
        }

        public void move(int offset) {
            this.set(this.cachedPosition + offset);
        }

        public void set(int value) {
            this.cachedPosition = value;
        }

        public void commit() {
            this.position = this.cachedPosition;
        }
    }

    @ThreadSafe
    static interface PositionMarker {
        public static final int FINISHED_EMPTY = Integer.MIN_VALUE;

        public int get();

        public static boolean isFinished(int position) {
            return position < 0;
        }

        public static int getAbsolute(int position) {
            if (position == Integer.MIN_VALUE) {
                return 0;
            }
            return Math.abs(position);
        }
    }
}

