/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.metrics.util;

import akka.actor.ActorSystem;
import com.sun.management.OperatingSystemMXBean;
import java.lang.management.ClassLoadingMXBean;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryUsage;
import java.lang.management.ThreadMXBean;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.MetricOptions;
import org.apache.flink.metrics.Gauge;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.runtime.clusterframework.BootstrapTools;
import org.apache.flink.runtime.io.network.NetworkEnvironment;
import org.apache.flink.runtime.io.network.buffer.NetworkBufferPool;
import org.apache.flink.runtime.metrics.MetricRegistry;
import org.apache.flink.runtime.metrics.groups.JobManagerMetricGroup;
import org.apache.flink.runtime.metrics.groups.TaskManagerMetricGroup;
import org.apache.flink.runtime.metrics.util.SystemResourcesMetricsInitializer;
import org.apache.flink.runtime.taskmanager.TaskManagerLocation;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricUtils {
    private static final Logger LOG = LoggerFactory.getLogger(MetricUtils.class);
    private static final String METRIC_GROUP_STATUS_NAME = "Status";
    private static final String METRICS_ACTOR_SYSTEM_NAME = "flink-metrics";
    static final String METRIC_GROUP_HEAP_NAME = "Heap";
    static final String METRIC_GROUP_NONHEAP_NAME = "NonHeap";

    private MetricUtils() {
    }

    public static JobManagerMetricGroup instantiateJobManagerMetricGroup(MetricRegistry metricRegistry, String hostname, Optional<Time> systemResourceProbeInterval) {
        JobManagerMetricGroup jobManagerMetricGroup = new JobManagerMetricGroup(metricRegistry, hostname);
        MetricGroup statusGroup = jobManagerMetricGroup.addGroup(METRIC_GROUP_STATUS_NAME);
        MetricUtils.instantiateStatusMetrics(statusGroup);
        if (systemResourceProbeInterval.isPresent()) {
            SystemResourcesMetricsInitializer.instantiateSystemMetrics(jobManagerMetricGroup, systemResourceProbeInterval.get());
        }
        return jobManagerMetricGroup;
    }

    public static TaskManagerMetricGroup instantiateTaskManagerMetricGroup(MetricRegistry metricRegistry, TaskManagerLocation taskManagerLocation, NetworkEnvironment network, Optional<Time> systemResourceProbeInterval) {
        TaskManagerMetricGroup taskManagerMetricGroup = new TaskManagerMetricGroup(metricRegistry, taskManagerLocation.getHostname(), taskManagerLocation.getResourceID().toString());
        MetricGroup statusGroup = taskManagerMetricGroup.addGroup(METRIC_GROUP_STATUS_NAME);
        MetricUtils.instantiateStatusMetrics(statusGroup);
        MetricGroup networkGroup = statusGroup.addGroup("Network");
        MetricUtils.instantiateNetworkMetrics(networkGroup, network);
        if (systemResourceProbeInterval.isPresent()) {
            SystemResourcesMetricsInitializer.instantiateSystemMetrics(taskManagerMetricGroup, systemResourceProbeInterval.get());
        }
        return taskManagerMetricGroup;
    }

    public static void instantiateStatusMetrics(MetricGroup metricGroup) {
        MetricGroup jvm = metricGroup.addGroup("JVM");
        MetricUtils.instantiateClassLoaderMetrics(jvm.addGroup("ClassLoader"));
        MetricUtils.instantiateGarbageCollectorMetrics(jvm.addGroup("GarbageCollector"));
        MetricUtils.instantiateMemoryMetrics(jvm.addGroup("Memory"));
        MetricUtils.instantiateThreadMetrics(jvm.addGroup("Threads"));
        MetricUtils.instantiateCPUMetrics(jvm.addGroup("CPU"));
    }

    public static ActorSystem startMetricsActorSystem(Configuration configuration, String hostname, Logger logger) throws Exception {
        String portRange = configuration.getString(MetricOptions.QUERY_SERVICE_PORT);
        int threadPriority = configuration.getInteger(MetricOptions.QUERY_SERVICE_THREAD_PRIORITY);
        return BootstrapTools.startActorSystem(configuration, METRICS_ACTOR_SYSTEM_NAME, hostname, portRange, logger, (BootstrapTools.ActorSystemExecutorConfiguration)new BootstrapTools.FixedThreadPoolExecutorConfiguration(1, 1, threadPriority));
    }

    private static void instantiateNetworkMetrics(MetricGroup metrics, NetworkEnvironment network) {
        NetworkBufferPool networkBufferPool = network.getNetworkBufferPool();
        metrics.gauge("TotalMemorySegments", networkBufferPool::getTotalNumberOfMemorySegments);
        metrics.gauge("AvailableMemorySegments", networkBufferPool::getNumberOfAvailableMemorySegments);
    }

    private static void instantiateClassLoaderMetrics(MetricGroup metrics) {
        ClassLoadingMXBean mxBean = ManagementFactory.getClassLoadingMXBean();
        metrics.gauge("ClassesLoaded", mxBean::getTotalLoadedClassCount);
        metrics.gauge("ClassesUnloaded", mxBean::getUnloadedClassCount);
    }

    private static void instantiateGarbageCollectorMetrics(MetricGroup metrics) {
        List<GarbageCollectorMXBean> garbageCollectors = ManagementFactory.getGarbageCollectorMXBeans();
        for (GarbageCollectorMXBean garbageCollector : garbageCollectors) {
            MetricGroup gcGroup = metrics.addGroup(garbageCollector.getName());
            gcGroup.gauge("Count", garbageCollector::getCollectionCount);
            gcGroup.gauge("Time", garbageCollector::getCollectionTime);
        }
    }

    private static void instantiateMemoryMetrics(MetricGroup metrics) {
        MetricUtils.instantiateHeapMemoryMetrics(metrics.addGroup(METRIC_GROUP_HEAP_NAME));
        MetricUtils.instantiateNonHeapMemoryMetrics(metrics.addGroup(METRIC_GROUP_NONHEAP_NAME));
        MBeanServer con = ManagementFactory.getPlatformMBeanServer();
        String directBufferPoolName = "java.nio:type=BufferPool,name=direct";
        try {
            ObjectName directObjectName = new ObjectName("java.nio:type=BufferPool,name=direct");
            MetricGroup direct = metrics.addGroup("Direct");
            direct.gauge("Count", new AttributeGauge(con, directObjectName, "Count", -1L));
            direct.gauge("MemoryUsed", new AttributeGauge(con, directObjectName, "MemoryUsed", -1L));
            direct.gauge("TotalCapacity", new AttributeGauge(con, directObjectName, "TotalCapacity", -1L));
        }
        catch (MalformedObjectNameException e) {
            LOG.warn("Could not create object name {}.", (Object)"java.nio:type=BufferPool,name=direct", (Object)e);
        }
        String mappedBufferPoolName = "java.nio:type=BufferPool,name=mapped";
        try {
            ObjectName mappedObjectName = new ObjectName("java.nio:type=BufferPool,name=mapped");
            MetricGroup mapped = metrics.addGroup("Mapped");
            mapped.gauge("Count", new AttributeGauge(con, mappedObjectName, "Count", -1L));
            mapped.gauge("MemoryUsed", new AttributeGauge(con, mappedObjectName, "MemoryUsed", -1L));
            mapped.gauge("TotalCapacity", new AttributeGauge(con, mappedObjectName, "TotalCapacity", -1L));
        }
        catch (MalformedObjectNameException e) {
            LOG.warn("Could not create object name {}.", (Object)"java.nio:type=BufferPool,name=mapped", (Object)e);
        }
    }

    @VisibleForTesting
    static void instantiateHeapMemoryMetrics(MetricGroup metricGroup) {
        MetricUtils.instantiateMemoryUsageMetrics(metricGroup, () -> ManagementFactory.getMemoryMXBean().getHeapMemoryUsage());
    }

    @VisibleForTesting
    static void instantiateNonHeapMemoryMetrics(MetricGroup metricGroup) {
        MetricUtils.instantiateMemoryUsageMetrics(metricGroup, () -> ManagementFactory.getMemoryMXBean().getNonHeapMemoryUsage());
    }

    private static void instantiateMemoryUsageMetrics(MetricGroup metricGroup, Supplier<MemoryUsage> memoryUsageSupplier) {
        metricGroup.gauge("Used", () -> ((MemoryUsage)memoryUsageSupplier.get()).getUsed());
        metricGroup.gauge("Committed", () -> ((MemoryUsage)memoryUsageSupplier.get()).getCommitted());
        metricGroup.gauge("Max", () -> ((MemoryUsage)memoryUsageSupplier.get()).getMax());
    }

    private static void instantiateThreadMetrics(MetricGroup metrics) {
        ThreadMXBean mxBean = ManagementFactory.getThreadMXBean();
        metrics.gauge("Count", mxBean::getThreadCount);
    }

    private static void instantiateCPUMetrics(MetricGroup metrics) {
        try {
            OperatingSystemMXBean mxBean = (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();
            metrics.gauge("Load", mxBean::getProcessCpuLoad);
            metrics.gauge("Time", mxBean::getProcessCpuTime);
        }
        catch (Exception e) {
            LOG.warn("Cannot access com.sun.management.OperatingSystemMXBean.getProcessCpuLoad() - CPU load metrics will not be available.", (Throwable)e);
        }
    }

    private static final class AttributeGauge<T>
    implements Gauge<T> {
        private final MBeanServer server;
        private final ObjectName objectName;
        private final String attributeName;
        private final T errorValue;

        private AttributeGauge(MBeanServer server, ObjectName objectName, String attributeName, T errorValue) {
            this.server = (MBeanServer)Preconditions.checkNotNull((Object)server);
            this.objectName = (ObjectName)Preconditions.checkNotNull((Object)objectName);
            this.attributeName = (String)Preconditions.checkNotNull((Object)attributeName);
            this.errorValue = errorValue;
        }

        public T getValue() {
            try {
                return (T)this.server.getAttribute(this.objectName, this.attributeName);
            }
            catch (AttributeNotFoundException | InstanceNotFoundException | MBeanException | ReflectionException e) {
                LOG.warn("Could not read attribute {}.", (Object)this.attributeName, (Object)e);
                return this.errorValue;
            }
        }
    }
}

