/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rpc;

import javax.annotation.Nullable;
import org.apache.flink.runtime.rpc.RpcEndpoint;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MainThreadValidatorUtil {
    private static final Logger log = LoggerFactory.getLogger(MainThreadValidatorUtil.class);
    private final RpcEndpoint endpoint;

    public MainThreadValidatorUtil(RpcEndpoint endpoint) {
        this.endpoint = (RpcEndpoint)Preconditions.checkNotNull((Object)endpoint);
    }

    public void enterMainThread() {
        assert (this.endpoint.currentMainThread.compareAndSet(null, Thread.currentThread())) : "The RpcEndpoint has concurrent access from " + this.endpoint.currentMainThread.get();
    }

    public void exitMainThread() {
        assert (this.endpoint.currentMainThread.compareAndSet(Thread.currentThread(), null)) : "The RpcEndpoint has concurrent access from " + this.endpoint.currentMainThread.get();
    }

    public static boolean isRunningInExpectedThread(@Nullable Thread expected) {
        Thread actual = Thread.currentThread();
        if (expected != actual) {
            String violationMsg = "Violation of main thread constraint detected: expected <" + expected + "> but running in <" + actual + ">.";
            log.warn(violationMsg, (Throwable)new Exception(violationMsg));
            return false;
        }
        return true;
    }
}

