/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint;

import java.util.Collections;
import java.util.List;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.JobStatus;
import org.apache.flink.runtime.checkpoint.CheckpointCoordinator;
import org.apache.flink.runtime.checkpoint.CheckpointCoordinatorTestingUtils;
import org.apache.flink.runtime.checkpoint.CheckpointException;
import org.apache.flink.runtime.checkpoint.CheckpointMetrics;
import org.apache.flink.runtime.checkpoint.CompletedCheckpoint;
import org.apache.flink.runtime.checkpoint.CompletedCheckpointStore;
import org.apache.flink.runtime.checkpoint.OperatorSubtaskState;
import org.apache.flink.runtime.checkpoint.PendingCheckpoint;
import org.apache.flink.runtime.checkpoint.StateObjectCollection;
import org.apache.flink.runtime.checkpoint.TaskStateSnapshot;
import org.apache.flink.runtime.checkpoint.channel.InputChannelInfo;
import org.apache.flink.runtime.checkpoint.channel.ResultSubpartitionInfo;
import org.apache.flink.runtime.concurrent.ManuallyTriggeredScheduledExecutor;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.runtime.executiongraph.ExecutionVertex;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.jobgraph.OperatorID;
import org.apache.flink.runtime.messages.checkpoint.AcknowledgeCheckpoint;
import org.apache.flink.runtime.state.InputChannelStateHandle;
import org.apache.flink.runtime.state.KeyedStateHandle;
import org.apache.flink.runtime.state.OperatorStateHandle;
import org.apache.flink.runtime.state.OperatorStreamStateHandle;
import org.apache.flink.runtime.state.ResultSubpartitionStateHandle;
import org.apache.flink.runtime.state.StateObject;
import org.apache.flink.runtime.state.StreamStateHandle;
import org.apache.flink.util.TestLogger;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class CheckpointCoordinatorFailureTest
extends TestLogger {
    @Test
    public void testFailingCompletedCheckpointStoreAdd() throws Exception {
        JobID jid = new JobID();
        ManuallyTriggeredScheduledExecutor manuallyTriggeredScheduledExecutor = new ManuallyTriggeredScheduledExecutor();
        ExecutionAttemptID executionAttemptId = new ExecutionAttemptID();
        ExecutionVertex vertex = CheckpointCoordinatorTestingUtils.mockExecutionVertex(executionAttemptId);
        CheckpointCoordinator coord = new CheckpointCoordinatorTestingUtils.CheckpointCoordinatorBuilder().setJobId(jid).setTasks(new ExecutionVertex[]{vertex}).setCompletedCheckpointStore(new FailingCompletedCheckpointStore()).setTimer(manuallyTriggeredScheduledExecutor).build();
        coord.triggerCheckpoint(false);
        manuallyTriggeredScheduledExecutor.triggerAll();
        Assert.assertEquals((long)1L, (long)coord.getNumberOfPendingCheckpoints());
        PendingCheckpoint pendingCheckpoint = (PendingCheckpoint)coord.getPendingCheckpoints().values().iterator().next();
        Assert.assertFalse((boolean)pendingCheckpoint.isDiscarded());
        long checkpointId = (Long)coord.getPendingCheckpoints().keySet().iterator().next();
        KeyedStateHandle managedKeyedHandle = (KeyedStateHandle)Mockito.mock(KeyedStateHandle.class);
        KeyedStateHandle rawKeyedHandle = (KeyedStateHandle)Mockito.mock(KeyedStateHandle.class);
        OperatorStateHandle managedOpHandle = (OperatorStateHandle)Mockito.mock(OperatorStreamStateHandle.class);
        OperatorStateHandle rawOpHandle = (OperatorStateHandle)Mockito.mock(OperatorStreamStateHandle.class);
        InputChannelStateHandle inputChannelStateHandle = new InputChannelStateHandle(new InputChannelInfo(0, 1), (StreamStateHandle)Mockito.mock(StreamStateHandle.class), Collections.singletonList(1L));
        ResultSubpartitionStateHandle resultSubpartitionStateHandle = new ResultSubpartitionStateHandle(new ResultSubpartitionInfo(0, 1), (StreamStateHandle)Mockito.mock(StreamStateHandle.class), Collections.singletonList(1L));
        OperatorSubtaskState operatorSubtaskState = (OperatorSubtaskState)Mockito.spy((Object)new OperatorSubtaskState(managedOpHandle, rawOpHandle, managedKeyedHandle, rawKeyedHandle, StateObjectCollection.singleton((StateObject)inputChannelStateHandle), StateObjectCollection.singleton((StateObject)resultSubpartitionStateHandle)));
        TaskStateSnapshot subtaskState = (TaskStateSnapshot)Mockito.spy((Object)new TaskStateSnapshot());
        subtaskState.putSubtaskStateByOperatorID(new OperatorID(), operatorSubtaskState);
        Mockito.when((Object)subtaskState.getSubtaskStateByOperatorID(OperatorID.fromJobVertexID((JobVertexID)vertex.getJobvertexId()))).thenReturn((Object)operatorSubtaskState);
        AcknowledgeCheckpoint acknowledgeMessage = new AcknowledgeCheckpoint(jid, executionAttemptId, checkpointId, new CheckpointMetrics(), subtaskState);
        try {
            coord.receiveAcknowledgeMessage(acknowledgeMessage, "Unknown location");
            Assert.fail((String)"Expected a checkpoint exception because the completed checkpoint store could not store the completed checkpoint.");
        }
        catch (CheckpointException checkpointException) {
            // empty catch block
        }
        Assert.assertTrue((boolean)pendingCheckpoint.isDiscarded());
        ((OperatorSubtaskState)Mockito.verify((Object)operatorSubtaskState)).discardState();
        ((OperatorStateHandle)Mockito.verify(operatorSubtaskState.getManagedOperatorState().iterator().next())).discardState();
        ((OperatorStateHandle)Mockito.verify(operatorSubtaskState.getRawOperatorState().iterator().next())).discardState();
        ((KeyedStateHandle)Mockito.verify(operatorSubtaskState.getManagedKeyedState().iterator().next())).discardState();
        ((KeyedStateHandle)Mockito.verify(operatorSubtaskState.getRawKeyedState().iterator().next())).discardState();
        ((StreamStateHandle)Mockito.verify((Object)((InputChannelStateHandle)operatorSubtaskState.getInputChannelState().iterator().next()).getDelegate())).discardState();
        ((StreamStateHandle)Mockito.verify((Object)((ResultSubpartitionStateHandle)operatorSubtaskState.getResultSubpartitionState().iterator().next()).getDelegate())).discardState();
    }

    private static final class FailingCompletedCheckpointStore
    implements CompletedCheckpointStore {
        private FailingCompletedCheckpointStore() {
        }

        public void recover() throws Exception {
            throw new UnsupportedOperationException("Not implemented.");
        }

        public void addCheckpoint(CompletedCheckpoint checkpoint) throws Exception {
            throw new Exception("The failing completed checkpoint store failed again... :-(");
        }

        public CompletedCheckpoint getLatestCheckpoint(boolean isPreferCheckpointForRecovery) throws Exception {
            throw new UnsupportedOperationException("Not implemented.");
        }

        public void shutdown(JobStatus jobStatus) throws Exception {
            throw new UnsupportedOperationException("Not implemented.");
        }

        public List<CompletedCheckpoint> getAllCheckpoints() throws Exception {
            throw new UnsupportedOperationException("Not implemented.");
        }

        public int getNumberOfRetainedCheckpoints() {
            return -1;
        }

        public int getMaxNumberOfRetainedCheckpoints() {
            return 1;
        }

        public boolean requiresExternalizedCheckpoints() {
            return false;
        }
    }
}

