/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.JobStatus;
import org.apache.flink.runtime.checkpoint.CheckpointProperties;
import org.apache.flink.runtime.checkpoint.CheckpointRetentionPolicy;
import org.apache.flink.runtime.checkpoint.CompletedCheckpoint;
import org.apache.flink.runtime.checkpoint.CompletedCheckpointStore;
import org.apache.flink.runtime.checkpoint.CompletedCheckpointStoreTest;
import org.apache.flink.runtime.checkpoint.OperatorState;
import org.apache.flink.runtime.checkpoint.StandaloneCompletedCheckpointStore;
import org.apache.flink.runtime.state.SharedStateRegistry;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;
import org.powermock.api.mockito.PowerMockito;

public class StandaloneCompletedCheckpointStoreTest
extends CompletedCheckpointStoreTest {
    @Override
    protected CompletedCheckpointStore createCompletedCheckpoints(int maxNumberOfCheckpointsToRetain) throws Exception {
        return new StandaloneCompletedCheckpointStore(maxNumberOfCheckpointsToRetain);
    }

    @Test
    public void testShutdownDiscardsCheckpoints() throws Exception {
        SharedStateRegistry sharedStateRegistry = new SharedStateRegistry();
        CompletedCheckpointStore store = this.createCompletedCheckpoints(1);
        CompletedCheckpointStoreTest.TestCompletedCheckpoint checkpoint = StandaloneCompletedCheckpointStoreTest.createCheckpoint(0L, sharedStateRegistry);
        Collection<OperatorState> operatorStates = checkpoint.getOperatorStates().values();
        store.addCheckpoint((CompletedCheckpoint)checkpoint);
        Assert.assertEquals((long)1L, (long)store.getNumberOfRetainedCheckpoints());
        this.verifyCheckpointRegistered(operatorStates, sharedStateRegistry);
        store.shutdown(JobStatus.FINISHED);
        Assert.assertEquals((long)0L, (long)store.getNumberOfRetainedCheckpoints());
        Assert.assertTrue((boolean)checkpoint.isDiscarded());
        StandaloneCompletedCheckpointStoreTest.verifyCheckpointDiscarded(operatorStates);
    }

    @Test
    public void testSuspendDiscardsCheckpoints() throws Exception {
        SharedStateRegistry sharedStateRegistry = new SharedStateRegistry();
        CompletedCheckpointStore store = this.createCompletedCheckpoints(1);
        CompletedCheckpointStoreTest.TestCompletedCheckpoint checkpoint = StandaloneCompletedCheckpointStoreTest.createCheckpoint(0L, sharedStateRegistry);
        Collection<OperatorState> taskStates = checkpoint.getOperatorStates().values();
        store.addCheckpoint((CompletedCheckpoint)checkpoint);
        Assert.assertEquals((long)1L, (long)store.getNumberOfRetainedCheckpoints());
        this.verifyCheckpointRegistered(taskStates, sharedStateRegistry);
        store.shutdown(JobStatus.SUSPENDED);
        Assert.assertEquals((long)0L, (long)store.getNumberOfRetainedCheckpoints());
        Assert.assertTrue((boolean)checkpoint.isDiscarded());
        StandaloneCompletedCheckpointStoreTest.verifyCheckpointDiscarded(taskStates);
    }

    @Test
    public void testAddCheckpointWithFailedRemove() throws Exception {
        boolean numCheckpointsToRetain = true;
        CompletedCheckpointStore store = this.createCompletedCheckpoints(1);
        for (long i = 0L; i <= 1L; ++i) {
            CompletedCheckpoint checkpointToAdd = (CompletedCheckpoint)PowerMockito.mock(CompletedCheckpoint.class);
            ((CompletedCheckpoint)PowerMockito.doReturn((Object)i).when((Object)checkpointToAdd)).getCheckpointID();
            ((CompletedCheckpoint)PowerMockito.doReturn(Collections.emptyMap()).when((Object)checkpointToAdd)).getOperatorStates();
            ((CompletedCheckpoint)PowerMockito.doThrow((Throwable)new IOException()).when((Object)checkpointToAdd)).discardOnSubsume();
            try {
                store.addCheckpoint(checkpointToAdd);
                List addedCheckpoints = store.getAllCheckpoints();
                Assert.assertTrue((boolean)addedCheckpoints.contains(checkpointToAdd));
                continue;
            }
            catch (Exception e) {
                List addedCheckpoints = store.getAllCheckpoints();
                Assert.assertFalse((boolean)addedCheckpoints.contains(checkpointToAdd));
            }
        }
    }

    @Test
    public void testPreferCheckpointWithoutSavepoint() throws Exception {
        StandaloneCompletedCheckpointStore store = new StandaloneCompletedCheckpointStore(5);
        JobID jobId = new JobID();
        store.addCheckpoint(StandaloneCompletedCheckpointStoreTest.checkpoint(jobId, 1L));
        store.addCheckpoint(StandaloneCompletedCheckpointStoreTest.checkpoint(jobId, 2L));
        store.addCheckpoint(StandaloneCompletedCheckpointStoreTest.checkpoint(jobId, 3L));
        CompletedCheckpoint latestCheckpoint = store.getLatestCheckpoint(true);
        MatcherAssert.assertThat((Object)latestCheckpoint.getCheckpointID(), (Matcher)CoreMatchers.equalTo((Object)3L));
    }

    @Test
    public void testPreferCheckpointWithSavepoint() throws Exception {
        StandaloneCompletedCheckpointStore store = new StandaloneCompletedCheckpointStore(5);
        JobID jobId = new JobID();
        store.addCheckpoint(StandaloneCompletedCheckpointStoreTest.checkpoint(jobId, 1L));
        store.addCheckpoint(StandaloneCompletedCheckpointStoreTest.savepoint(jobId, 2L));
        store.addCheckpoint(StandaloneCompletedCheckpointStoreTest.savepoint(jobId, 3L));
        CompletedCheckpoint latestCheckpoint = store.getLatestCheckpoint(true);
        MatcherAssert.assertThat((Object)latestCheckpoint.getCheckpointID(), (Matcher)CoreMatchers.equalTo((Object)1L));
    }

    @Test
    public void testPreferCheckpointWithOnlySavepoint() throws Exception {
        StandaloneCompletedCheckpointStore store = new StandaloneCompletedCheckpointStore(5);
        JobID jobId = new JobID();
        store.addCheckpoint(StandaloneCompletedCheckpointStoreTest.savepoint(jobId, 1L));
        store.addCheckpoint(StandaloneCompletedCheckpointStoreTest.savepoint(jobId, 2L));
        CompletedCheckpoint latestCheckpoint = store.getLatestCheckpoint(true);
        MatcherAssert.assertThat((Object)latestCheckpoint.getCheckpointID(), (Matcher)CoreMatchers.equalTo((Object)2L));
    }

    private static CompletedCheckpoint checkpoint(JobID jobId, long checkpointId) {
        return new CompletedCheckpointStoreTest.TestCompletedCheckpoint(jobId, checkpointId, checkpointId, Collections.emptyMap(), CheckpointProperties.forCheckpoint((CheckpointRetentionPolicy)CheckpointRetentionPolicy.RETAIN_ON_FAILURE));
    }

    private static CompletedCheckpoint savepoint(JobID jobId, long checkpointId) {
        return new CompletedCheckpointStoreTest.TestCompletedCheckpoint(jobId, checkpointId, checkpointId, Collections.emptyMap(), CheckpointProperties.forSavepoint((boolean)true));
    }
}

