/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.clusterframework.types;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import org.apache.flink.runtime.clusterframework.types.AllocationID;
import org.apache.flink.runtime.clusterframework.types.LocationPreferenceSlotSelectionStrategyTest;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.runtime.clusterframework.types.SlotProfile;
import org.apache.flink.runtime.jobmaster.slotpool.PreviousAllocationSlotSelectionStrategy;
import org.apache.flink.runtime.jobmaster.slotpool.SlotSelectionStrategy;
import org.junit.Assert;
import org.junit.Test;

public class PreviousAllocationSlotSelectionStrategyTest
extends LocationPreferenceSlotSelectionStrategyTest {
    public PreviousAllocationSlotSelectionStrategyTest() {
        super((SlotSelectionStrategy)PreviousAllocationSlotSelectionStrategy.create());
    }

    @Test
    public void matchPreviousAllocationOverridesPreferredLocation() {
        SlotProfile slotProfile = SlotProfile.priorAllocation((ResourceProfile)this.resourceProfile, (ResourceProfile)this.resourceProfile, Collections.singletonList(this.tml2), Collections.singleton(this.aid3), Collections.emptySet());
        Optional<SlotSelectionStrategy.SlotInfoAndLocality> match = this.runMatching(slotProfile);
        Assert.assertEquals((Object)this.slotInfo3, (Object)match.get().getSlotInfo());
        slotProfile = SlotProfile.priorAllocation((ResourceProfile)this.resourceProfile, (ResourceProfile)this.resourceProfile, Arrays.asList(this.tmlX, this.tml1), new HashSet<AllocationID>(Arrays.asList(this.aidX, this.aid2)), Collections.emptySet());
        match = this.runMatching(slotProfile);
        Assert.assertEquals((Object)this.slotInfo2, (Object)match.get().getSlotInfo());
    }

    @Test
    public void matchPreviousLocationNotAvailableButByLocality() {
        SlotProfile slotProfile = SlotProfile.priorAllocation((ResourceProfile)this.resourceProfile, (ResourceProfile)this.resourceProfile, Collections.singletonList(this.tml4), Collections.singleton(this.aidX), Collections.emptySet());
        Optional<SlotSelectionStrategy.SlotInfoAndLocality> match = this.runMatching(slotProfile);
        Assert.assertEquals((Object)this.slotInfo4, (Object)match.get().getSlotInfo());
    }

    @Test
    public void matchPreviousLocationNotAvailableAndAllOthersBlacklisted() {
        HashSet<AllocationID> blacklisted = new HashSet<AllocationID>(4);
        blacklisted.add(this.aid1);
        blacklisted.add(this.aid2);
        blacklisted.add(this.aid3);
        blacklisted.add(this.aid4);
        SlotProfile slotProfile = SlotProfile.priorAllocation((ResourceProfile)this.resourceProfile, (ResourceProfile)this.resourceProfile, Collections.singletonList(this.tml4), Collections.singletonList(this.aidX), blacklisted);
        Optional<SlotSelectionStrategy.SlotInfoAndLocality> match = this.runMatching(slotProfile);
        Assert.assertFalse((boolean)match.isPresent());
    }

    @Test
    public void matchPreviousLocationNotAvailableAndSomeOthersBlacklisted() {
        HashSet<AllocationID> blacklisted = new HashSet<AllocationID>(3);
        blacklisted.add(this.aid1);
        blacklisted.add(this.aid3);
        blacklisted.add(this.aid4);
        SlotProfile slotProfile = SlotProfile.priorAllocation((ResourceProfile)this.resourceProfile, (ResourceProfile)this.resourceProfile, Collections.singletonList(this.tml4), Collections.singletonList(this.aidX), blacklisted);
        Optional<SlotSelectionStrategy.SlotInfoAndLocality> match = this.runMatching(slotProfile);
        Assert.assertEquals((Object)this.slotInfo2, (Object)match.get().getSlotInfo());
    }
}

