/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.deployment;

import java.io.IOException;
import java.io.Serializable;
import java.net.InetSocketAddress;
import org.apache.flink.core.testutils.CommonTestUtils;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.deployment.ResultPartitionDeploymentDescriptor;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.runtime.io.network.ConnectionID;
import org.apache.flink.runtime.io.network.partition.ResultPartitionID;
import org.apache.flink.runtime.io.network.partition.ResultPartitionType;
import org.apache.flink.runtime.jobgraph.IntermediateDataSetID;
import org.apache.flink.runtime.jobgraph.IntermediateResultPartitionID;
import org.apache.flink.runtime.shuffle.NettyShuffleDescriptor;
import org.apache.flink.runtime.shuffle.PartitionDescriptor;
import org.apache.flink.runtime.shuffle.ShuffleDescriptor;
import org.apache.flink.runtime.shuffle.UnknownShuffleDescriptor;
import org.apache.flink.util.TestLogger;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class ResultPartitionDeploymentDescriptorTest
extends TestLogger {
    private static final IntermediateDataSetID resultId = new IntermediateDataSetID();
    private static final int numberOfPartitions = 5;
    private static final IntermediateResultPartitionID partitionId = new IntermediateResultPartitionID();
    private static final ExecutionAttemptID producerExecutionId = new ExecutionAttemptID();
    private static final ResultPartitionType partitionType = ResultPartitionType.PIPELINED;
    private static final int numberOfSubpartitions = 24;
    private static final int connectionIndex = 10;
    private static final PartitionDescriptor partitionDescriptor = new PartitionDescriptor(resultId, 5, partitionId, partitionType, 24, 10);
    private static final ResultPartitionID resultPartitionID = new ResultPartitionID(partitionId, producerExecutionId);
    private static final ResourceID producerLocation = new ResourceID("producerLocation");
    private static final InetSocketAddress address = new InetSocketAddress("localhost", 10000);
    private static final ConnectionID connectionID = new ConnectionID(address, 10);

    @Test
    public void testSerializationOfUnknownShuffleDescriptor() throws IOException {
        UnknownShuffleDescriptor shuffleDescriptor = new UnknownShuffleDescriptor(resultPartitionID);
        ShuffleDescriptor shuffleDescriptorCopy = (ShuffleDescriptor)CommonTestUtils.createCopySerializable((Serializable)shuffleDescriptor);
        Assert.assertThat((Object)shuffleDescriptorCopy, (Matcher)Matchers.instanceOf(UnknownShuffleDescriptor.class));
        Assert.assertThat((Object)shuffleDescriptorCopy.getResultPartitionID(), (Matcher)Matchers.is((Object)resultPartitionID));
        Assert.assertThat((Object)shuffleDescriptorCopy.isUnknown(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void testSerializationWithNettyShuffleDescriptor() throws IOException {
        NettyShuffleDescriptor shuffleDescriptor = new NettyShuffleDescriptor(producerLocation, (NettyShuffleDescriptor.PartitionConnectionInfo)new NettyShuffleDescriptor.NetworkPartitionConnectionInfo(connectionID), resultPartitionID);
        ResultPartitionDeploymentDescriptor copy = ResultPartitionDeploymentDescriptorTest.createCopyAndVerifyResultPartitionDeploymentDescriptor((ShuffleDescriptor)shuffleDescriptor);
        Assert.assertThat((Object)copy.getShuffleDescriptor(), (Matcher)Matchers.instanceOf(NettyShuffleDescriptor.class));
        NettyShuffleDescriptor shuffleDescriptorCopy = (NettyShuffleDescriptor)copy.getShuffleDescriptor();
        Assert.assertThat((Object)shuffleDescriptorCopy.getResultPartitionID(), (Matcher)Matchers.is((Object)resultPartitionID));
        Assert.assertThat((Object)shuffleDescriptorCopy.isUnknown(), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)shuffleDescriptorCopy.isLocalTo(producerLocation), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)shuffleDescriptorCopy.getConnectionId(), (Matcher)Matchers.is((Object)connectionID));
    }

    private static ResultPartitionDeploymentDescriptor createCopyAndVerifyResultPartitionDeploymentDescriptor(ShuffleDescriptor shuffleDescriptor) throws IOException {
        ResultPartitionDeploymentDescriptor orig = new ResultPartitionDeploymentDescriptor(partitionDescriptor, shuffleDescriptor, 24, true);
        ResultPartitionDeploymentDescriptor copy = (ResultPartitionDeploymentDescriptor)CommonTestUtils.createCopySerializable((Serializable)orig);
        ResultPartitionDeploymentDescriptorTest.verifyResultPartitionDeploymentDescriptorCopy(copy);
        return copy;
    }

    private static void verifyResultPartitionDeploymentDescriptorCopy(ResultPartitionDeploymentDescriptor copy) {
        Assert.assertThat((Object)copy.getResultId(), (Matcher)Matchers.is((Object)resultId));
        Assert.assertThat((Object)copy.getTotalNumberOfPartitions(), (Matcher)Matchers.is((Object)5));
        Assert.assertThat((Object)copy.getPartitionId(), (Matcher)Matchers.is((Object)partitionId));
        Assert.assertThat((Object)copy.getPartitionType(), (Matcher)Matchers.is((Object)partitionType));
        Assert.assertThat((Object)copy.getNumberOfSubpartitions(), (Matcher)Matchers.is((Object)24));
        Assert.assertThat((Object)copy.sendScheduleOrUpdateConsumersMessage(), (Matcher)Matchers.is((Object)true));
    }
}

