/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.executiongraph;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.flink.api.common.JobStatus;
import org.apache.flink.runtime.concurrent.ComponentMainThreadExecutor;
import org.apache.flink.runtime.concurrent.ComponentMainThreadExecutorServiceAdapter;
import org.apache.flink.runtime.execution.ExecutionState;
import org.apache.flink.runtime.execution.SuppressRestartsException;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.runtime.executiongraph.ExecutionGraph;
import org.apache.flink.runtime.executiongraph.ExecutionVertex;
import org.apache.flink.runtime.executiongraph.TestRestartStrategy;
import org.apache.flink.runtime.executiongraph.TestingExecutionGraphBuilder;
import org.apache.flink.runtime.executiongraph.TestingSlotProvider;
import org.apache.flink.runtime.executiongraph.metrics.RestartTimeGauge;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.runtime.jobgraph.JobVertex;
import org.apache.flink.runtime.jobmaster.TestingLogicalSlot;
import org.apache.flink.runtime.jobmaster.TestingLogicalSlotBuilder;
import org.apache.flink.runtime.taskmanager.TaskExecutionState;
import org.apache.flink.runtime.testtasks.NoOpInvokable;
import org.apache.flink.util.TestLogger;
import org.junit.Assert;
import org.junit.Test;

public class ExecutionGraphMetricsTest
extends TestLogger {
    private final ComponentMainThreadExecutor mainThreadExecutor = ComponentMainThreadExecutorServiceAdapter.forMainThread();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExecutionGraphRestartTimeMetric() throws Exception {
        ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
        try {
            long currentRestartingTime;
            int i;
            int parallelism = 1;
            JobVertex jobVertex = new JobVertex("TestVertex");
            jobVertex.setParallelism(parallelism);
            jobVertex.setInvokableClass(NoOpInvokable.class);
            JobGraph jobGraph = new JobGraph("Test Job", new JobVertex[]{jobVertex});
            CompletableFuture<TestingLogicalSlot> slotFuture1 = CompletableFuture.completedFuture(new TestingLogicalSlotBuilder().createTestingLogicalSlot());
            CompletableFuture<TestingLogicalSlot> slotFuture2 = CompletableFuture.completedFuture(new TestingLogicalSlotBuilder().createTestingLogicalSlot());
            ArrayDeque<CompletableFuture<TestingLogicalSlot>> slotFutures = new ArrayDeque<CompletableFuture<TestingLogicalSlot>>();
            slotFutures.addLast(slotFuture1);
            slotFutures.addLast(slotFuture2);
            TestRestartStrategy testingRestartStrategy = TestRestartStrategy.manuallyTriggered();
            ExecutionGraph executionGraph = TestingExecutionGraphBuilder.newBuilder().setJobGraph(jobGraph).setFutureExecutor(executor).setIoExecutor(executor).setRestartStrategy(testingRestartStrategy).setSlotProvider(new TestingSlotProvider(ignore -> (CompletableFuture)slotFutures.removeFirst())).build();
            executionGraph.start(this.mainThreadExecutor);
            RestartTimeGauge restartingTime = new RestartTimeGauge(executionGraph);
            Assert.assertEquals((long)0L, (long)restartingTime.getValue());
            executionGraph.scheduleForExecution();
            Assert.assertEquals((long)0L, (long)restartingTime.getValue());
            ArrayList<ExecutionAttemptID> executionIDs = new ArrayList<ExecutionAttemptID>();
            for (ExecutionVertex executionVertex : executionGraph.getAllExecutionVertices()) {
                executionIDs.add(executionVertex.getCurrentExecutionAttempt().getAttemptId());
            }
            for (ExecutionAttemptID executionID : executionIDs) {
                executionGraph.updateState(new TaskExecutionState(jobGraph.getJobID(), executionID, ExecutionState.RUNNING));
            }
            Assert.assertEquals((Object)JobStatus.RUNNING, (Object)executionGraph.getState());
            Assert.assertEquals((long)0L, (long)restartingTime.getValue());
            Thread.sleep(1L);
            for (ExecutionAttemptID executionID : executionIDs) {
                executionGraph.updateState(new TaskExecutionState(jobGraph.getJobID(), executionID, ExecutionState.FAILED, (Throwable)new Exception()));
            }
            Assert.assertEquals((Object)JobStatus.RESTARTING, (Object)executionGraph.getState());
            long firstRestartingTimestamp = executionGraph.getStatusTimestamp(JobStatus.RESTARTING);
            long previousRestartingTime = restartingTime.getValue();
            for (int i2 = 0; i2 < 2; ++i2) {
                Thread.sleep(1L);
                long currentRestartingTime2 = restartingTime.getValue();
                Assert.assertTrue((currentRestartingTime2 >= previousRestartingTime ? 1 : 0) != 0);
                previousRestartingTime = currentRestartingTime2;
            }
            Assert.assertTrue((previousRestartingTime > 0L ? 1 : 0) != 0);
            testingRestartStrategy.triggerAll().join();
            executionIDs.clear();
            for (ExecutionVertex executionVertex : executionGraph.getAllExecutionVertices()) {
                executionIDs.add(executionVertex.getCurrentExecutionAttempt().getAttemptId());
            }
            for (ExecutionAttemptID executionID : executionIDs) {
                executionGraph.updateState(new TaskExecutionState(jobGraph.getJobID(), executionID, ExecutionState.RUNNING));
            }
            Assert.assertEquals((Object)JobStatus.RUNNING, (Object)executionGraph.getState());
            Assert.assertTrue((firstRestartingTimestamp != 0L ? 1 : 0) != 0);
            previousRestartingTime = restartingTime.getValue();
            for (int i3 = 0; i3 < 2; ++i3) {
                long currentRestartingTime3 = restartingTime.getValue();
                Assert.assertTrue((currentRestartingTime3 == previousRestartingTime ? 1 : 0) != 0);
                previousRestartingTime = currentRestartingTime3;
            }
            Thread.sleep(1L);
            for (ExecutionAttemptID executionID : executionIDs) {
                executionGraph.updateState(new TaskExecutionState(jobGraph.getJobID(), executionID, ExecutionState.FAILED, (Throwable)new Exception()));
            }
            Assert.assertEquals((Object)JobStatus.RESTARTING, (Object)executionGraph.getState());
            long secondRestartingTimestamp = executionGraph.getStatusTimestamp(JobStatus.RESTARTING);
            Assert.assertTrue((firstRestartingTimestamp != secondRestartingTimestamp ? 1 : 0) != 0);
            previousRestartingTime = restartingTime.getValue();
            for (i = 0; i < 2; ++i) {
                Thread.sleep(1L);
                currentRestartingTime = restartingTime.getValue();
                Assert.assertTrue((currentRestartingTime >= previousRestartingTime ? 1 : 0) != 0);
                previousRestartingTime = currentRestartingTime;
            }
            Assert.assertTrue((previousRestartingTime > 0L ? 1 : 0) != 0);
            executionGraph.failGlobal((Throwable)new SuppressRestartsException((Throwable)new Exception()));
            Assert.assertEquals((Object)JobStatus.FAILED, (Object)executionGraph.getState());
            previousRestartingTime = restartingTime.getValue();
            for (i = 0; i < 10; ++i) {
                currentRestartingTime = restartingTime.getValue();
                Assert.assertTrue((currentRestartingTime == previousRestartingTime ? 1 : 0) != 0);
                previousRestartingTime = currentRestartingTime;
            }
        }
        finally {
            executor.shutdownNow();
        }
    }
}

