/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.executiongraph;

import java.net.InetAddress;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.Nonnull;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.JobStatus;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.metrics.groups.UnregisteredMetricsGroup;
import org.apache.flink.runtime.blob.BlobWriter;
import org.apache.flink.runtime.blob.VoidBlobWriter;
import org.apache.flink.runtime.checkpoint.CheckpointRecoveryFactory;
import org.apache.flink.runtime.checkpoint.StandaloneCheckpointRecoveryFactory;
import org.apache.flink.runtime.clusterframework.types.AllocationID;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.concurrent.ComponentMainThreadExecutorServiceAdapter;
import org.apache.flink.runtime.execution.ExecutionState;
import org.apache.flink.runtime.executiongraph.Execution;
import org.apache.flink.runtime.executiongraph.ExecutionGraph;
import org.apache.flink.runtime.executiongraph.ExecutionGraphBuilder;
import org.apache.flink.runtime.executiongraph.ExecutionJobVertex;
import org.apache.flink.runtime.executiongraph.ExecutionVertex;
import org.apache.flink.runtime.executiongraph.InteractionsCountingTaskManagerGateway;
import org.apache.flink.runtime.executiongraph.ProgrammedSlotProvider;
import org.apache.flink.runtime.executiongraph.TestingSlotProvider;
import org.apache.flink.runtime.executiongraph.restart.NoRestartStrategy;
import org.apache.flink.runtime.executiongraph.restart.RestartStrategy;
import org.apache.flink.runtime.executiongraph.utils.SimpleAckingTaskManagerGateway;
import org.apache.flink.runtime.instance.SimpleSlotContext;
import org.apache.flink.runtime.io.network.partition.JobMasterPartitionTracker;
import org.apache.flink.runtime.io.network.partition.NoOpJobMasterPartitionTracker;
import org.apache.flink.runtime.io.network.partition.ResultPartitionType;
import org.apache.flink.runtime.jobgraph.DistributionPattern;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.runtime.jobgraph.JobVertex;
import org.apache.flink.runtime.jobgraph.ScheduleMode;
import org.apache.flink.runtime.jobmanager.scheduler.Locality;
import org.apache.flink.runtime.jobmanager.slots.DummySlotOwner;
import org.apache.flink.runtime.jobmanager.slots.TaskManagerGateway;
import org.apache.flink.runtime.jobmanager.slots.TestingSlotOwner;
import org.apache.flink.runtime.jobmaster.LogicalSlot;
import org.apache.flink.runtime.jobmaster.SlotContext;
import org.apache.flink.runtime.jobmaster.SlotOwner;
import org.apache.flink.runtime.jobmaster.SlotRequestId;
import org.apache.flink.runtime.jobmaster.TestingLogicalSlot;
import org.apache.flink.runtime.jobmaster.TestingLogicalSlotBuilder;
import org.apache.flink.runtime.jobmaster.slotpool.SingleLogicalSlot;
import org.apache.flink.runtime.jobmaster.slotpool.SlotProvider;
import org.apache.flink.runtime.shuffle.NettyShuffleMaster;
import org.apache.flink.runtime.shuffle.ShuffleMaster;
import org.apache.flink.runtime.taskmanager.TaskManagerLocation;
import org.apache.flink.runtime.testtasks.NoOpInvokable;
import org.apache.flink.runtime.testutils.DirectScheduledExecutorService;
import org.apache.flink.util.FlinkException;
import org.apache.flink.util.TestLogger;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;

public class ExecutionGraphSchedulingTest
extends TestLogger {
    private final ScheduledExecutorService executor = new DirectScheduledExecutorService();

    @After
    public void shutdown() {
        this.executor.shutdownNow();
    }

    @Test
    public void testScheduleSourceBeforeTarget() throws Exception {
        boolean parallelism = true;
        JobVertex sourceVertex = new JobVertex("source");
        sourceVertex.setParallelism(1);
        sourceVertex.setInvokableClass(NoOpInvokable.class);
        JobVertex targetVertex = new JobVertex("target");
        targetVertex.setParallelism(1);
        targetVertex.setInvokableClass(NoOpInvokable.class);
        targetVertex.connectNewDataSetAsInput(sourceVertex, DistributionPattern.ALL_TO_ALL, ResultPartitionType.PIPELINED);
        JobID jobId = new JobID();
        JobGraph jobGraph = new JobGraph(jobId, "test", new JobVertex[]{sourceVertex, targetVertex});
        jobGraph.setScheduleMode(ScheduleMode.EAGER);
        CompletableFuture<LogicalSlot> sourceFuture = new CompletableFuture<LogicalSlot>();
        CompletableFuture<LogicalSlot> targetFuture = new CompletableFuture<LogicalSlot>();
        ProgrammedSlotProvider slotProvider = new ProgrammedSlotProvider(1);
        slotProvider.addSlot(sourceVertex.getID(), 0, sourceFuture);
        slotProvider.addSlot(targetVertex.getID(), 0, targetFuture);
        ExecutionGraph eg = this.createExecutionGraph(jobGraph, (SlotProvider)slotProvider);
        eg.start(ComponentMainThreadExecutorServiceAdapter.forMainThread());
        InteractionsCountingTaskManagerGateway gatewaySource = ExecutionGraphSchedulingTest.createTaskManager();
        InteractionsCountingTaskManagerGateway gatewayTarget = ExecutionGraphSchedulingTest.createTaskManager();
        TestingLogicalSlot sourceSlot = this.createTestingLogicalSlot(gatewaySource);
        TestingLogicalSlot targetSlot = this.createTestingLogicalSlot(gatewayTarget);
        eg.scheduleForExecution();
        Assert.assertEquals((Object)JobStatus.RUNNING, (Object)eg.getState());
        targetFuture.complete(targetSlot);
        Assert.assertThat((Object)gatewayTarget.getSubmitTaskCount(), (Matcher)Matchers.is((Object)0));
        Assert.assertEquals((Object)JobStatus.RUNNING, (Object)eg.getState());
        sourceFuture.complete(sourceSlot);
        Assert.assertThat((Object)gatewaySource.getSubmitTaskCount(), (Matcher)Matchers.is((Object)1));
        Assert.assertThat((Object)gatewayTarget.getSubmitTaskCount(), (Matcher)Matchers.is((Object)1));
        Assert.assertEquals((Object)JobStatus.RUNNING, (Object)eg.getState());
    }

    private TestingLogicalSlot createTestingLogicalSlot(InteractionsCountingTaskManagerGateway gatewaySource) {
        return new TestingLogicalSlotBuilder().setTaskManagerGateway(gatewaySource).createTestingLogicalSlot();
    }

    @Test
    public void testDeployPipelinedConnectedComponentsTogether() throws Exception {
        int i;
        int parallelism = 8;
        JobVertex sourceVertex = new JobVertex("source");
        sourceVertex.setParallelism(8);
        sourceVertex.setInvokableClass(NoOpInvokable.class);
        JobVertex targetVertex = new JobVertex("target");
        targetVertex.setParallelism(8);
        targetVertex.setInvokableClass(NoOpInvokable.class);
        targetVertex.connectNewDataSetAsInput(sourceVertex, DistributionPattern.ALL_TO_ALL, ResultPartitionType.PIPELINED);
        JobID jobId = new JobID();
        JobGraph jobGraph = new JobGraph(jobId, "test", new JobVertex[]{sourceVertex, targetVertex});
        jobGraph.setScheduleMode(ScheduleMode.EAGER);
        CompletableFuture[] sourceFutures = new CompletableFuture[8];
        CompletableFuture[] targetFutures = new CompletableFuture[8];
        InteractionsCountingTaskManagerGateway[] sourceTaskManagers = new InteractionsCountingTaskManagerGateway[8];
        InteractionsCountingTaskManagerGateway[] targetTaskManagers = new InteractionsCountingTaskManagerGateway[8];
        LogicalSlot[] sourceSlots = new LogicalSlot[8];
        LogicalSlot[] targetSlots = new LogicalSlot[8];
        for (int i2 = 0; i2 < 8; ++i2) {
            sourceTaskManagers[i2] = ExecutionGraphSchedulingTest.createTaskManager();
            targetTaskManagers[i2] = ExecutionGraphSchedulingTest.createTaskManager();
            sourceSlots[i2] = this.createTestingLogicalSlot(sourceTaskManagers[i2]);
            targetSlots[i2] = this.createTestingLogicalSlot(targetTaskManagers[i2]);
            sourceFutures[i2] = new CompletableFuture();
            targetFutures[i2] = new CompletableFuture();
        }
        ProgrammedSlotProvider slotProvider = new ProgrammedSlotProvider(8);
        slotProvider.addSlots(sourceVertex.getID(), sourceFutures);
        slotProvider.addSlots(targetVertex.getID(), targetFutures);
        ExecutionGraph eg = this.createExecutionGraph(jobGraph, (SlotProvider)slotProvider);
        for (i = 0; i < 8; i += 2) {
            sourceFutures[i].complete(sourceSlots[i]);
        }
        eg.start(ComponentMainThreadExecutorServiceAdapter.forMainThread());
        eg.scheduleForExecution();
        ExecutionGraphSchedulingTest.verifyNothingDeployed(eg, sourceTaskManagers);
        for (i = 1; i < 8; i += 2) {
            sourceFutures[i].complete(sourceSlots[i]);
        }
        ExecutionGraphSchedulingTest.verifyNothingDeployed(eg, sourceTaskManagers);
        for (i = 1; i < 8; ++i) {
            targetFutures[i].complete(targetSlots[i]);
        }
        ExecutionGraphSchedulingTest.verifyNothingDeployed(eg, targetTaskManagers);
        targetFutures[0].complete(targetSlots[0]);
        for (InteractionsCountingTaskManagerGateway gateway : sourceTaskManagers) {
            Assert.assertThat((Object)gateway.getSubmitTaskCount(), (Matcher)Matchers.is((Object)1));
        }
        for (InteractionsCountingTaskManagerGateway gateway : targetTaskManagers) {
            Assert.assertThat((Object)gateway.getSubmitTaskCount(), (Matcher)Matchers.is((Object)1));
        }
    }

    @Test
    public void testOneSlotFailureAbortsDeploy() throws Exception {
        int i;
        int parallelism = 6;
        JobVertex sourceVertex = new JobVertex("source");
        sourceVertex.setParallelism(6);
        sourceVertex.setInvokableClass(NoOpInvokable.class);
        JobVertex targetVertex = new JobVertex("target");
        targetVertex.setParallelism(6);
        targetVertex.setInvokableClass(NoOpInvokable.class);
        targetVertex.connectNewDataSetAsInput(sourceVertex, DistributionPattern.POINTWISE, ResultPartitionType.PIPELINED);
        JobID jobId = new JobID();
        JobGraph jobGraph = new JobGraph(jobId, "test", new JobVertex[]{sourceVertex, targetVertex});
        jobGraph.setScheduleMode(ScheduleMode.EAGER);
        InteractionsCountingTaskManagerGateway taskManager = ExecutionGraphSchedulingTest.createTaskManager();
        ArrayBlockingQueue returnedSlots = new ArrayBlockingQueue(6);
        TestingSlotOwner slotOwner = new TestingSlotOwner();
        slotOwner.setReturnAllocatedSlotConsumer(logicalSlot -> returnedSlots.offer(logicalSlot.getAllocationId()));
        LogicalSlot[] sourceSlots = new LogicalSlot[6];
        LogicalSlot[] targetSlots = new LogicalSlot[6];
        CompletableFuture[] sourceFutures = new CompletableFuture[6];
        CompletableFuture[] targetFutures = new CompletableFuture[6];
        for (int i2 = 0; i2 < 6; ++i2) {
            sourceSlots[i2] = ExecutionGraphSchedulingTest.createSingleLogicalSlot(slotOwner, taskManager, new SlotRequestId());
            targetSlots[i2] = ExecutionGraphSchedulingTest.createSingleLogicalSlot(slotOwner, taskManager, new SlotRequestId());
            sourceFutures[i2] = new CompletableFuture();
            targetFutures[i2] = new CompletableFuture();
        }
        ProgrammedSlotProvider slotProvider = new ProgrammedSlotProvider(6);
        slotProvider.addSlots(sourceVertex.getID(), sourceFutures);
        slotProvider.addSlots(targetVertex.getID(), targetFutures);
        ExecutionGraph eg = this.createExecutionGraph(jobGraph, (SlotProvider)slotProvider);
        eg.start(ComponentMainThreadExecutorServiceAdapter.forMainThread());
        for (i = 0; i < 6; i += 2) {
            sourceFutures[i].complete(sourceSlots[i]);
            targetFutures[i].complete(targetSlots[i]);
        }
        eg.scheduleForExecution();
        sourceFutures[1].completeExceptionally(new TestRuntimeException());
        eg.getTerminationFuture().get(2000L, TimeUnit.MILLISECONDS);
        for (i = 0; i < 6; ++i) {
            returnedSlots.poll(2000L, TimeUnit.MILLISECONDS);
        }
        Assert.assertThat((Object)taskManager.getSubmitTaskCount(), (Matcher)Matchers.is((Object)0));
        for (i = 0; i < 6; i += 2) {
            Assert.assertFalse((boolean)sourceSlots[i].isAlive());
            Assert.assertFalse((boolean)targetSlots[i].isAlive());
        }
    }

    @Test
    public void testEagerSchedulingWithSlotTimeout() throws Exception {
        int parallelism = 3;
        JobVertex vertex = new JobVertex("task");
        vertex.setParallelism(3);
        vertex.setInvokableClass(NoOpInvokable.class);
        JobID jobId = new JobID();
        JobGraph jobGraph = new JobGraph(jobId, "test", new JobVertex[]{vertex});
        jobGraph.setScheduleMode(ScheduleMode.EAGER);
        ArrayBlockingQueue returnedSlots = new ArrayBlockingQueue(2);
        TestingSlotOwner slotOwner = new TestingSlotOwner();
        slotOwner.setReturnAllocatedSlotConsumer(logicalSlot -> returnedSlots.offer(logicalSlot.getAllocationId()));
        InteractionsCountingTaskManagerGateway taskManager = ExecutionGraphSchedulingTest.createTaskManager();
        LogicalSlot[] slots = new LogicalSlot[3];
        CompletableFuture[] slotFutures = new CompletableFuture[3];
        for (int i = 0; i < 3; ++i) {
            slots[i] = ExecutionGraphSchedulingTest.createSingleLogicalSlot(slotOwner, taskManager, new SlotRequestId());
            slotFutures[i] = new CompletableFuture();
        }
        ProgrammedSlotProvider slotProvider = new ProgrammedSlotProvider(3);
        slotProvider.addSlots(vertex.getID(), slotFutures);
        ExecutionGraph eg = this.createExecutionGraph(jobGraph, (SlotProvider)slotProvider);
        slotFutures[1].complete(slots[1]);
        eg.start(ComponentMainThreadExecutorServiceAdapter.forMainThread());
        eg.scheduleForExecution();
        slotFutures[2].complete(slots[2]);
        Assert.assertThat((Object)eg.getTerminationFuture().isDone(), (Matcher)Matchers.is((Object)false));
        slotFutures[0].completeExceptionally(new TimeoutException("Test time out"));
        Assert.assertThat(eg.getTerminationFuture().get(), (Matcher)Matchers.is((Object)JobStatus.FAILED));
        for (int i = 0; i < 2; ++i) {
            returnedSlots.poll(2000L, TimeUnit.MILLISECONDS);
        }
        Assert.assertThat((Object)taskManager.getSubmitTaskCount(), (Matcher)Matchers.is((Object)0));
    }

    @Test
    public void testSchedulingOperationCancellationWhenCancel() throws Exception {
        JobVertex jobVertex = new JobVertex("NoOp JobVertex");
        jobVertex.setInvokableClass(NoOpInvokable.class);
        jobVertex.setParallelism(2);
        JobGraph jobGraph = new JobGraph(new JobVertex[]{jobVertex});
        jobGraph.setScheduleMode(ScheduleMode.EAGER);
        CompletableFuture<TestingLogicalSlot> slotFuture1 = new CompletableFuture<TestingLogicalSlot>();
        CompletableFuture<TestingLogicalSlot> slotFuture2 = new CompletableFuture<TestingLogicalSlot>();
        ProgrammedSlotProvider slotProvider = new ProgrammedSlotProvider(2);
        slotProvider.addSlots(jobVertex.getID(), new CompletableFuture[]{slotFuture1, slotFuture2});
        ExecutionGraph executionGraph = this.createExecutionGraph(jobGraph, (SlotProvider)slotProvider);
        executionGraph.start(ComponentMainThreadExecutorServiceAdapter.forMainThread());
        executionGraph.scheduleForExecution();
        TestingLogicalSlot slot = ExecutionGraphSchedulingTest.createTestingSlot();
        CompletableFuture<?> releaseFuture = slot.getReleaseFuture();
        slotFuture1.complete(slot);
        executionGraph.cancel();
        slotFuture2.complete(new TestingLogicalSlotBuilder().createTestingLogicalSlot());
        Thread.sleep(1L);
        releaseFuture.complete(null);
        Assert.assertThat(executionGraph.getTerminationFuture().get(), (Matcher)Matchers.is((Object)JobStatus.CANCELED));
    }

    @Test
    public void testSlotReleasingFailsSchedulingOperation() throws Exception {
        int parallelism = 2;
        JobVertex jobVertex = new JobVertex("Testing job vertex");
        jobVertex.setInvokableClass(NoOpInvokable.class);
        jobVertex.setParallelism(2);
        JobGraph jobGraph = new JobGraph(new JobVertex[]{jobVertex});
        jobGraph.setScheduleMode(ScheduleMode.EAGER);
        ProgrammedSlotProvider slotProvider = new ProgrammedSlotProvider(2);
        SingleLogicalSlot slot = ExecutionGraphSchedulingTest.createSingleLogicalSlot(new DummySlotOwner(), new SimpleAckingTaskManagerGateway(), new SlotRequestId());
        slotProvider.addSlot(jobVertex.getID(), 0, CompletableFuture.completedFuture(slot));
        CompletableFuture<LogicalSlot> slotFuture = new CompletableFuture<LogicalSlot>();
        slotProvider.addSlot(jobVertex.getID(), 1, slotFuture);
        ExecutionGraph executionGraph = this.createExecutionGraph(jobGraph, (SlotProvider)slotProvider);
        executionGraph.start(ComponentMainThreadExecutorServiceAdapter.forMainThread());
        executionGraph.scheduleForExecution();
        Assert.assertThat((Object)executionGraph.getState(), (Matcher)Matchers.is((Object)JobStatus.RUNNING));
        ExecutionJobVertex executionJobVertex = executionGraph.getJobVertex(jobVertex.getID());
        ExecutionVertex[] taskVertices = executionJobVertex.getTaskVertices();
        Assert.assertThat((Object)taskVertices[0].getExecutionState(), (Matcher)Matchers.is((Object)ExecutionState.SCHEDULED));
        Assert.assertThat((Object)taskVertices[1].getExecutionState(), (Matcher)Matchers.is((Object)ExecutionState.SCHEDULED));
        slot.releaseSlot((Throwable)new FlinkException("Test failure"));
        Assert.assertThat(executionGraph.getTerminationFuture().get(), (Matcher)Matchers.is((Object)JobStatus.FAILED));
    }

    @Test
    public void testCancellationOfIncompleteScheduling() throws Exception {
        int parallelism = 10;
        JobVertex jobVertex = new JobVertex("Test job vertex");
        jobVertex.setInvokableClass(NoOpInvokable.class);
        jobVertex.setParallelism(10);
        JobGraph jobGraph = new JobGraph(new JobVertex[]{jobVertex});
        jobGraph.setScheduleMode(ScheduleMode.EAGER);
        TestingSlotOwner slotOwner = new TestingSlotOwner();
        SimpleAckingTaskManagerGateway taskManagerGateway = new SimpleAckingTaskManagerGateway();
        ConcurrentHashMap slotRequestIds = new ConcurrentHashMap(10);
        TestingSlotProvider slotProvider = new TestingSlotProvider(slotRequestId -> {
            slotRequestIds.put(slotRequestId, 1);
            return slotRequestIds.size() % 2 == 0 ? CompletableFuture.completedFuture(ExecutionGraphSchedulingTest.createSingleLogicalSlot(slotOwner, taskManagerGateway, slotRequestId)) : new CompletableFuture();
        });
        ExecutionGraph executionGraph = this.createExecutionGraph(jobGraph, slotProvider);
        executionGraph.start(ComponentMainThreadExecutorServiceAdapter.forMainThread());
        ConcurrentHashMap.KeySetView slotRequestIdsToReturn = ConcurrentHashMap.newKeySet(slotRequestIds.size());
        executionGraph.scheduleForExecution();
        slotRequestIdsToReturn.addAll(slotRequestIds.keySet());
        slotOwner.setReturnAllocatedSlotConsumer(logicalSlot -> slotRequestIdsToReturn.remove(logicalSlot.getSlotRequestId()));
        slotProvider.setSlotCanceller(slotRequestIdsToReturn::remove);
        taskManagerGateway.setCancelConsumer(executionAttemptId -> {
            Execution execution = (Execution)executionGraph.getRegisteredExecutions().get(executionAttemptId);
            if (execution != null) {
                execution.completeCancelling();
            }
        });
        executionGraph.cancel();
        Assert.assertThat(slotRequestIdsToReturn, (Matcher)Matchers.is((Matcher)Matchers.empty()));
    }

    private ExecutionGraph createExecutionGraph(JobGraph jobGraph, SlotProvider slotProvider) throws Exception {
        return this.createExecutionGraph(jobGraph, slotProvider, Time.minutes((long)10L));
    }

    private ExecutionGraph createExecutionGraph(JobGraph jobGraph, SlotProvider slotProvider, Time timeout) throws Exception {
        return ExecutionGraphBuilder.buildGraph(null, (JobGraph)jobGraph, (Configuration)new Configuration(), (ScheduledExecutorService)this.executor, (Executor)this.executor, (SlotProvider)slotProvider, (ClassLoader)((Object)((Object)this)).getClass().getClassLoader(), (CheckpointRecoveryFactory)new StandaloneCheckpointRecoveryFactory(), (Time)timeout, (RestartStrategy)new NoRestartStrategy(), (MetricGroup)new UnregisteredMetricsGroup(), (BlobWriter)VoidBlobWriter.getInstance(), (Time)timeout, (Logger)this.log, (ShuffleMaster)NettyShuffleMaster.INSTANCE, (JobMasterPartitionTracker)NoOpJobMasterPartitionTracker.INSTANCE);
    }

    @Nonnull
    static SingleLogicalSlot createSingleLogicalSlot(SlotOwner slotOwner, TaskManagerGateway taskManagerGateway, SlotRequestId slotRequestId) {
        TaskManagerLocation location = new TaskManagerLocation(ResourceID.generate(), InetAddress.getLoopbackAddress(), 12345);
        SimpleSlotContext slotContext = new SimpleSlotContext(new AllocationID(), location, 0, taskManagerGateway);
        return new SingleLogicalSlot(slotRequestId, (SlotContext)slotContext, null, Locality.LOCAL, slotOwner);
    }

    private static InteractionsCountingTaskManagerGateway createTaskManager() {
        return new InteractionsCountingTaskManagerGateway();
    }

    private static void verifyNothingDeployed(ExecutionGraph eg, InteractionsCountingTaskManagerGateway[] taskManagers) {
        Assert.assertEquals((Object)JobStatus.RUNNING, (Object)eg.getState());
        for (InteractionsCountingTaskManagerGateway gateway : taskManagers) {
            Assert.assertThat((Object)gateway.getSubmitTaskCount(), (Matcher)Matchers.is((Object)0));
        }
    }

    @Nonnull
    private static TestingLogicalSlot createTestingSlot() {
        return new TestingLogicalSlotBuilder().setAutomaticallyCompleteReleaseFuture(false).createTestingLogicalSlot();
    }

    private static class TestRuntimeException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        private TestRuntimeException() {
        }
    }
}

