/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.executiongraph;

import org.apache.flink.api.common.time.Time;
import org.apache.flink.runtime.executiongraph.ExecutionGraphTestUtils;
import org.apache.flink.runtime.executiongraph.ExecutionJobVertex;
import org.apache.flink.runtime.executiongraph.ExecutionVertex;
import org.apache.flink.runtime.executiongraph.IntermediateResult;
import org.apache.flink.runtime.executiongraph.IntermediateResultPartition;
import org.apache.flink.runtime.io.network.partition.ResultPartitionType;
import org.apache.flink.runtime.jobgraph.IntermediateDataSetID;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.testutils.DirectScheduledExecutorService;
import org.apache.flink.util.TestLogger;
import org.junit.Assert;
import org.junit.Test;

public class IntermediateResultPartitionTest
extends TestLogger {
    @Test
    public void testPipelinedPartitionConsumable() throws Exception {
        IntermediateResult result = IntermediateResultPartitionTest.createResult(ResultPartitionType.PIPELINED, 2);
        IntermediateResultPartition partition1 = result.getPartitions()[0];
        IntermediateResultPartition partition2 = result.getPartitions()[1];
        Assert.assertFalse((boolean)partition1.isConsumable());
        Assert.assertFalse((boolean)partition2.isConsumable());
        partition1.markDataProduced();
        Assert.assertTrue((boolean)partition1.isConsumable());
        Assert.assertFalse((boolean)partition2.isConsumable());
        result.resetForNewExecution();
        Assert.assertFalse((boolean)partition1.isConsumable());
        Assert.assertFalse((boolean)partition2.isConsumable());
    }

    @Test
    public void testBlockingPartitionConsumable() throws Exception {
        IntermediateResult result = IntermediateResultPartitionTest.createResult(ResultPartitionType.BLOCKING, 2);
        IntermediateResultPartition partition1 = result.getPartitions()[0];
        IntermediateResultPartition partition2 = result.getPartitions()[1];
        Assert.assertFalse((boolean)partition1.isConsumable());
        Assert.assertFalse((boolean)partition2.isConsumable());
        partition1.markFinished();
        Assert.assertFalse((boolean)partition1.isConsumable());
        Assert.assertFalse((boolean)partition2.isConsumable());
        Assert.assertFalse((boolean)result.areAllPartitionsFinished());
        partition2.markFinished();
        Assert.assertTrue((boolean)partition1.isConsumable());
        Assert.assertTrue((boolean)partition2.isConsumable());
        Assert.assertTrue((boolean)result.areAllPartitionsFinished());
        result.resetForNewExecution();
        Assert.assertFalse((boolean)partition1.isConsumable());
        Assert.assertFalse((boolean)partition2.isConsumable());
        Assert.assertFalse((boolean)result.areAllPartitionsFinished());
    }

    @Test
    public void testBlockingPartitionResetting() throws Exception {
        IntermediateResult result = IntermediateResultPartitionTest.createResult(ResultPartitionType.BLOCKING, 2);
        IntermediateResultPartition partition1 = result.getPartitions()[0];
        IntermediateResultPartition partition2 = result.getPartitions()[1];
        Assert.assertFalse((boolean)partition1.isConsumable());
        Assert.assertFalse((boolean)partition2.isConsumable());
        partition1.markFinished();
        Assert.assertEquals((long)1L, (long)result.getNumberOfRunningProducers());
        Assert.assertFalse((boolean)partition1.isConsumable());
        Assert.assertFalse((boolean)partition2.isConsumable());
        Assert.assertFalse((boolean)result.areAllPartitionsFinished());
        result.resetForNewExecution();
        Assert.assertEquals((long)2L, (long)result.getNumberOfRunningProducers());
        partition2.markFinished();
        Assert.assertEquals((long)1L, (long)result.getNumberOfRunningProducers());
        Assert.assertFalse((boolean)partition1.isConsumable());
        Assert.assertFalse((boolean)partition2.isConsumable());
        Assert.assertFalse((boolean)result.areAllPartitionsFinished());
        partition1.markFinished();
        Assert.assertEquals((long)0L, (long)result.getNumberOfRunningProducers());
        Assert.assertTrue((boolean)partition1.isConsumable());
        Assert.assertTrue((boolean)partition2.isConsumable());
        Assert.assertTrue((boolean)result.areAllPartitionsFinished());
        result.resetForNewExecution();
        Assert.assertEquals((long)2L, (long)result.getNumberOfRunningProducers());
        Assert.assertFalse((boolean)partition1.isConsumable());
        Assert.assertFalse((boolean)partition2.isConsumable());
        Assert.assertFalse((boolean)result.areAllPartitionsFinished());
    }

    private static IntermediateResult createResult(ResultPartitionType resultPartitionType, int producerCount) throws Exception {
        ExecutionJobVertex jobVertex = ExecutionGraphTestUtils.getExecutionJobVertex(new JobVertexID(), new DirectScheduledExecutorService());
        IntermediateResult result = new IntermediateResult(new IntermediateDataSetID(), jobVertex, producerCount, resultPartitionType);
        for (int i = 0; i < producerCount; ++i) {
            new ExecutionVertex(jobVertex, i, new IntermediateResult[]{result}, Time.minutes((long)1L));
        }
        return result;
    }
}

