/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.executiongraph;

import java.util.ArrayList;
import java.util.Arrays;
import org.apache.flink.api.common.operators.ResourceSpec;
import org.apache.flink.runtime.executiongraph.ExecutionGraph;
import org.apache.flink.runtime.executiongraph.TestingExecutionGraphBuilder;
import org.apache.flink.runtime.io.network.partition.ResultPartitionType;
import org.apache.flink.runtime.jobgraph.DistributionPattern;
import org.apache.flink.runtime.jobgraph.JobVertex;
import org.apache.flink.runtime.jobgraph.tasks.AbstractInvokable;
import org.apache.flink.runtime.jobmanager.scheduler.SlotSharingGroup;
import org.junit.Assert;
import org.junit.Test;

public class VertexSlotSharingTest {
    @Test
    public void testAssignSlotSharingGroup() {
        try {
            JobVertex v1 = new JobVertex("v1");
            JobVertex v2 = new JobVertex("v2");
            JobVertex v3 = new JobVertex("v3");
            JobVertex v4 = new JobVertex("v4");
            JobVertex v5 = new JobVertex("v5");
            v1.setParallelism(4);
            v2.setParallelism(5);
            v3.setParallelism(7);
            v4.setParallelism(1);
            v5.setParallelism(11);
            v1.setInvokableClass(AbstractInvokable.class);
            v2.setInvokableClass(AbstractInvokable.class);
            v3.setInvokableClass(AbstractInvokable.class);
            v4.setInvokableClass(AbstractInvokable.class);
            v5.setInvokableClass(AbstractInvokable.class);
            v2.connectNewDataSetAsInput(v1, DistributionPattern.POINTWISE, ResultPartitionType.PIPELINED);
            v5.connectNewDataSetAsInput(v4, DistributionPattern.POINTWISE, ResultPartitionType.PIPELINED);
            SlotSharingGroup jg1 = new SlotSharingGroup();
            v2.setSlotSharingGroup(jg1);
            v3.setSlotSharingGroup(jg1);
            SlotSharingGroup jg2 = new SlotSharingGroup();
            v4.setSlotSharingGroup(jg2);
            v5.setSlotSharingGroup(jg2);
            ArrayList<JobVertex> vertices = new ArrayList<JobVertex>(Arrays.asList(v1, v2, v3, v4, v5));
            ExecutionGraph eg = TestingExecutionGraphBuilder.newBuilder().build();
            eg.attachJobGraph(vertices);
            Assert.assertNull((Object)eg.getJobVertex(v1.getID()).getSlotSharingGroup());
            SlotSharingGroup group1 = eg.getJobVertex(v2.getID()).getSlotSharingGroup();
            Assert.assertNotNull((Object)group1);
            Assert.assertEquals((Object)group1, (Object)eg.getJobVertex(v3.getID()).getSlotSharingGroup());
            Assert.assertEquals((long)2L, (long)group1.getJobVertexIds().size());
            Assert.assertTrue((boolean)group1.getJobVertexIds().contains(v2.getID()));
            Assert.assertTrue((boolean)group1.getJobVertexIds().contains(v3.getID()));
            SlotSharingGroup group2 = eg.getJobVertex(v4.getID()).getSlotSharingGroup();
            Assert.assertNotNull((Object)group2);
            Assert.assertEquals((Object)group2, (Object)eg.getJobVertex(v5.getID()).getSlotSharingGroup());
            Assert.assertEquals((long)2L, (long)group1.getJobVertexIds().size());
            Assert.assertTrue((boolean)group2.getJobVertexIds().contains(v4.getID()));
            Assert.assertTrue((boolean)group2.getJobVertexIds().contains(v5.getID()));
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testSlotSharingGroupWithSpecifiedResources() {
        ResourceSpec resource1 = ResourceSpec.newBuilder((double)0.1, (int)100).build();
        ResourceSpec resource2 = ResourceSpec.newBuilder((double)0.2, (int)200).build();
        JobVertex v1 = new JobVertex("v1");
        JobVertex v2 = new JobVertex("v2");
        v1.setResources(resource1, resource1);
        v2.setResources(resource2, resource2);
        SlotSharingGroup group1 = new SlotSharingGroup();
        SlotSharingGroup group2 = new SlotSharingGroup();
        v1.setSlotSharingGroup(group1);
        Assert.assertEquals((Object)resource1, (Object)group1.getResourceSpec());
        v2.setSlotSharingGroup(group1);
        Assert.assertEquals((Object)resource1.merge(resource2), (Object)group1.getResourceSpec());
        v1.setSlotSharingGroup(group2);
        Assert.assertEquals((Object)resource1, (Object)group2.getResourceSpec());
        Assert.assertEquals((Object)resource2, (Object)group1.getResourceSpec());
    }

    @Test
    public void testSlotSharingGroupWithUnknownResources() {
        JobVertex v1 = new JobVertex("v1");
        v1.setResources(ResourceSpec.UNKNOWN, ResourceSpec.UNKNOWN);
        SlotSharingGroup group1 = new SlotSharingGroup();
        v1.setSlotSharingGroup(group1);
        Assert.assertEquals((Object)ResourceSpec.UNKNOWN, (Object)group1.getResourceSpec());
    }
}

