/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.executiongraph.restart;

import java.time.Duration;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.RestartStrategyOptions;
import org.apache.flink.runtime.executiongraph.restart.FixedDelayRestartStrategy;
import org.apache.flink.runtime.executiongraph.restart.NoOrFixedIfCheckpointingEnabledRestartStrategyFactory;
import org.apache.flink.runtime.executiongraph.restart.RestartStrategyFactory;
import org.apache.flink.util.TestLogger;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;

public class RestartStrategyFactoryTest
extends TestLogger {
    @Test
    public void createRestartStrategyFactory_noRestartStrategyConfigured_returnsNoOrFixedIfCheckpointingEnabledRestartStrategyFactory() throws Exception {
        Configuration configuration = new Configuration();
        RestartStrategyFactory restartStrategyFactory = RestartStrategyFactory.createRestartStrategyFactory((Configuration)configuration);
        MatcherAssert.assertThat((Object)restartStrategyFactory, (Matcher)CoreMatchers.instanceOf(NoOrFixedIfCheckpointingEnabledRestartStrategyFactory.class));
    }

    @Test
    public void createRestartStrategyFactory_noRestartStrategyButAttemptsConfigured_returnsNoOrFixedIfCheckpointingEnabledRestartStrategyFactory() throws Exception {
        Configuration configuration = new Configuration();
        configuration.setInteger(RestartStrategyOptions.RESTART_STRATEGY_FIXED_DELAY_ATTEMPTS, 1);
        RestartStrategyFactory restartStrategyFactory = RestartStrategyFactory.createRestartStrategyFactory((Configuration)configuration);
        MatcherAssert.assertThat((Object)restartStrategyFactory, (Matcher)CoreMatchers.instanceOf(NoOrFixedIfCheckpointingEnabledRestartStrategyFactory.class));
    }

    @Test
    public void createRestartStrategyFactory_fixedDelayRestartStrategyConfigured_returnsConfiguredFixedDelayRestartStrategy() throws Exception {
        int attempts = 42;
        Duration delayBetweenRestartAttempts = Duration.ofSeconds(1337L);
        Configuration configuration = new Configuration();
        configuration.setString(RestartStrategyOptions.RESTART_STRATEGY, "fixed-delay");
        configuration.setInteger(RestartStrategyOptions.RESTART_STRATEGY_FIXED_DELAY_ATTEMPTS, 42);
        configuration.set(RestartStrategyOptions.RESTART_STRATEGY_FIXED_DELAY_DELAY, (Object)delayBetweenRestartAttempts);
        RestartStrategyFactory restartStrategyFactory = RestartStrategyFactory.createRestartStrategyFactory((Configuration)configuration);
        MatcherAssert.assertThat((Object)restartStrategyFactory, (Matcher)CoreMatchers.instanceOf(FixedDelayRestartStrategy.FixedDelayRestartStrategyFactory.class));
        FixedDelayRestartStrategy.FixedDelayRestartStrategyFactory fixedDelayRestartStrategyFactory = (FixedDelayRestartStrategy.FixedDelayRestartStrategyFactory)restartStrategyFactory;
        MatcherAssert.assertThat((Object)fixedDelayRestartStrategyFactory.getMaxNumberRestartAttempts(), (Matcher)CoreMatchers.is((Object)42));
        MatcherAssert.assertThat((Object)fixedDelayRestartStrategyFactory.getDelayBetweenRestartAttempts(), (Matcher)CoreMatchers.is((Object)delayBetweenRestartAttempts.toMillis()));
    }
}

