/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.executiongraph.restart;

import org.apache.flink.api.common.restartstrategy.RestartStrategies;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.runtime.executiongraph.restart.FailureRateRestartStrategy;
import org.apache.flink.runtime.executiongraph.restart.FixedDelayRestartStrategy;
import org.apache.flink.runtime.executiongraph.restart.NoOrFixedIfCheckpointingEnabledRestartStrategyFactory;
import org.apache.flink.runtime.executiongraph.restart.NoRestartStrategy;
import org.apache.flink.runtime.executiongraph.restart.RestartStrategy;
import org.apache.flink.runtime.executiongraph.restart.RestartStrategyFactory;
import org.apache.flink.runtime.executiongraph.restart.RestartStrategyResolving;
import org.apache.flink.util.TestLogger;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;

public class RestartStrategyResolvingTest
extends TestLogger {
    @Test
    public void testClientSideHighestPriority() {
        RestartStrategy resolvedStrategy = RestartStrategyResolving.resolve((RestartStrategies.RestartStrategyConfiguration)RestartStrategies.noRestart(), (RestartStrategyFactory)new FixedDelayRestartStrategy.FixedDelayRestartStrategyFactory(2, 1000L), (boolean)true);
        MatcherAssert.assertThat((Object)resolvedStrategy, (Matcher)Matchers.instanceOf(NoRestartStrategy.class));
    }

    @Test
    public void testFixedStrategySetWhenCheckpointingEnabled() {
        RestartStrategy resolvedStrategy = RestartStrategyResolving.resolve((RestartStrategies.RestartStrategyConfiguration)RestartStrategies.fallBackRestart(), (RestartStrategyFactory)new NoOrFixedIfCheckpointingEnabledRestartStrategyFactory(), (boolean)true);
        MatcherAssert.assertThat((Object)resolvedStrategy, (Matcher)Matchers.instanceOf(FixedDelayRestartStrategy.class));
    }

    @Test
    public void testServerStrategyIsUsedSetWhenCheckpointingEnabled() {
        RestartStrategy resolvedStrategy = RestartStrategyResolving.resolve((RestartStrategies.RestartStrategyConfiguration)RestartStrategies.fallBackRestart(), (RestartStrategyFactory)new FailureRateRestartStrategy.FailureRateRestartStrategyFactory(5, Time.seconds((long)5L), Time.seconds((long)2L)), (boolean)true);
        MatcherAssert.assertThat((Object)resolvedStrategy, (Matcher)Matchers.instanceOf(FailureRateRestartStrategy.class));
    }

    @Test
    public void testServerStrategyIsUsedSetWhenCheckpointingDisabled() {
        RestartStrategy resolvedStrategy = RestartStrategyResolving.resolve((RestartStrategies.RestartStrategyConfiguration)RestartStrategies.fallBackRestart(), (RestartStrategyFactory)new FailureRateRestartStrategy.FailureRateRestartStrategyFactory(5, Time.seconds((long)5L), Time.seconds((long)2L)), (boolean)false);
        MatcherAssert.assertThat((Object)resolvedStrategy, (Matcher)Matchers.instanceOf(FailureRateRestartStrategy.class));
    }
}

